/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.ui.editor.options;

import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.common.ui.options.ApplicationArchiveNameDefaultValueImpl;
import oracle.adfmf.framework.dt.deploy.common.ui.options.ApplicationBundleIdDefaultValueImpl;
import oracle.ide.model.Workspace;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;

public class DeploymentOptions
extends DefaultLinkedDirtyable
implements Copyable {
    private final HashStructure _hash;
    private String _defaultApplicationArchiveName;
    private String _defaultApplicationBundleId;
    public static final String KEY_HASH_STRUCTURE = "iosDeploymentOptions";
    private static final String KEY_APP_BUNDLE_ID = "appBundleId";
    private static final String KEY_APP_ARCHIVE_NAME = "appArchiveName";
    private static final String KEY_USE_PRERENDERED_ICONS = "prerenderedIcons";
    private static final String KEY_DEPLOY_TARGET_VERSION = "deployTargetVersion";
    private static final String KEY_SIMULATOR_TARGET_VERSION = "emulatorTargetVersion";
    private static final String KEY_TARGET_FAMILY = "targetFamilyVersion";
    private static final String KEY_DEBUG_FLAG = "debugFlag";
    private static final String KEY_IPHONE_SUPPORTED_ORIENTATIONS_PORTRAIT = "iPhoneOrientationPortrait";
    private static final String KEY_IPHONE_SUPPORTED_ORIENTATIONS_PORTRAIT_UPSIDEDOWN = "iPhoneOrientationPortraitUpsideDown";
    private static final String KEY_IPHONE_SUPPORTED_ORIENTATIONS_LANDSCAPE_LEFT = "iPhoneOrientationLandscapeLeft";
    private static final String KEY_IPHONE_SUPPORTED_ORIENTATIONS_LANDSCAPE_RIGHT = "iPhoneOrientationLandscapeRight";
    private static final String KEY_IPAD_SUPPORTED_ORIENTATIONS_PORTRAIT = "iPadOrientationPortrait";
    private static final String KEY_IPAD_SUPPORTED_ORIENTATIONS_PORTRAIT_UPSIDEDOWN = "iPadOrientationPortraitUpsideDown";
    private static final String KEY_IPAD_SUPPORTED_ORIENTATIONS_LANDSCAPE_LEFT = "iPadOrientationLandscapeLeft";
    private static final String KEY_IPAD_SUPPORTED_ORIENTATIONS_LANDSCAPE_RIGHT = "iPadOrientationLandscapeRight";
    private static final String SIMULATOR_TARGET_VERSION_DEFAULT_VALUE = "HighestAvailable";

    public static String getHashStructureKeyName() {
        return KEY_HASH_STRUCTURE;
    }

    public static DeploymentOptions newDeploymentOptions(Namespace data) {
        if (null == data) {
            throw new IllegalArgumentException();
        }
        Object iosDataObject = data.find(KEY_HASH_STRUCTURE);
        if (null == iosDataObject || !(iosDataObject instanceof DeploymentOptions)) {
            throw new IllegalArgumentException();
        }
        DeploymentOptions deploymentOptions = (DeploymentOptions)((Object)iosDataObject);
        assert (null != deploymentOptions._defaultApplicationArchiveName);
        assert (null != deploymentOptions._defaultApplicationBundleId);
        return deploymentOptions;
    }

    public static DeploymentOptions newDeploymentOptions(HashStructure hash, Workspace workspace) {
        if (null == hash || null == workspace) {
            throw new IllegalArgumentException();
        }
        DeploymentOptions deploymentOptions = new DeploymentOptions(hash);
        deploymentOptions._initialize(workspace);
        return deploymentOptions;
    }

    public Object copyTo(Object target) {
        if (null != target && !(target instanceof DeploymentOptions)) {
            throw new IllegalArgumentException();
        }
        if (null == this._defaultApplicationArchiveName || null == this._defaultApplicationBundleId) {
            throw new IllegalStateException();
        }
        DeploymentOptions copy = target != null ? (DeploymentOptions)((Object)target) : new DeploymentOptions(HashStructure.newInstance());
        this._copyToImpl(copy);
        return copy;
    }

    public String getAppBundleId() {
        if (null == this._defaultApplicationBundleId) {
            throw new IllegalStateException();
        }
        return this.getHashStructure().getString(KEY_APP_BUNDLE_ID, this._defaultApplicationBundleId);
    }

    public void setAppBundleId(String value) {
        if (ModelUtil.areDifferent((Object)this.getAppBundleId(), (Object)value)) {
            this.getHashStructure().putString(KEY_APP_BUNDLE_ID, value);
            this.markDirty(true);
        }
    }

    public String getApplicationArchiveName() {
        if (null == this._defaultApplicationArchiveName) {
            throw new IllegalStateException();
        }
        String appArchiveName = this.getHashStructure().getString(KEY_APP_ARCHIVE_NAME, this._defaultApplicationArchiveName);
        return appArchiveName;
    }

    public void setApplicationArchiveName(String value) {
        if (ModelUtil.areDifferent((Object)this.getApplicationArchiveName(), (Object)value)) {
            this.getHashStructure().putString(KEY_APP_ARCHIVE_NAME, value);
            this.markDirty(true);
        }
    }

    public boolean getUsePrerenderedIcons() {
        return this.getHashStructure().getBoolean(KEY_USE_PRERENDERED_ICONS, false);
    }

    public void setUsePrerenderedIcons(boolean value) {
        if (ModelUtil.areDifferent((Object)this.getUsePrerenderedIcons(), (Object)value)) {
            this.getHashStructure().putBoolean(KEY_USE_PRERENDERED_ICONS, value);
            this.markDirty(true);
        }
    }

    public String getDeployTargetVersion() {
        return this.getHashStructure().getString(KEY_DEPLOY_TARGET_VERSION, this.getDefaultDeploymentTargetVersion());
    }

    public void setDeployTargetVersion(String value) {
        if (ModelUtil.areDifferent((Object)this.getDeployTargetVersion(), (Object)value)) {
            this.getHashStructure().putString(KEY_DEPLOY_TARGET_VERSION, value);
            this.markDirty(true);
        }
    }

    public String getSimulatorTargetVersion() {
        return this.getHashStructure().getString(KEY_SIMULATOR_TARGET_VERSION, this.getSimulatorDefaultTargetVersionValue());
    }

    public String getSimulatorDefaultTargetVersionValue() {
        return SIMULATOR_TARGET_VERSION_DEFAULT_VALUE;
    }

    public void setSimulatorTargetVersion(String value) {
        if (ModelUtil.areDifferent((Object)this.getSimulatorTargetVersion(), (Object)value)) {
            this.getHashStructure().putString(KEY_SIMULATOR_TARGET_VERSION, value);
            this.markDirty(true);
        }
    }

    public String getTargetFamily() {
        return this.getHashStructure().getString(KEY_TARGET_FAMILY, this.getDefaultTargetFamily());
    }

    public void setTargetFamily(String value) {
        if (ModelUtil.areDifferent((Object)this.getTargetFamily(), (Object)value)) {
            this.getHashStructure().putString(KEY_TARGET_FAMILY, value);
            this.markDirty(true);
        }
    }

    public boolean getDebugFlag() {
        return this.getHashStructure().getBoolean(KEY_DEBUG_FLAG, true);
    }

    public void setDebugFlag(boolean value) {
        if (ModelUtil.areDifferent((Object)this.getDebugFlag(), (Object)value)) {
            this.getHashStructure().putBoolean(KEY_DEBUG_FLAG, value);
            this.markDirty(true);
        }
    }

    public boolean getIphoneOrientationSupportPortrait() {
        return this.getHashStructure().getBoolean(KEY_IPHONE_SUPPORTED_ORIENTATIONS_PORTRAIT, true);
    }

    public void setIphoneOrientationSupportPortrait(boolean value) {
        if (ModelUtil.areDifferent((Object)this.getIphoneOrientationSupportPortrait(), (Object)value)) {
            this.getHashStructure().putBoolean(KEY_IPHONE_SUPPORTED_ORIENTATIONS_PORTRAIT, value);
            this.markDirty(true);
        }
    }

    public boolean getIphoneOrientationSupportPortraitUpsideDown() {
        return this.getHashStructure().getBoolean(KEY_IPHONE_SUPPORTED_ORIENTATIONS_PORTRAIT_UPSIDEDOWN, true);
    }

    public void setIphoneOrientationSupportPortraitUpsideDown(boolean value) {
        if (ModelUtil.areDifferent((Object)this.getIphoneOrientationSupportPortraitUpsideDown(), (Object)value)) {
            this.getHashStructure().putBoolean(KEY_IPHONE_SUPPORTED_ORIENTATIONS_PORTRAIT_UPSIDEDOWN, value);
            this.markDirty(true);
        }
    }

    public boolean getIphoneOrientationSupportLandscapeLeft() {
        return this.getHashStructure().getBoolean(KEY_IPHONE_SUPPORTED_ORIENTATIONS_LANDSCAPE_LEFT, true);
    }

    public void setIphoneOrientationSupportLandscapeLeft(boolean value) {
        if (ModelUtil.areDifferent((Object)this.getIphoneOrientationSupportLandscapeLeft(), (Object)value)) {
            this.getHashStructure().putBoolean(KEY_IPHONE_SUPPORTED_ORIENTATIONS_LANDSCAPE_LEFT, value);
            this.markDirty(true);
        }
    }

    public boolean getIphoneOrientationSupportLandscapeRight() {
        return this.getHashStructure().getBoolean(KEY_IPHONE_SUPPORTED_ORIENTATIONS_LANDSCAPE_RIGHT, true);
    }

    public void setIphoneOrientationSupportLandscapeRight(boolean value) {
        if (ModelUtil.areDifferent((Object)this.getIphoneOrientationSupportLandscapeRight(), (Object)value)) {
            this.getHashStructure().putBoolean(KEY_IPHONE_SUPPORTED_ORIENTATIONS_LANDSCAPE_RIGHT, value);
            this.markDirty(true);
        }
    }

    public boolean getIpadOrientationSupportPortrait() {
        return this.getHashStructure().getBoolean(KEY_IPAD_SUPPORTED_ORIENTATIONS_PORTRAIT, true);
    }

    public void setIpadOrientationSupportPortrait(boolean value) {
        if (ModelUtil.areDifferent((Object)this.getIpadOrientationSupportPortrait(), (Object)value)) {
            this.getHashStructure().putBoolean(KEY_IPAD_SUPPORTED_ORIENTATIONS_PORTRAIT, value);
            this.markDirty(true);
        }
    }

    public boolean getIpadOrientationSupportPortraitUpsideDown() {
        return this.getHashStructure().getBoolean(KEY_IPAD_SUPPORTED_ORIENTATIONS_PORTRAIT_UPSIDEDOWN, true);
    }

    public void setIpadOrientationSupportPortraitUpsideDown(boolean value) {
        if (ModelUtil.areDifferent((Object)this.getIpadOrientationSupportPortraitUpsideDown(), (Object)value)) {
            this.getHashStructure().putBoolean(KEY_IPAD_SUPPORTED_ORIENTATIONS_PORTRAIT_UPSIDEDOWN, value);
            this.markDirty(true);
        }
    }

    public boolean getIpadOrientationSupportLandscapeLeft() {
        return this.getHashStructure().getBoolean(KEY_IPAD_SUPPORTED_ORIENTATIONS_LANDSCAPE_LEFT, true);
    }

    public void setIpadOrientationSupportLandscapeLeft(boolean value) {
        if (ModelUtil.areDifferent((Object)this.getIpadOrientationSupportLandscapeLeft(), (Object)value)) {
            this.getHashStructure().putBoolean(KEY_IPAD_SUPPORTED_ORIENTATIONS_LANDSCAPE_LEFT, value);
            this.markDirty(true);
        }
    }

    public boolean getIpadOrientationSupportLandscapeRight() {
        return this.getHashStructure().getBoolean(KEY_IPAD_SUPPORTED_ORIENTATIONS_LANDSCAPE_RIGHT, true);
    }

    public void setIpadOrientationSupportLandscapeRight(boolean value) {
        if (ModelUtil.areDifferent((Object)this.getIpadOrientationSupportLandscapeRight(), (Object)value)) {
            this.getHashStructure().putBoolean(KEY_IPAD_SUPPORTED_ORIENTATIONS_LANDSCAPE_RIGHT, value);
            this.markDirty(true);
        }
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (null == this._defaultApplicationArchiveName || null == this._defaultApplicationBundleId) {
            throw new IllegalStateException();
        }
        return this._equalsImpl((DeploymentOptions)((Object)o));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 17;
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._hash);
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._defaultApplicationArchiveName);
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._defaultApplicationBundleId);
        return result;
    }

    public String getDefaultDeploymentTargetVersion() {
        return "5.0";
    }

    private String getDefaultTargetFamily() {
        return MobileResourceUtils.getText("BUILD_OPTIONS_DEPLOY_TARGET_DEFAULT");
    }

    private void _initialize(Workspace workspace) {
        if (null != this._defaultApplicationBundleId && null != this._defaultApplicationArchiveName) {
            throw new IllegalStateException();
        }
        ApplicationBundleIdDefaultValueImpl defaultAppBundleId = new ApplicationBundleIdDefaultValueImpl(workspace);
        this._defaultApplicationBundleId = defaultAppBundleId.getDefaultValue();
        ApplicationArchiveNameDefaultValueImpl defaultAppArchiveName = new ApplicationArchiveNameDefaultValueImpl(workspace);
        this._defaultApplicationArchiveName = defaultAppArchiveName.getDefaultValue();
    }

    private void _copyToImpl(DeploymentOptions target) {
        this._hash.copyTo(target._hash);
        target._defaultApplicationBundleId = this._defaultApplicationBundleId;
        target._defaultApplicationArchiveName = this._defaultApplicationArchiveName;
    }

    private boolean _equalsImpl(DeploymentOptions opts) {
        return ModelUtil.areEqual((Object)this._hash, (Object)opts._hash) && ModelUtil.areEqual((Object)this._defaultApplicationArchiveName, (Object)opts._defaultApplicationArchiveName) && ModelUtil.areEqual((Object)this._defaultApplicationBundleId, (Object)opts._defaultApplicationBundleId);
    }

    private DeploymentOptions(HashStructure hash) {
        this._hash = hash;
    }
}

