/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.ui.editor;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.editor.McArchiveEditor;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.options.DeploymentOptions;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.panels.DeploymentOptionsPanel;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.panels.DeviceOrientationsPanel;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.panels.IosImagePanel;
import oracle.ide.Context;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.util.Namespace;

public class IosArchiveEditor
extends McArchiveEditor {
    private static final String KEY_IOS_FRAMEWORK_APP_IMAGE_OPTIONS = "mc-app-images";
    private static final int IOS_EDITOR_ADDITIONAL_PIXEL_HEIGHT = 47;

    public IosArchiveEditor(String title, McIosFrameworkProfile profile, Context context) {
        super(title, profile, context);
    }

    protected void initLauncher(TDialogLauncher launcher) {
        super.initLauncher(launcher);
        Dimension initialDimension = launcher.getInitialSize();
        Dimension newDimension = new Dimension((int)initialDimension.getWidth(), (int)initialDimension.getHeight() + 47);
        launcher.setInitialSize(newDimension);
    }

    @Override
    protected Navigable[] getNavigables() {
        ArrayList<Navigable> newNavs = new ArrayList<Navigable>();
        Navigable[] jarArchiverNavs = super.getNavigables();
        newNavs.addAll(Arrays.asList(jarArchiverNavs));
        Navigable[] oMcIconOptionsNav = new Navigable[]{new Navigable(MobileResourceUtils.getText("APPLICATION_IMAGE"), IosImagePanel.class), new Navigable(MobileResourceUtils.getText("DEVICE_ORIENTATIONS"), DeviceOrientationsPanel.class)};
        newNavs.add(new Navigable(MobileResourceUtils.getText("IOS_FRAMEWORK_OPTIONS_PANEL_NAME"), DeploymentOptionsPanel.class, oMcIconOptionsNav));
        return this.convertToNavsArray(newNavs);
    }

    protected void scatterData(Namespace ns) {
        super.scatterData(ns);
        McIosFrameworkProfile profile = McIosFrameworkProfile.newMcIosFrameworkProfile(ns);
        IosArchiveEditor.scatterMcProfile(profile, ns);
    }

    protected void gatherData(Namespace ns) {
        super.gatherData(ns);
        IosArchiveEditor.gatherMcProfile(McIosFrameworkProfile.newMcIosFrameworkProfile(ns), ns);
    }

    public static void scatterMcProfile(McIosFrameworkProfile profile, Namespace data) {
        IosArchiveEditor.setDeploymentOptions(profile.getDeploymentOptions(), data);
        IosArchiveEditor.setImageOptions(profile.getImageOptions(), data);
    }

    public static void gatherMcProfile(McIosFrameworkProfile profile, Namespace data) {
        profile.setDeploymentOptions(IosArchiveEditor.getDeploymentOptions(data));
        profile.setImageOptions(IosArchiveEditor.getImageOptions(data));
    }

    public static DeploymentOptions getDeploymentOptions(Namespace data) {
        return DeploymentOptions.newDeploymentOptions(data);
    }

    public static void setDeploymentOptions(DeploymentOptions opts, Namespace data) {
        data.findAndReplace(DeploymentOptions.getHashStructureKeyName(), (Object)opts);
    }

    public static ImageOptions getImageOptions(Namespace data) {
        return (ImageOptions)((Object)data.find(KEY_IOS_FRAMEWORK_APP_IMAGE_OPTIONS));
    }

    public static void setImageOptions(ImageOptions opts, Namespace data) {
        data.findAndReplace(KEY_IOS_FRAMEWORK_APP_IMAGE_OPTIONS, (Object)opts);
    }
}

