/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.deployers;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployer;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public class ValidateXcodeDeployer
extends AbstractDeployer {
    public ValidateXcodeDeployer(int deploySequence) {
        super(deploySequence);
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        Logger logger = deployShell.getLogger();
        boolean xCodeFound = false;
        boolean completedValidation = false;
        try {
            McIosFrameworkProfile profile = IosDeployUtil.getMcIosFrameworkProfile(deployShell);
            Workspace workspace = deployShell.getContext().getWorkspace();
            String workspaceName = McAppUtils.getWorkspaceName(workspace);
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21001", workspaceName, profile.getName()));
            if (logger.getLevel() == Level.FINEST) {
                logger.log(Level.FINEST, "Validating that the Xcode product is installed.");
            }
            xCodeFound = IosDeployer.isXcodeInstalled(logger);
            completedValidation = true;
        }
        catch (Exception e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-00024");
            throw new DeployException(msg, (Throwable)e);
        }
        finally {
            if (completedValidation && !xCodeFound) {
                String msg = MobileResourceUtils.getMsg("ADF-MBL-10005");
                throw new DeployException(msg);
            }
        }
    }
}

