/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.deployers;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.adfmf.framework.dt.deploy.common.deployers.AbstractDeployerWrapper;
import oracle.adfmf.framework.dt.deploy.common.deployers.ApplicationValidatorDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.ApplicationXmlValidatorDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.CustomizeContentDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.DebugPerfBannerDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.FarExtractorDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.JavaScriptDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.ProjectValidatorDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.ProjectXmlValidatorDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.SecurityDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.SkinsDeployer;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.adfmf.framework.dt.deploy.ios.core.IosFileUtils;
import oracle.adfmf.framework.dt.deploy.ios.deployers.BuildPackageDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.BuildXcodeARMApplicationDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.BuildXcodeX86ApplicationDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.CopyAdfMobileXmlFileDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.CopyAdfSourceFolder;
import oracle.adfmf.framework.dt.deploy.ios.deployers.CopyCustomImagesDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.CopyImagesFolderDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.CopyIosCvmJdkARMDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.CopyIosCvmJdkX86Deployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.CopyOracleCvmSdkARMDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.CopyOracleCvmSdkX86Deployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.CopyTemplateXcodeProjectDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.DeviceDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.DistributionArchiveDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.EmulatorDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.IosArchiveDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.PackageXcodeApplicationDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.PreferencesDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.StringResourceDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.ValidateProvisioningConfigurationDeployer;
import oracle.adfmf.framework.dt.deploy.ios.deployers.ValidateXcodeDeployer;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.common.BatchDeployer;
import oracle.jdeveloper.deploy.common.BuildDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;
import oracle.jdeveloper.deploy.common.ModulePackager;
import oracle.jdeveloper.deploy.jar.JarDeployerFactory;
import oracle.jdevimpl.deploy.common.ProfileDependencyAnalyzer;

public class IosDeployerFactory
implements DeployerFactory {
    public Deployer newDeployer(int deploySequenceId, DeployShell deployShell) {
        if (!IosFrameworkDeployerSequenceIds.contains(deploySequenceId)) {
            return null;
        }
        IosFrameworkDeployerSequenceIds iosDeployerSequenceId = IosFrameworkDeployerSequenceIds.fromInt(deploySequenceId);
        Object newDeployer = null;
        switch (iosDeployerSequenceId) {
            case PACKAGING_SEQUENCE_ID: {
                newDeployer = this.createPackagingBatchDeployer(deployShell);
                break;
            }
            case DEPENDENCY_ANALYZER_ID: {
                newDeployer = new ProfileDependencyAnalyzer(deploySequenceId, deployShell);
                break;
            }
            case BUILD_DEPLOYER_ID: {
                newDeployer = new BuildDeployer(deploySequenceId, deployShell);
                break;
            }
            case MODULE_PACKAGER_ID: {
                newDeployer = new ModulePackager(deploySequenceId, deployShell);
                break;
            }
            case IOS_EMULATOR_BATCH_DEPLOYER_ID: {
                newDeployer = this.createBatchDeployerForIosEmulator();
                break;
            }
            case IOS_DEVICE_BATCH_DEPLOYER_ID: {
                newDeployer = this.createBatchDeployerForIosDevice();
                break;
            }
            case IOS_PREPARE_XCODE_PROJECT_BATCH_DEPLOYER_ID: {
                newDeployer = this.createBatchDeployerToPrepareXcodeProject();
                break;
            }
            case IOS_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID: {
                IosFileUtils iosFileUtils = this._getFileUtils(deployShell);
                if (null == iosFileUtils) break;
                newDeployer = new DebugPerfBannerDeployer(deploySequenceId, iosFileUtils.isDebugMode());
                break;
            }
            case IOS_PREPARE_PROJECT_BATCH_DEPLOYER_ID: {
                newDeployer = this.createBatchDeployerToPrepareProject();
                break;
            }
            case IOS_PACKAGE_BATCH_DEPLOYER_ID: {
                newDeployer = this.createBatchDeployerForIosDeploymentPackage();
                break;
            }
            case IOS_VALIDATE_XCODE_DEPLOYER: {
                newDeployer = new ValidateXcodeDeployer(deploySequenceId);
                break;
            }
            case IOS_COPY_TEMPLATE_XCODE_PROJECT_DEPLOYER: {
                newDeployer = new CopyTemplateXcodeProjectDeployer(deploySequenceId, deployShell);
                break;
            }
            case IOS_COPY_IMAGES_FOLDER_DEPLOYER: {
                newDeployer = new CopyImagesFolderDeployer(deploySequenceId, deployShell);
                break;
            }
            case IOS_COPY_CUSTOM_IMAGES_DEPLOYER: {
                newDeployer = new CopyCustomImagesDeployer(deploySequenceId, deployShell);
                break;
            }
            case IOS_COPY_COMMON_JAVASCRIPT_DEPLOYER: {
                IosFileUtils iosFileUtils = this._getFileUtils(deployShell);
                if (null == iosFileUtils) break;
                newDeployer = new JavaScriptDeployer(deploySequenceId, iosFileUtils);
                break;
            }
            case IOS_COPY_SECURITY_FILES_DEPLOYER: {
                IosFileUtils iosFileUtils = this._getFileUtils(deployShell);
                if (null == iosFileUtils) break;
                newDeployer = new SecurityDeployer(deploySequenceId, iosFileUtils);
                break;
            }
            case IOS_COPY_ADF_MOBILE_XML_FILE_DEPLOYER: {
                newDeployer = new CopyAdfMobileXmlFileDeployer(deploySequenceId, deployShell);
                break;
            }
            case IOS_CUSTOMIZE_CONTENT_DEPLOYER: {
                IosFileUtils iosFileUtils = this._getFileUtils(deployShell);
                if (null == iosFileUtils) break;
                newDeployer = new CustomizeContentDeployer(deploySequenceId, iosFileUtils);
                break;
            }
            case IOS_ADF_SOURCE_DEPLOYER: {
                newDeployer = new CopyAdfSourceFolder(deploySequenceId, deployShell);
                break;
            }
            case IOS_PREFERENCES_DEPLOYER: {
                newDeployer = new PreferencesDeployer(deploySequenceId, deployShell);
                break;
            }
            case IOS_STRING_RESOURCE_DEPLOYER: {
                newDeployer = new StringResourceDeployer(deploySequenceId, deployShell);
                break;
            }
            case FAR_EXTRACTION_DEPLOYER: {
                IosFileUtils iosFileUtils = this._getFileUtils(deployShell);
                if (null == iosFileUtils) break;
                URL xcodeTemplateUrl = iosFileUtils.getDeploymentXcodeFolderUrl();
                newDeployer = new FarExtractorDeployer(deploySequenceId, xcodeTemplateUrl);
                break;
            }
            case SKINS_DEPLOYER: {
                IosFileUtils iosFileUtils = this._getFileUtils(deployShell);
                if (null == iosFileUtils) break;
                newDeployer = new SkinsDeployer(deploySequenceId, iosFileUtils);
                break;
            }
            case DEFAULT_SEQUENCE_ID: {
                newDeployer = new DynamicDeployer(IosFrameworkDeployerSequenceIds.IOS_ARCHIVE_DEPLOYER_ID.m_value);
                break;
            }
            case ARCHIVE_DEPLOYER_ID: {
                newDeployer = new DynamicDeployer(IosFrameworkDeployerSequenceIds.IOS_ARCHIVE_DEPLOYER_ID.m_value);
                break;
            }
            case IOS_ARCHIVE_DEPLOYER_ID: {
                newDeployer = new IosArchiveDeployer(deploySequenceId, deployShell);
                break;
            }
            case IOS_EMULATOR_DEPLOY_DEPLOYER: {
                newDeployer = new EmulatorDeployer(deploySequenceId);
                break;
            }
            case IOS_BUILD_PACKAGE_DEPLOYER: {
                newDeployer = new BuildPackageDeployer(deploySequenceId, deployShell);
                break;
            }
            case IOS_DISTRIBUTION_PACKAGE_DEPLOYER: {
                newDeployer = new DistributionArchiveDeployer(deploySequenceId, deployShell);
                break;
            }
            case IOS_DEVICE_DEPLOY_DEPLOYER: {
                newDeployer = new DeviceDeployer(deploySequenceId);
                break;
            }
            case APPLICATION_VALIDATOR_DEPLOYER: {
                newDeployer = new ApplicationValidatorDeployer(deploySequenceId);
                break;
            }
            case PROJECT_VALIDATOR_DEPLOYER: {
                newDeployer = new ProjectValidatorDeployer(deploySequenceId);
                break;
            }
            case APPLICATION_XML_VALIDATOR_DEPLOYER: {
                newDeployer = new ApplicationXmlValidatorDeployer(deploySequenceId);
                break;
            }
            case PROJECT_XML_VALIDATOR_DEPLOYER: {
                newDeployer = new ProjectXmlValidatorDeployer(deploySequenceId, false);
                break;
            }
            case IOS_COPY_ORACLE_CVM_SDK_X86_DEPLOYER: {
                newDeployer = new CopyOracleCvmSdkX86Deployer(deploySequenceId);
                break;
            }
            case IOS_COPY_ORACLE_CVM_SDK_ARM_DEPLOYER: {
                newDeployer = new CopyOracleCvmSdkARMDeployer(deploySequenceId);
                break;
            }
            case IOS_COPY_IOS_CVM_JDK_X86_DEPLOYER: {
                newDeployer = new CopyIosCvmJdkX86Deployer(deploySequenceId);
                break;
            }
            case IOS_COPY_IOS_CVM_JDK_ARM_DEPLOYER: {
                newDeployer = new CopyIosCvmJdkARMDeployer(deploySequenceId);
                break;
            }
            case IOS_BUILD_ARM_XCODE_APPLICATION_DEPLOYER: {
                newDeployer = new BuildXcodeARMApplicationDeployer(deploySequenceId);
                break;
            }
            case IOS_BUILD_X86_XCODE_APPLICATION_DEPLOYER: {
                newDeployer = new BuildXcodeX86ApplicationDeployer(deploySequenceId);
                break;
            }
            case IOS_VALIDATE_PROVISIONING_CONFIGURATION_DEPLOYER: {
                newDeployer = new ValidateProvisioningConfigurationDeployer(deploySequenceId);
                break;
            }
            case IOS_PACKAGE_XCODE_APPLICATION_DEPLOYER: {
                newDeployer = new PackageXcodeApplicationDeployer(deploySequenceId);
                break;
            }
        }
        if (AbstractDeployerWrapper.isDeployerWrappable(newDeployer)) {
            newDeployer = AbstractDeployerWrapper.newInstance(deploySequenceId, deployShell.getLogger(), (Deployer)newDeployer);
        }
        return newDeployer;
    }

    private BatchDeployer createBatchDeployerToPrepareProject() {
        return new BatchDeployer(IosFrameworkDeployerSequenceIds.IOS_PREPARE_PROJECT_BATCH_DEPLOYER_ID.getInt(), new int[]{IosFrameworkDeployerSequenceIds.IOS_VALIDATE_XCODE_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.PACKAGING_SEQUENCE_ID.getInt(), IosFrameworkDeployerSequenceIds.APPLICATION_VALIDATOR_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.PROJECT_VALIDATOR_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.APPLICATION_XML_VALIDATOR_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.PROJECT_XML_VALIDATOR_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_TEMPLATE_XCODE_PROJECT_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_CUSTOM_IMAGES_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_COMMON_JAVASCRIPT_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_ADF_MOBILE_XML_FILE_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.FAR_EXTRACTION_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.SKINS_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_ADF_SOURCE_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_CUSTOMIZE_CONTENT_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_PREFERENCES_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_STRING_RESOURCE_DEPLOYER.getInt()});
    }

    private BatchDeployer createBatchDeployerToPrepareXcodeProject() {
        return new BatchDeployer(IosFrameworkDeployerSequenceIds.IOS_PREPARE_XCODE_PROJECT_BATCH_DEPLOYER_ID.getInt(), new int[]{IosFrameworkDeployerSequenceIds.IOS_PREPARE_PROJECT_BATCH_DEPLOYER_ID.getInt(), IosFrameworkDeployerSequenceIds.IOS_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID.getInt()});
    }

    private BatchDeployer createBatchDeployerForIosEmulator() {
        return new BatchDeployer(IosFrameworkDeployerSequenceIds.IOS_EMULATOR_BATCH_DEPLOYER_ID.getInt(), new int[]{IosFrameworkDeployerSequenceIds.IOS_PREPARE_PROJECT_BATCH_DEPLOYER_ID.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_ORACLE_CVM_SDK_X86_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_IOS_CVM_JDK_X86_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_SECURITY_FILES_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_BUILD_X86_XCODE_APPLICATION_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_EMULATOR_DEPLOY_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID.getInt()});
    }

    private BatchDeployer createBatchDeployerForIosDeploymentPackage() {
        return new BatchDeployer(IosFrameworkDeployerSequenceIds.IOS_PACKAGE_BATCH_DEPLOYER_ID.getInt(), new int[]{IosFrameworkDeployerSequenceIds.IOS_PREPARE_PROJECT_BATCH_DEPLOYER_ID.getInt(), IosFrameworkDeployerSequenceIds.IOS_VALIDATE_PROVISIONING_CONFIGURATION_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_ORACLE_CVM_SDK_ARM_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_IOS_CVM_JDK_ARM_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_SECURITY_FILES_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_BUILD_ARM_XCODE_APPLICATION_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_PACKAGE_XCODE_APPLICATION_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_DISTRIBUTION_PACKAGE_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID.getInt()});
    }

    private BatchDeployer createBatchDeployerForIosDevice() {
        return new BatchDeployer(IosFrameworkDeployerSequenceIds.IOS_DEVICE_BATCH_DEPLOYER_ID.getInt(), new int[]{IosFrameworkDeployerSequenceIds.IOS_PREPARE_PROJECT_BATCH_DEPLOYER_ID.getInt(), IosFrameworkDeployerSequenceIds.IOS_VALIDATE_PROVISIONING_CONFIGURATION_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_ORACLE_CVM_SDK_ARM_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_IOS_CVM_JDK_ARM_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_COPY_SECURITY_FILES_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_BUILD_ARM_XCODE_APPLICATION_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_PACKAGE_XCODE_APPLICATION_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_DEVICE_DEPLOY_DEPLOYER.getInt(), IosFrameworkDeployerSequenceIds.IOS_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID.getInt()});
    }

    private Deployer createPackagingBatchDeployer(DeployShell deployShell) {
        BatchDeployer newDeployer = null;
        newDeployer = deployShell.getFlag("ignoreDependencies") ? new BatchDeployer(IosFrameworkDeployerSequenceIds.PACKAGING_SEQUENCE_ID.getInt(), new int[]{IosFrameworkDeployerSequenceIds.BUILD_DEPLOYER_ID.getInt(), IosFrameworkDeployerSequenceIds.MODULE_PACKAGER_ID.getInt()}) : new BatchDeployer(IosFrameworkDeployerSequenceIds.PACKAGING_SEQUENCE_ID.getInt(), new int[]{IosFrameworkDeployerSequenceIds.DEPENDENCY_ANALYZER_ID.getInt(), IosFrameworkDeployerSequenceIds.BUILD_DEPLOYER_ID.getInt(), IosFrameworkDeployerSequenceIds.MODULE_PACKAGER_ID.getInt()});
        return newDeployer;
    }

    public static int getDeviceDeploymentSequenceId() {
        return IosFrameworkDeployerSequenceIds.IOS_DEVICE_BATCH_DEPLOYER_ID.getInt();
    }

    public static int getEmulatorDeploymentSequenceId() {
        return IosFrameworkDeployerSequenceIds.IOS_EMULATOR_BATCH_DEPLOYER_ID.getInt();
    }

    public static int getPackageDeploymentSequenceId() {
        return IosFrameworkDeployerSequenceIds.IOS_PACKAGE_BATCH_DEPLOYER_ID.getInt();
    }

    private IosFileUtils _getFileUtils(DeployShell deployShell) {
        IosFileUtils iosFileUtils = null;
        try {
            McIosFrameworkProfile profile = IosDeployUtil.getMcIosFrameworkProfile(deployShell);
            iosFileUtils = new IosFileUtils(deployShell.getContext().getWorkspace(), profile);
        }
        catch (DeployException deployException) {
            // empty catch block
        }
        return iosFileUtils;
    }

    public static enum IosFrameworkDeployerSequenceIds {
        IOS_PREPARE_PROJECT_BATCH_DEPLOYER_ID("Deployment.IOS_PREPARE_PROJECT_BATCH_DEPLOYER_ID"),
        IOS_PREPARE_XCODE_PROJECT_BATCH_DEPLOYER_ID("Deployment.IOS_PREPARE_XCODE_PROJECT_BATCH_DEPLOYER_ID"),
        IOS_DEVICE_BATCH_DEPLOYER_ID("Deployment.IOS_DEVICE_BATCH_DEPLOYER_ID"),
        IOS_EMULATOR_BATCH_DEPLOYER_ID("Deployment.IOS_EMULATOR_BATCH_DEPLOYER_ID"),
        IOS_PACKAGE_BATCH_DEPLOYER_ID("Deployment.IOS_PACKAGE_BATCH_DEPLOYER_ID"),
        IOS_VALIDATE_XCODE_DEPLOYER("Deployment.IOS_VALIDATION_DEPLOYER"),
        IOS_COPY_TEMPLATE_XCODE_PROJECT_DEPLOYER("Deployment.IOS_COPY_TEMPLATE_XCODE_PROJECT_DEPLOYER"),
        IOS_COPY_IMAGES_FOLDER_DEPLOYER("Deployment.IOS_COPY_IMAGES_FOLDER_DEPLOYER"),
        IOS_COPY_CUSTOM_IMAGES_DEPLOYER("Deployment.IOS_COPY_CUSTOM_IMAGES_DEPLOYER"),
        IOS_COPY_ADF_MOBILE_XML_FILE_DEPLOYER("Deployment.IOS_COPY_ADF_MOBILE_XML_FILE_DEPLOYER"),
        IOS_CUSTOMIZE_CONTENT_DEPLOYER("Deployment.IOS_CUSTOMIZE_CONTENT_DEPLOYER"),
        IOS_ADF_SOURCE_DEPLOYER("Deployment.IOS_ADF_SOURCE_DEPLOYER"),
        IOS_PREFERENCES_DEPLOYER("Deployment.IOS_PREFERENCES_DEPLOYER"),
        IOS_STRING_RESOURCE_DEPLOYER("Deployment.IOS_STRING_RESOURCE_DEPLOYER"),
        IOS_EMULATOR_DEPLOY_DEPLOYER("Deployment.IOS_EMULATOR_DEPLOY_DEPLOYER"),
        IOS_DISTRIBUTION_PACKAGE_DEPLOYER("Deployment.IOS_DISTRIBUTION_PACKAGE_DEPLOYER"),
        IOS_DEVICE_DEPLOY_DEPLOYER("Deployment.IOS_DEVICE_DEPLOY_DEPLOYER"),
        IOS_BUILD_PACKAGE_DEPLOYER("Deployment.IOS_PACKAGE_DEPLOYER"),
        IOS_COPY_ORACLE_CVM_SDK_X86_DEPLOYER("Deployment.IOS_COPY_ORACLE_CVM_SDK_X86_DEPLOYER"),
        IOS_COPY_ORACLE_CVM_SDK_ARM_DEPLOYER("Deployment.IOS_COPY_ORACLE_CVM_SDK_ARM_DEPLOYER"),
        IOS_COPY_IOS_CVM_JDK_X86_DEPLOYER("Deployment.IOS_COPY_IOS_CVM_JDK_X86_DEPLOYER"),
        IOS_COPY_IOS_CVM_JDK_ARM_DEPLOYER("Deployment.IOS_COPY_IOS_CVM_JDK_ARM_DEPLOYER"),
        IOS_BUILD_X86_XCODE_APPLICATION_DEPLOYER("Deployment.IOS_BUILD_X86_XCODE_APPLICATION_DEPLOYER"),
        IOS_BUILD_ARM_XCODE_APPLICATION_DEPLOYER("Deployment.IOS_BUILD_ARM_XCODE_APPLICATION_DEPLOYER"),
        IOS_PACKAGE_XCODE_APPLICATION_DEPLOYER("Deployment.IOS_PACKAGE_XCODE_APPLICATION_DEPLOYER"),
        IOS_VALIDATE_PROVISIONING_CONFIGURATION_DEPLOYER("Deployment.IOS_VALIDATE_PROVISIONING_CONFIGURATION_DEPLOYER"),
        IOS_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID("ANDROID_MAYBE_SHOW_DEBUG_PERF_WARNING_ID"),
        DEFAULT_SEQUENCE_ID(DeploymentConstants.DEFAULT_SEQUENCE),
        ARCHIVE_DEPLOYER_ID(DeploymentConstants.ARCHIVE_DEPLOYER),
        PACKAGING_SEQUENCE_ID(DeploymentConstants.PACKAGING_SEQUENCE),
        DEPENDENCY_ANALYZER_ID(JarDeployerFactory.DEPENDENCY_ANALYZER),
        BUILD_DEPLOYER_ID(DeploymentConstants.BUILD_DEPLOYER),
        MODULE_PACKAGER_ID(DeploymentConstants.MODULE_PACKAGER),
        FAR_EXTRACTION_DEPLOYER("Deployment.FAR_EXTRACTION_DEPLOYER"),
        APPLICATION_VALIDATOR_DEPLOYER("Deployment.APPLICATION_VALIDATOR_DEPLOYER_ID"),
        APPLICATION_XML_VALIDATOR_DEPLOYER("Deployment.APPLICATION_XML_VALIDATOR_DEPLOYER_ID"),
        PROJECT_VALIDATOR_DEPLOYER("Deployment.PROJECT_VALIDATOR_DEPLOYER_ID"),
        PROJECT_XML_VALIDATOR_DEPLOYER("Deployment.PROJECT_XML_VALIDATOR_DEPLOYER_ID"),
        SKINS_DEPLOYER("Deployment.SKINS_DEPLOYER"),
        IOS_COPY_COMMON_JAVASCRIPT_DEPLOYER("Deployment.IOS_COPY_COMMON_JAVASCRIPT_DEPLOYER"),
        IOS_COPY_SECURITY_FILES_DEPLOYER("Deployment.IOS_COPY_SECURITY_FILES_DEPLOYER"),
        IOS_ARCHIVE_DEPLOYER_ID("Deployment.IOS_ARCHIVE_DEPLOYER_ID");

        private int m_value;
        private static Map<Integer, IosFrameworkDeployerSequenceIds> s_DeployerMap;

        public int getInt() {
            return this.m_value;
        }

        public static boolean contains(int deploySequenceId) {
            return s_DeployerMap.containsKey(deploySequenceId);
        }

        public static IosFrameworkDeployerSequenceIds fromInt(int deploySequenceId) {
            if (s_DeployerMap.containsKey(deploySequenceId)) {
                return s_DeployerMap.get(deploySequenceId);
            }
            throw new IllegalArgumentException();
        }

        private IosFrameworkDeployerSequenceIds(String stringIdentifier) {
            this.m_value = DeploymentManager.getDeploymentSequenceId((String)stringIdentifier);
        }

        private IosFrameworkDeployerSequenceIds(int intIdentifier) {
            this.m_value = intIdentifier;
        }

        static {
            s_DeployerMap = new HashMap<Integer, IosFrameworkDeployerSequenceIds>();
            for (IosFrameworkDeployerSequenceIds id : IosFrameworkDeployerSequenceIds.values()) {
                s_DeployerMap.put(id.m_value, id);
            }
        }
    }
}

