/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.deployers;

import java.util.logging.Logger;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployer;
import oracle.adfmf.framework.dt.deploy.ios.core.IosFileUtils;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public class DeviceDeployer
extends AbstractDeployer {
    public DeviceDeployer(int deploySequence) {
        super(deploySequence);
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        Logger logger = deployShell.getLogger();
        try {
            Workspace workspace = deployShell.getContext().getWorkspace();
            String workspaceName = McAppUtils.getWorkspaceName(workspace);
            String msg = MobileResourceUtils.getMsg("ADF-MBL-20000", workspaceName);
            logger.info(msg);
            McIosFrameworkProfile iosProfile = IosDeployUtil.getMcIosFrameworkProfile(deployShell);
            IosFileUtils iosFiles = new IosFileUtils(workspace, iosProfile);
            IosDeployer.deployToDevice(iosFiles);
        }
        catch (Exception e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-00038");
            throw new DeployException(msg, (Throwable)e);
        }
    }
}

