/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.deployers;

import java.io.IOException;
import java.util.logging.Logger;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.adfmf.framework.dt.deploy.ios.core.IosFileUtils;
import oracle.adfmf.framework.dt.deploy.ios.core.OracleCvmCopier;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public class CopyOracleCvmSdkX86Deployer
extends AbstractDeployer {
    public CopyOracleCvmSdkX86Deployer(int deploySequenceId) {
        super(deploySequenceId);
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        try {
            Logger logger = deployShell.getLogger();
            McIosFrameworkProfile iosProfile = IosDeployUtil.getMcIosFrameworkProfile(deployShell);
            IosFileUtils iosFiles = new IosFileUtils(deployShell.getContext().getWorkspace(), iosProfile);
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21004", "CVM SDK", "x86"));
            OracleCvmCopier cvmCopier = new OracleCvmCopier();
            cvmCopier.copyX86Files(iosFiles, logger);
        }
        catch (IOException e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01013");
            throw new DeployException(msg, (Throwable)e);
        }
    }
}

