/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.deployers;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployer;
import oracle.adfmf.framework.dt.deploy.ios.core.IosFileUtils;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public class CopyCustomImagesDeployer
extends AbstractDeployer {
    public CopyCustomImagesDeployer(int deploySequence, DeployShell deployShell) {
        super(deploySequence);
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        Logger logger = deployShell.getLogger();
        try {
            if (logger.getLevel() == Level.FINEST) {
                logger.log(Level.FINEST, "Copying custom images to the template XCode project.");
            }
            McIosFrameworkProfile profile = IosDeployUtil.getMcIosFrameworkProfile(deployShell);
            IosFileUtils iosFiles = new IosFileUtils(deployShell.getContext().getWorkspace(), profile);
            ImageOptions imageOptions = profile.getImageOptions();
            IosDeployer.copyCustomImages(iosFiles, imageOptions, logger);
        }
        catch (Exception e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-00018");
            throw new DeployException(msg, (Throwable)e);
        }
    }
}

