/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.adfmf.framework.dt.deploy.ios.core.IosFileUtils;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PlistUtils {
    private static final String BUNDLE_DISPLAY_NAME = "CFBundleDisplayName";
    private static final String BUNDLE_IDENTIFIER = "CFBundleIdentifier";
    private static final String BUNDLE_VERSION = "CFBundleVersion";
    private static final String PRERENDERED_ICON = "UIPrerenderedIcon";
    private static final String IPAD_SUPPORTED_ORIENTATIONS = "UISupportedInterfaceOrientations~ipad";
    private static final String IPHONE_SUPPORTED_ORIENTATIONS = "UISupportedInterfaceOrientations";
    private static final String CF_BUNDLE_ICONS = "CFBundleIcons";
    private static final String CF_BUNDLE_PRIMARY_ICON = "CFBundlePrimaryIcon";
    private static final String CF_BUNDLE_URL_TYPES = "CFBundleURLTypes";
    private static final String CF_BUNDLE_URL_NAME = "CFBundleURLName";
    private static final String CF_BUNDLE_URL_SCHEMES = "CFBundleURLSchemes";
    private static final String DICT_ELEMENT = "dict";
    private static final String KEY_ELEMENT = "key";
    private static final String STRING_ELEMENT = "string";
    private static final String ARRAY_ELEMENT = "array";
    private static final String TRUE_ELEMENT = "true";
    private static final String FALSE_ELEMENT = "false";

    private PlistUtils() {
    }

    public static void updatePlistConfiguration(McIosFrameworkProfile profile, IosFileUtils iosFileUtils) throws DeployException {
        try {
            XMLDocument applicationPlistDOM = PlistUtils.getApplicationPlistDOM(iosFileUtils);
            Element documentElement = applicationPlistDOM.getDocumentElement();
            Node childNode = documentElement.getFirstChild();
            while (childNode != null) {
                Node nextChild = childNode.getNextSibling();
                if (childNode.getNodeName().equals(DICT_ELEMENT)) {
                    String bundleIdentifier = IosDeployUtil.getBundleIdentifier(profile);
                    String urlScheme = McAppUtils.getApplicationUrlScheme(iosFileUtils.getWorkspace());
                    boolean haveUpdatedUrlScheme = false;
                    Node dictChild = childNode.getFirstChild();
                    while (dictChild != null) {
                        Node secondDictChild;
                        Node nextDictChild = dictChild.getNextSibling();
                        Node node = secondDictChild = null != nextDictChild ? nextDictChild.getNextSibling() : null;
                        if (null != secondDictChild) {
                            if (dictChild.getNodeName().equalsIgnoreCase(KEY_ELEMENT) && dictChild.getTextContent().equalsIgnoreCase(BUNDLE_DISPLAY_NAME)) {
                                PlistUtils.setStringNodeValue(secondDictChild, McAppUtils.getApplicationName(iosFileUtils.getWorkspace()));
                            } else if (dictChild.getNodeName().equalsIgnoreCase(KEY_ELEMENT) && dictChild.getTextContent().equalsIgnoreCase(BUNDLE_VERSION)) {
                                PlistUtils.setStringNodeValue(secondDictChild, McAppUtils.getApplicationVersion(iosFileUtils.getWorkspace()));
                            } else if (dictChild.getNodeName().equalsIgnoreCase(KEY_ELEMENT) && dictChild.getTextContent().equalsIgnoreCase(BUNDLE_IDENTIFIER)) {
                                PlistUtils.setStringNodeValue(secondDictChild, bundleIdentifier);
                            } else if (dictChild.getNodeName().equalsIgnoreCase(KEY_ELEMENT) && dictChild.getTextContent().equalsIgnoreCase(PRERENDERED_ICON)) {
                                PlistUtils.setBooleanNodeValue((Document)applicationPlistDOM, secondDictChild, IosDeployUtil.getUsePrerenderedIcons(profile));
                            } else if (dictChild.getNodeName().equalsIgnoreCase(KEY_ELEMENT) && dictChild.getTextContent().equalsIgnoreCase(CF_BUNDLE_ICONS)) {
                                PlistUtils._updateUsePrerenderedIcon(secondDictChild, profile, applicationPlistDOM);
                            } else if (dictChild.getNodeName().equalsIgnoreCase(KEY_ELEMENT) && dictChild.getTextContent().equalsIgnoreCase(IPHONE_SUPPORTED_ORIENTATIONS)) {
                                ArrayList<String> iPhoneOrientationArray = IosDeployUtil.getSupportedIphoneOrientation(profile);
                                PlistUtils.setStringArrayNodeValue((Document)applicationPlistDOM, secondDictChild, iPhoneOrientationArray);
                            } else if (dictChild.getNodeName().equalsIgnoreCase(KEY_ELEMENT) && dictChild.getTextContent().equalsIgnoreCase(IPAD_SUPPORTED_ORIENTATIONS)) {
                                ArrayList<String> iPadOrientationArray = IosDeployUtil.getSupportedIpadOrientation(profile);
                                PlistUtils.setStringArrayNodeValue((Document)applicationPlistDOM, secondDictChild, iPadOrientationArray);
                            } else if (dictChild.getNodeName().equalsIgnoreCase(KEY_ELEMENT) && dictChild.getTextContent().equalsIgnoreCase(CF_BUNDLE_URL_TYPES)) {
                                if (ModelUtil.hasLength((String)urlScheme)) {
                                    PlistUtils._removeAllChildNodes(secondDictChild);
                                    PlistUtils._updateUrlSchemeArrayNode((Document)applicationPlistDOM, secondDictChild, urlScheme, bundleIdentifier);
                                } else {
                                    childNode.removeChild(dictChild);
                                    childNode.removeChild(secondDictChild);
                                }
                                haveUpdatedUrlScheme = true;
                            }
                        }
                        dictChild = nextDictChild;
                    }
                    if (haveUpdatedUrlScheme || !ModelUtil.hasLength((String)urlScheme)) break;
                    PlistUtils._addUrlSchemeNode((Document)applicationPlistDOM, childNode, urlScheme, bundleIdentifier);
                    break;
                }
                childNode = nextChild;
            }
            PlistUtils.writeApplicationPlistXmlFile((Document)applicationPlistDOM, iosFileUtils);
        }
        catch (Exception e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01001", e);
            throw new DeployException(msg, (Throwable)e);
        }
    }

    private static XMLDocument getApplicationPlistDOM(IosFileUtils iosFileUtils) throws IOException, SAXException {
        URL plistUrl = iosFileUtils.getApplicationPlistFileUrl();
        DOMParser parser = new DOMParser();
        parser.retainCDATASection(false);
        CustomEntityResolver custEntityResolver = new CustomEntityResolver();
        parser.setEntityResolver((EntityResolver)custEntityResolver);
        parser.setPreserveWhitespace(true);
        parser.parse(plistUrl);
        XMLDocument xmlInput = parser.getDocument();
        return xmlInput;
    }

    private static void writeApplicationPlistXmlFile(Document plistDocument, IosFileUtils iosFileUtils) throws Exception {
        URL plistUrl = iosFileUtils.getApplicationPlistFileUrl();
        FileUtils.writeXmlFile(plistDocument, plistUrl);
    }

    private static void setStringNodeValue(Node node, String value) {
        if (node.getNodeName().equals(STRING_ELEMENT) && null != value && !value.isEmpty()) {
            node.setTextContent(value);
        }
    }

    private static void setBooleanNodeValue(Document document, Node node, boolean value) {
        Node parent = node.getParentNode();
        if (node.getNodeName().equals(TRUE_ELEMENT) && !value) {
            parent.replaceChild(document.createElementNS(null, FALSE_ELEMENT), node);
        } else if (node.getNodeName().equals(FALSE_ELEMENT) && value) {
            parent.replaceChild(document.createElementNS(null, TRUE_ELEMENT), node);
        }
    }

    public static void setStringArrayNodeValue(Document document, Node node, List<String> arrayOfStringElementValues) {
        if (node.getNodeName().equals(ARRAY_ELEMENT) && null != arrayOfStringElementValues) {
            Node textNode = null;
            textNode = PlistUtils._createClonedTextNode(node);
            PlistUtils._removeAllChildNodes(node);
            for (String currString : arrayOfStringElementValues) {
                if (null != textNode) {
                    Node tempTextNode = textNode.cloneNode(true);
                    node.appendChild(tempTextNode);
                }
                PlistUtils._addChildStringToNode(document, node, currString);
            }
            if (null != textNode) {
                node.appendChild(textNode);
            }
        }
    }

    protected static boolean hasPreferences(IosFileUtils iosFiles, Logger logger) throws DeployException {
        try {
            if (logger.getLevel() == Level.FINEST) {
                logger.finest("Check if 'Root.plist' has preference configuration.");
            }
            URL rootPlistFileUrl = iosFiles.getRootPlistFileUrl();
            Document doc = PlistUtils.getPlistXmlFileDom(rootPlistFileUrl, false, logger);
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xp = xpf.newXPath();
            String GET_FIRST_PREFERENCE_GROUP = "(//string[text()='PSGroupSpecifier'])[1]";
            Node node = (Node)xp.evaluate("(//string[text()='PSGroupSpecifier'])[1]", doc, XPathConstants.NODE);
            if (node != null) {
                assert (0 == STRING_ELEMENT.compareTo(node.getNodeName()));
                assert (0 == "PSGroupSpecifier".compareTo(node.getTextContent()));
                if (logger.getLevel() == Level.FINEST) {
                    logger.finest("File 'Root.plist' DOES have preference configuration.");
                }
                return true;
            }
            if (logger.getLevel() == Level.FINEST) {
                logger.finest("File 'Root.plist' does NOT have preference configuration.");
            }
            return false;
        }
        catch (IOException e) {
            throw new DeployException((Throwable)e);
        }
        catch (SAXException e) {
            throw new DeployException((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new DeployException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new DeployException((Throwable)e);
        }
        catch (XPathException e) {
            throw new DeployException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getPlistXmlFileDom(final URL xmlFileUrl, boolean validateExternalEntities, final Logger logger) throws SAXException, ParserConfigurationException, IOException {
        InputStream xmlFileStream = null;
        Document document = null;
        try {
            xmlFileStream = xmlFileUrl.openStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (!validateExternalEntities) {
                db.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        if (logger.getLevel() == Level.FINEST) {
                            String platformPath = URLFileSystem.getPlatformPathName((URL)xmlFileUrl);
                            String msg = String.format("Forcing DocumentBuilder parser to ignore external entity (Public ID: '%s', System ID: '%s') in XML file '%s'", publicId, systemId, platformPath);
                            logger.finest(msg);
                        }
                        return new InputSource(new StringReader(""));
                    }
                });
            }
            document = db.parse(xmlFileStream);
        }
        finally {
            FileUtils.closeStream(xmlFileStream, logger);
        }
        return document;
    }

    public static Node getPlistArrayElement(Node keyNode) {
        Node nextSiblingNode;
        for (nextSiblingNode = keyNode.getNextSibling(); null != nextSiblingNode && !nextSiblingNode.getNodeName().equals(ARRAY_ELEMENT); nextSiblingNode = nextSiblingNode.getNextSibling()) {
        }
        Node arrayNode = nextSiblingNode;
        return arrayNode;
    }

    private static void _updateUsePrerenderedIcon(Node primaryIconElement, McIosFrameworkProfile profile, XMLDocument applicationPlistDOM) {
        if (primaryIconElement.getNodeName().equals(DICT_ELEMENT)) {
            Node imageDictChild = primaryIconElement.getFirstChild();
            while (imageDictChild != null) {
                Node thirdDictNode;
                assert (null != imageDictChild);
                Node secondDictNode = imageDictChild.getNextSibling();
                if (null != secondDictNode && imageDictChild.getNodeName().equalsIgnoreCase(KEY_ELEMENT) && imageDictChild.getTextContent().equals(CF_BUNDLE_PRIMARY_ICON) && null != (thirdDictNode = secondDictNode.getNextSibling()) && thirdDictNode.getNodeName().equals(DICT_ELEMENT)) {
                    Node bundleIconDictChild = thirdDictNode.getFirstChild();
                    while (bundleIconDictChild != null) {
                        Node valueChild = bundleIconDictChild.getNextSibling();
                        if (null != valueChild && bundleIconDictChild.getNodeName().equalsIgnoreCase(KEY_ELEMENT) && bundleIconDictChild.getTextContent().equalsIgnoreCase(PRERENDERED_ICON)) {
                            PlistUtils.setBooleanNodeValue((Document)applicationPlistDOM, valueChild.getNextSibling(), IosDeployUtil.getUsePrerenderedIcons(profile));
                            break;
                        }
                        bundleIconDictChild = valueChild;
                    }
                }
                imageDictChild = secondDictNode;
            }
        }
    }

    private static void _addUrlSchemeNode(Document document, Node node, String urlSchemeName, String bundleIdentifier) {
        PlistUtils._addChildKeyToNode(document, node, CF_BUNDLE_URL_TYPES);
        Element arrayNode = document.createElementNS(null, ARRAY_ELEMENT);
        PlistUtils._updateUrlSchemeArrayNode(document, arrayNode, urlSchemeName, bundleIdentifier);
        node.appendChild(arrayNode);
    }

    private static void _updateUrlSchemeArrayNode(Document document, Node arrayNode, String urlSchemeName, String bundleIdentifier) {
        Element dictNode = document.createElementNS(null, DICT_ELEMENT);
        PlistUtils._addChildKeyWithStringToNode(document, dictNode, CF_BUNDLE_URL_NAME, bundleIdentifier);
        List<String> arrayOfSchemenames = Arrays.asList(urlSchemeName);
        PlistUtils._addChildKeyWithStringArrayToNode(document, dictNode, CF_BUNDLE_URL_SCHEMES, arrayOfSchemenames);
        arrayNode.appendChild(dictNode);
    }

    private static void _addChildKeyToNode(Document document, Node parentNode, String keyName) {
        Element keyNode = document.createElementNS(null, KEY_ELEMENT);
        keyNode.setTextContent(keyName);
        parentNode.appendChild(keyNode);
    }

    private static void _addChildStringToNode(Document document, Node parentNode, String stringValue) {
        Element stringNode = document.createElementNS(null, STRING_ELEMENT);
        stringNode.setTextContent(stringValue);
        parentNode.appendChild(stringNode);
    }

    private static void _addChildStringArrayToNode(Document document, Node parentNode, List<String> arrayOfStringElementValues) {
        Element arrayNode = document.createElementNS(null, ARRAY_ELEMENT);
        parentNode.appendChild(arrayNode);
        PlistUtils.setStringArrayNodeValue(document, arrayNode, arrayOfStringElementValues);
    }

    private static void _addChildKeyWithStringToNode(Document document, Node parentNode, String keyName, String stringValue) {
        PlistUtils._addChildKeyToNode(document, parentNode, keyName);
        PlistUtils._addChildStringToNode(document, parentNode, stringValue);
    }

    private static void _addChildKeyWithStringArrayToNode(Document document, Node parentNode, String keyName, List<String> arrayOfStringElementValues) {
        PlistUtils._addChildKeyToNode(document, parentNode, keyName);
        PlistUtils._addChildStringArrayToNode(document, parentNode, arrayOfStringElementValues);
    }

    private static void _removeAllChildNodes(Node parentNode) {
        NodeList nodeList = parentNode.getChildNodes();
        for (int index = nodeList.getLength() - 1; index >= 0; --index) {
            Node childNode = nodeList.item(index);
            parentNode.removeChild(childNode);
        }
    }

    private static Node _createClonedTextNode(Node parentNode) {
        NodeList nodeList = parentNode.getChildNodes();
        Node textNode = null;
        for (int index = nodeList.getLength() - 1; index >= 0; --index) {
            Node childNode = nodeList.item(index);
            if (null != textNode || childNode.getNodeName().compareToIgnoreCase(STRING_ELEMENT) == 0) continue;
            textNode = childNode.cloneNode(true);
            break;
        }
        return textNode;
    }

    private static class CustomEntityResolver
    implements EntityResolver {
        private CustomEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            StringReader strReader = new StringReader("");
            return new InputSource(strReader);
        }
    }
}

