/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.WhiteListFileCreator;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.WhiteListUrlPattern;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.core.IosFileUtils;
import oracle.adfmf.framework.dt.deploy.ios.core.PlistUtils;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IosWhiteListFileCreator
implements WhiteListFileCreator {
    @Override
    public void createWhiteListFile(DeployShell deployShell, Set<WhiteListUrlPattern> whiteListedUrlPatterns) throws DeployException {
        Logger logger = deployShell.getLogger();
        McIosFrameworkProfile iosProfile = McIosFrameworkProfile.newMcIosFrameworkProfile(deployShell);
        IosFileUtils iosFileUtils = new IosFileUtils(deployShell.getContext().getWorkspace(), iosProfile);
        this._createCordovaPlistXml(iosFileUtils, logger, whiteListedUrlPatterns);
    }

    private void _createCordovaPlistXml(IosFileUtils iosFileUtils, Logger logger, Set<WhiteListUrlPattern> whiteListedUrlPatterns) throws DeployException {
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-21002"));
        URL cordovaPlistUrl = iosFileUtils.getCordovaPlistUrl();
        Document cordovaXmlDom = this._getCordovaXmlDom(cordovaPlistUrl, logger);
        Node arrayNode = this._getExternalHostsArrayElement(cordovaXmlDom);
        Set<WhiteListUrlPattern> allUrlPatterns = whiteListedUrlPatterns;
        if (null != arrayNode) {
            allUrlPatterns = this._mergeCordovaPlistPatterns(arrayNode, whiteListedUrlPatterns);
        }
        ArrayList<String> whiteListedPatternList = new ArrayList<String>();
        for (WhiteListUrlPattern currPattern : allUrlPatterns) {
            whiteListedPatternList.add(currPattern.getUrlPattern());
        }
        PlistUtils.setStringArrayNodeValue(cordovaXmlDom, arrayNode, whiteListedPatternList);
        this._writeCordovaPlistFile(cordovaXmlDom, cordovaPlistUrl);
    }

    private Set<WhiteListUrlPattern> _mergeCordovaPlistPatterns(Node arrayNode, Set<WhiteListUrlPattern> whiteListedUrlPatterns) {
        if (null == arrayNode || null == whiteListedUrlPatterns) {
            throw new IllegalArgumentException();
        }
        HashSet<WhiteListUrlPattern> whiteListUrlPatterns = new HashSet<WhiteListUrlPattern>(whiteListedUrlPatterns);
        String PLIST_STRING_ELEMENT = "string";
        NodeList nodeList = arrayNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String currPattern;
            Node currNode = nodeList.item(i);
            if (!currNode.getNodeName().equals("string") || !ModelUtil.hasLength((String)(currPattern = currNode.getTextContent()))) continue;
            whiteListUrlPatterns.add(new WhiteListUrlPattern(currPattern));
        }
        return whiteListUrlPatterns;
    }

    private Document _getCordovaXmlDom(URL cordovaPlistUrl, Logger logger) throws DeployException {
        try {
            return PlistUtils.getPlistXmlFileDom(cordovaPlistUrl, false, logger);
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
    }

    private Node _getExternalHostsArrayElement(Document cordovaXmlDom) throws DeployException {
        Node externalHostNode = this._getExternalHostNode(cordovaXmlDom);
        Node arrayNode = PlistUtils.getPlistArrayElement(externalHostNode);
        assert (null != arrayNode);
        return arrayNode;
    }

    private Node _getExternalHostNode(Document cordovaXmlDom) throws DeployException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        Node externalHost = null;
        try {
            String GET_EXTERNAL_HOSTS_NODE = "(//key[text()='ExternalHosts'])[1]";
            Object externalHostObject = xPath.evaluate("(//key[text()='ExternalHosts'])[1]", cordovaXmlDom, XPathConstants.NODE);
            assert (null != externalHostObject && externalHostObject instanceof Node);
            externalHost = (Node)externalHostObject;
        }
        catch (XPathExpressionException e) {
            throw new DeployException((Throwable)e);
        }
        return externalHost;
    }

    private void _writeCordovaPlistFile(Document cordovaXmlDom, URL cordovaPlistUrl) throws DeployException {
        try {
            FileUtils.writeXmlFile(cordovaXmlDom, cordovaPlistUrl);
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
    }
}

