/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.adfmf.framework.dt.deploy.ios.core.IosFileUtils;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.DeployException;

public class IosImageUtil {
    private static final String DEFAULT_RESOURCE_RELATIVE_PATH = "resources/ios/";
    public static final String ICON_FILE_NAME = "icon.png";
    public static final String ICON_2X_FILE_NAME = "icon@2x.png";
    public static final String ICON_72_FILE_NAME = "icon-72.png";
    public static final String ICON_IPAD_RETINA_FILE_NAME = "icon-144.png";
    public static final String DEFAULT_FILE_NAME = "Default.png";
    public static final String DEFAULT_LAND_FILE_NAME = "Default-Land.png";
    public static final String DEFAULT_LANDSCAPE_FILE_NAME = "Default-Landscape.png";
    public static final String DEFAULT_PORTRAIT_FILE_NAME = "Default-Portrait.png";
    public static final String DEFAULT_LANDSCAPE_IPAD_FILE_NAME = "Default-Landscape-Ipad.png";
    public static final String DEFAULT_PORTRAIT_IPAD_FILE_NAME = "Default-Portrait-Ipad.png";
    public static final String DEFAULT_2X_FILE_NAME = "Default@2x.png";
    public static final String DEFAULT_2X_LANDSCAPE_FILE_NAME = "Default@2x-Landscape.png";
    public static final String DEFAULT_1135H_2X_FILE_NAME = "Default-1135h@2x.png";
    public static final String DEFAULT_568H_2X_FILE_NAME = "Default-568h@2x.png";
    public static final String DEFAULT_IPAD_RETINA_PORTRAIT_FILE_NAME = "Default-Portrait@2x~ipad.png";
    public static final String DEFAULT_IPAD_RETINA_LANDSCAPE_FILE_NAME = "Default-Landscape@2x~ipad.png";
    public static final String DEFAULT_ITUNES_ARTWORK_FILE_NAME = "iTunesArtwork.png";
    private static final List<String> _newV1_1_Images = new ArrayList<String>(Arrays.asList("Default-Land.png", "Default@2x-Landscape.png", "Default-1135h@2x.png", "Default-568h@2x.png", "Default-Landscape-Ipad.png", "Default-Portrait-Ipad.png"));

    public static void copyApplicationImages(ImageOptions imageOptions, IosFileUtils iosFileUtils) throws DeployException {
        try {
            URL applicationResourceOutputUrl = iosFileUtils.getDeploymentXcodeFolderUrl();
            URL defaultResourcesRootFolderUrl = iosFileUtils.getApplicationDefaultResourceFolderURL();
            String imagePath = imageOptions.getStringValue("itunesArtwork");
            String iTunesArtAbsolutePath = FileUtils.getAbsoluteLocation(iosFileUtils.getWorkspace(), imagePath);
            DeployFileUtils.copyImage(applicationResourceOutputUrl, defaultResourcesRootFolderUrl, iTunesArtAbsolutePath, DEFAULT_ITUNES_ARTWORK_FILE_NAME, DEFAULT_ITUNES_ARTWORK_FILE_NAME);
            Map<ImageToDeviceInformation, DefaultImageSet> imageInfoToDefaultImageSetMap = ImageToDeviceInformation.getImageFolderToDefaultImageMap();
            for (Map.Entry<ImageToDeviceInformation, DefaultImageSet> currEntry : imageInfoToDefaultImageSetMap.entrySet()) {
                ImageToDeviceInformation currImageToDevice = currEntry.getKey();
                DefaultImageSet currDefaultImageSet = currEntry.getValue();
                HashStructure imageOptionsHash = DeployFileUtils.getDeviceTypeHash(imageOptions, currImageToDevice.getImageOptionsKey());
                DeployFileUtils.copyImage(applicationResourceOutputUrl, defaultResourcesRootFolderUrl, IosImageUtil.getConfiguredImagePathFromHash(iosFileUtils.getWorkspace(), "appIconPath", imageOptionsHash), currDefaultImageSet.getAppImageName(), currDefaultImageSet.getAppImageName());
                DeployFileUtils.copyImage(applicationResourceOutputUrl, defaultResourcesRootFolderUrl, IosImageUtil.getConfiguredImagePathFromHash(iosFileUtils.getWorkspace(), "portraitSplashScreenPath", imageOptionsHash), currDefaultImageSet.getPortraitSplashName(), currDefaultImageSet.getPortraitSplashName());
                DeployFileUtils.copyImage(applicationResourceOutputUrl, defaultResourcesRootFolderUrl, IosImageUtil.getConfiguredImagePathFromHash(iosFileUtils.getWorkspace(), "landscapeSplashScreenPath", imageOptionsHash), currDefaultImageSet.getLandscapeSplashName(), currDefaultImageSet.getLandscapeSplashName());
            }
        }
        catch (Exception e) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00025"), (Throwable)e);
        }
    }

    public static void addDefaultsToImageOptions(ImageOptions imageOptions) {
        String itunesArtworkPath;
        for (v1ToV1_1ImageSet imageSet : v1ToV1_1ImageSet.values()) {
            String imagePath = imageOptions.getStringValue(imageSet.getOldKey());
            if (null != imagePath && !imagePath.isEmpty()) {
                HashStructure imageOptionsHash = DeployFileUtils.getDeviceTypeHash(imageOptions, imageSet.getDeviceType());
                imageOptionsHash.putString(imageSet.getNewKey(), imagePath);
            }
            imageOptions.removeKey(imageSet.getOldKey());
        }
        URL extensionIosResourceUrl = IosFileUtils.getExtensionIosResourcesUrl();
        String appResourcesPath = FileUtils.getAbsoluteLocation(null, "resources");
        URL appResoucesURL = URLFactory.newDirURL((String)appResourcesPath);
        URL iosResourcesURL = URLFactory.newDirURL((URL)appResoucesURL, (String)"ios");
        try {
            for (String imageName : _newV1_1_Images) {
                URL appImageURL = URLFactory.newURL((URL)iosResourcesURL, (String)imageName);
                if (FileUtils.doesFileExist(appImageURL.getFile())) continue;
                URL resourceImageURL = URLFactory.newURL((URL)extensionIosResourceUrl, (String)imageName);
                FileUtils.copyFile(resourceImageURL, iosResourcesURL, null);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (null == (itunesArtworkPath = imageOptions.getStringValue("itunesArtwork")) || itunesArtworkPath.isEmpty()) {
            String iTunesArtAbsolutePath = "resources/ios/iTunesArtwork.png";
            imageOptions.setStringValue("itunesArtwork", "resources/ios/iTunesArtwork.png");
        }
        Map<ImageToDeviceInformation, DefaultImageSet> imageInfoToDefaultImageSetMap = ImageToDeviceInformation.getImageFolderToDefaultImageMap();
        for (Map.Entry<ImageToDeviceInformation, DefaultImageSet> currEntry : imageInfoToDefaultImageSetMap.entrySet()) {
            ImageToDeviceInformation currImageToDevice = currEntry.getKey();
            DefaultImageSet currDefaultImageSet = currEntry.getValue();
            HashStructure imageOptionsHash = DeployFileUtils.getDeviceTypeHash(imageOptions, currImageToDevice.getImageOptionsKey());
            String imageDefault = currDefaultImageSet.getAppImageName();
            IosImageUtil._updateImageInOptions(imageOptionsHash, "appIconPath", imageDefault);
            String portraitSplashDefault = currDefaultImageSet.getPortraitSplashName();
            IosImageUtil._updateImageInOptions(imageOptionsHash, "portraitSplashScreenPath", portraitSplashDefault);
            String landscapeSplashDefault = currDefaultImageSet.getLandscapeSplashName();
            IosImageUtil._updateImageInOptions(imageOptionsHash, "landscapeSplashScreenPath", landscapeSplashDefault);
        }
    }

    private static void _updateImageInOptions(HashStructure imageOptionsHash, String imageType, String imageName) {
        String appIcon = imageOptionsHash.getString(imageType);
        if (null == appIcon || appIcon.isEmpty()) {
            imageOptionsHash.putString(imageType, DEFAULT_RESOURCE_RELATIVE_PATH + imageName);
        }
    }

    private static String getConfiguredImagePathFromHash(Workspace workspace, String imageType, HashStructure imageOptionsHash) {
        String imagePath = imageOptionsHash.getString(imageType);
        return FileUtils.getAbsoluteLocation(workspace, imagePath);
    }

    private static enum v1ToV1_1ImageSet {
        IPHONE_APP_IMAGE_MAPPING("icon1", "iPhone", "appIconPath"),
        IPAD_APP_IMAGE_MAPPING("icon2", "iPad", "appIconPath"),
        IPHONE_RETINA_APP_IMAGE_MAPPING("icon3", "iPhone Retina", "appIconPath"),
        IPAD_RETINA_APP_IMAGE_MAPPING("icon4", "iPad Retina", "appIconPath"),
        IPHONE_SPLASH_MAPPING("portSplashScreen1", "iPhone", "portraitSplashScreenPath"),
        IPAD_PORT_SPLASH_MAPPING("portSplashScreen2", "iPad", "portraitSplashScreenPath"),
        IPHONE_RETINA_PORT_SPLASH_MAPPING("portSplashScreen3", "iPhone Retina", "portraitSplashScreenPath"),
        IPAD_RETINA_PORT_SPLASH_MAPPING("portSplashScreen4", "iPad Retina", "portraitSplashScreenPath"),
        IPAD_LAND_SPLASH_MAPPING("landSplashScreen1", "iPhone", "landscapeSplashScreenPath"),
        IPAD_RETINA_LAND_SPLASH_MAPPING("landSplashScreen2", "iPhone Retina", "landscapeSplashScreenPath");

        private final String _oldKey;
        private final String _deviceType;
        private final String _newKey;

        public String getOldKey() {
            return this._oldKey;
        }

        public String getDeviceType() {
            return this._deviceType;
        }

        public String getNewKey() {
            return this._newKey;
        }

        private v1ToV1_1ImageSet(String oldKey, String deviceType, String newKey) {
            this._oldKey = oldKey;
            this._deviceType = deviceType;
            this._newKey = newKey;
        }
    }

    private static enum ImageToDeviceInformation {
        DRAWABLE_IPHONE_IMAGE_DEST(DefaultImageSet.DISPLAY_IPHONE3_IMAGES, "iPhone"),
        DRAWABLE_IPAD_IMAGE_DEST(DefaultImageSet.DISPLAY_IPAD_IMAGES, "iPad"),
        DRAWABLE_IPHONE_RETINA_IMAGE_DEST(DefaultImageSet.DISPLAY_RETINA_IMAGES, "iPhone Retina"),
        DRAWABLE_IPAD_RETINA_IMAGE_DEST(DefaultImageSet.DISPLAY_IPAD_RETINA_IMAGES, "iPad Retina"),
        DRAWABLE_IPHONE5_IMAGE_DEST(DefaultImageSet.DISPLAY_IPHONE5_IMAGES, "iPhone 5"),
        DRAWABLE_IPAD_MINI_IMAGE_DEST(DefaultImageSet.DISPLAY_IPAD_MINI_IMAGES, "iPad Mini");

        private final DefaultImageSet m_defaultImageName;
        private final String m_imageOptionsKey;

        public static Map<ImageToDeviceInformation, DefaultImageSet> getImageFolderToDefaultImageMap() {
            HashMap<ImageToDeviceInformation, DefaultImageSet> folderNameToImageNameMap = new HashMap<ImageToDeviceInformation, DefaultImageSet>();
            for (ImageToDeviceInformation V1_2_ImageInformation : ImageToDeviceInformation.values()) {
                folderNameToImageNameMap.put(V1_2_ImageInformation, V1_2_ImageInformation.getDefaultImageName());
            }
            return folderNameToImageNameMap;
        }

        private ImageToDeviceInformation(DefaultImageSet defaultImageName, String imageOptionsKey) {
            this.m_defaultImageName = defaultImageName;
            this.m_imageOptionsKey = imageOptionsKey;
        }

        public DefaultImageSet getDefaultImageName() {
            return this.m_defaultImageName;
        }

        public String getImageOptionsKey() {
            return this.m_imageOptionsKey;
        }
    }

    private static enum DefaultImageSet {
        DISPLAY_IPHONE3_IMAGES("icon.png", "Default.png", "Default-Land.png"),
        DISPLAY_IPAD_IMAGES("icon@2x.png", "Default-Portrait.png", "Default-Landscape.png"),
        DISPLAY_RETINA_IMAGES("icon-72.png", "Default@2x.png", "Default@2x-Landscape.png"),
        DISPLAY_IPAD_RETINA_IMAGES("icon-144.png", "Default-Portrait.png", "Default-Landscape@2x~ipad.png"),
        DISPLAY_IPHONE5_IMAGES("icon@2x.png", "Default-568h@2x.png", "Default-1135h@2x.png"),
        DISPLAY_IPAD_MINI_IMAGES("icon-72.png", "Default-Portrait-Ipad.png", "Default-Landscape-Ipad.png");

        private final String m_defaultAppImageName;
        private final String m_defaultPortraitSplashName;
        private final String m_defaultLandscapeSplashName;

        private DefaultImageSet(String defaultImageName, String defaultPortraitSplashImage, String defaultLandscapeSplashImage) {
            this.m_defaultAppImageName = defaultImageName;
            this.m_defaultPortraitSplashName = defaultPortraitSplashImage;
            this.m_defaultLandscapeSplashName = defaultLandscapeSplashImage;
        }

        public String getAppImageName() {
            return this.m_defaultAppImageName;
        }

        public String getPortraitSplashName() {
            return this.m_defaultPortraitSplashName;
        }

        public String getLandscapeSplashName() {
            return this.m_defaultLandscapeSplashName;
        }
    }
}

