/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.exec.ExecResults;
import oracle.adfmf.common.util.exec.ExecResultsLogger;
import oracle.adfmf.common.util.exec.ExecWrapper;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.options.DeploymentOptions;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;

public class IosFileUtils
extends DeployFileUtils {
    private static final String XSL_PREFERENCE_TRANSFORM_FILE = "oracle/adfmf/framework/dt/deploy/ios/core/PreferenceTransform.xsl";
    private static final String XSL_TRANSFORM_STRING_RESOURCES_FILE = "oracle/adfmf/framework/dt/deploy/ios/core/TransformStringResources.xsl";
    private static final String XCODE_STRINGS_DIRECTORY_NAME = "Strings";
    private static final String XCODE_PREFERENCE_SETTINGS_BUNDLE_DIRECTORY_NAME = "Settings.bundle";
    private static final String DEPLOYMENT_XCODE_IMAGES_FOLDER_NAME = "images";
    private static final String EXTENSION_XCODE_PROJECT_ZIP_FILE_NAME = "Oracle_ADFmc_Container_Template.zip";
    private static final String XCODE_TEMPLATE_PROJECT_FOLDER_NAME = "Template";
    private static final String EXTENSION_XCODE_LIBRARY_ZIP_FILE_NAME = "Oracle_ADFmc_Framework_Libraries.zip";
    private static final String IOS_DIR_NAME = "iOS";
    private static final String XCODE_TEMPLATE_LIB_FOLDER_NAME = "lib";
    private static final String XCODE_TEMPLATE_FRAMEWORKS_FOLDER_NAME = "Frameworks";
    private static final String XCODE_TEMPLATE_FRAMEWORKS_CVM_FOLDER_NAME = "OracleCVM.sdk";
    private static final String XCODE_TEMPLATE_LIBRARY_FOLDER_NAME = "libraries";
    private static final String XCODE_TEMPLATE_EMULATOR_DEBUG_FOLDER_NAME = "EmulatorDebug";
    private static final String XCODE_TEMPLATE_EMULATOR_RELEASE_FOLDER_NAME = "EmulatorRelease";
    private static final String XCODE_TEMPLATE_DEVICE_DEBUG_FOLDER_NAME = "DeviceDebug";
    private static final String XCODE_TEMPLATE_DEVICE_RELEASE_FOLDER_NAME = "DeviceRelease";
    private static final String XCODE_PROJECT_DIRECTORY_NAME = "temporary_xcode_project";
    public static final String APPLICATION_PLIST_FILE_NAME = "Oracle_ADFmc_Container_Template-Info.plist";
    public static final String CORDOVA_PLIST_FILE_NAME = "Cordova.plist";
    private static final String ROOT_PLIST_FILE_NAME = "Root.plist";
    private static final String IOS_APPLICATION_DEVICE_DIRECTORY_RELATIVE_PATH = "Oracle_ADFmc_Container_Application/device";
    private static final String XCODEBUILD_APPLICATIONS_FOLDER_NAME = "Applications";
    private static final String IOS_APPLICATION_BUNDLE_EXTENSION = ".app";
    private static final String XCODE_BUILD_DSTROOT_FOLDER_NAME = "Destination_Root";
    private final SimulatorFileUtils _simulatorFileUtils = new SimulatorFileUtils();
    private final DeploymentOptions _iosDeployOptions;
    private final IosCvmFileUtils _iosCvmFileUtils = new IosCvmFileUtils();
    private final OracleCvmFileUtils _oracleCvmFileUtils = new OracleCvmFileUtils();
    private String _deployToEmulatorVersion = null;

    public IosFileUtils(Workspace workspace, McIosFrameworkProfile profile) throws DeployException {
        super(workspace, profile);
        this._iosDeployOptions = profile.getDeploymentOptions();
    }

    SimulatorFileUtils getSimulatorFileUtils() {
        return this._simulatorFileUtils;
    }

    public URL getDeploymentXcodeFolderUrl() {
        URL deploymentFolderUrl = this.getOutputDirectoryURL();
        return URLFactory.newDirURL((URL)deploymentFolderUrl, (String)IosFileUtils.getXcodeProjectDirectoryName());
    }

    public static String getXcodeProjectDirectoryName() {
        return XCODE_PROJECT_DIRECTORY_NAME;
    }

    public URL getDeploymentXcodeLibFolderUrl() {
        URL deploymentXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        return URLFactory.newDirURL((URL)deploymentXcodeFolderUrl, (String)XCODE_TEMPLATE_LIB_FOLDER_NAME);
    }

    public URL getDeploymentXcodeFrameworkFolderUrl() {
        URL deploymentXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        return URLFactory.newDirURL((URL)deploymentXcodeFolderUrl, (String)XCODE_TEMPLATE_FRAMEWORKS_FOLDER_NAME);
    }

    @Override
    public final URL getFarsExtractionParentFolderUrl() {
        return this.getDeploymentXcodeFolderUrl();
    }

    @Override
    public URL getDeploymentAdfmfApplicationXmlFileUrl() {
        URL tempXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        URL configDirectory = URLFactory.newDirURL((URL)tempXcodeFolderUrl, (String)"Configuration");
        return URLFactory.newDirURL((URL)configDirectory, (String)"adfmf-application.xml");
    }

    @Override
    public URL getDeploymentCacertsFileUrl() {
        URL tempXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        URL libDirectory = URLFactory.newDirURL((URL)tempXcodeFolderUrl, (String)XCODE_TEMPLATE_LIB_FOLDER_NAME);
        URL securityDirectory = URLFactory.newDirURL((URL)libDirectory, (String)"security");
        return URLFactory.newURL((URL)securityDirectory, (String)"cacerts");
    }

    @Override
    public URL getDeploymentAdfmfConfigURL() {
        URL tempXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        URL configDirectory = URLFactory.newDirURL((URL)tempXcodeFolderUrl, (String)"Configuration");
        return URLFactory.newDirURL((URL)configDirectory, (String)"adfmf-config.xml");
    }

    @Override
    public URL getDeploymentFARsURL() {
        URL tempXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        return URLFactory.newDirURL((URL)tempXcodeFolderUrl, (String)"FARs");
    }

    @Override
    public URL getPlatformSpecificJavaScriptSourceZipURL() {
        URL zipFileUrl = null;
        URL supportFilesDirectoryURL = FileUtils.getSupportFilesDirectoryUrl();
        URL javascriptSrcDir = URLFactory.newDirURL((URL)supportFilesDirectoryURL, (String)"javascript");
        URL javascriptIosSrcDir = URLFactory.newDirURL((URL)javascriptSrcDir, (String)IOS_DIR_NAME);
        zipFileUrl = this.isDebugMode() ? URLFactory.newDirURL((URL)javascriptIosSrcDir, (String)"ADFmf_AmxJavascript_debug_iOS.zip") : URLFactory.newDirURL((URL)javascriptIosSrcDir, (String)"ADFmf_AmxJavascript_release_iOS.zip");
        return URLFactory.newJarURL((URL)zipFileUrl, null);
    }

    public URL getXslPreferenceTransformFileUrl() {
        return this.getClass().getClassLoader().getResource(XSL_PREFERENCE_TRANSFORM_FILE);
    }

    public URL getXslStringResourceTransformFileUrl() {
        return this.getClass().getClassLoader().getResource(XSL_TRANSFORM_STRING_RESOURCES_FILE);
    }

    public URL getXcodeStringsDirectoryUrl() {
        URL tempXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        return URLFactory.newDirURL((URL)tempXcodeFolderUrl, (String)XCODE_STRINGS_DIRECTORY_NAME);
    }

    public URL getSettingsBundleDirectoryUrl() {
        URL tempXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        return URLFactory.newDirURL((URL)tempXcodeFolderUrl, (String)XCODE_PREFERENCE_SETTINGS_BUNDLE_DIRECTORY_NAME);
    }

    public URL getRootPlistFileUrl() {
        URL settingsBundleFolderUrl = this.getSettingsBundleDirectoryUrl();
        return URLFactory.newURL((URL)settingsBundleFolderUrl, (String)ROOT_PLIST_FILE_NAME);
    }

    @Override
    public URL getDeploymentAdfmfFeatureXmlFileUrl() {
        URL tempXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        URL configDirectory = URLFactory.newDirURL((URL)tempXcodeFolderUrl, (String)"Configuration");
        return URLFactory.newDirURL((URL)configDirectory, (String)ADFMobileConstants.FEATURE_XML_FILENAME);
    }

    public URL getProjectWebContentFolderUrl() {
        URL projectPathUrl = URLFileSystem.getParent((URL)this.getProject().getURL());
        return URLFactory.newDirURL((URL)projectPathUrl, (String)"public_html");
    }

    public URL getProjectAdfmsrcFolderUrl() {
        URL projectPathUrl = URLFileSystem.getParent((URL)this.getProject().getURL());
        return URLFactory.newDirURL((URL)projectPathUrl, (String)"adfmsrc");
    }

    @Override
    public URL getApplicationWebContentURL() {
        URL tempXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        return URLFactory.newDirURL((URL)tempXcodeFolderUrl, (String)"www");
    }

    public URL getProjectImagesFolderUrl() {
        Workspace workspace = this.getWorkspace();
        return McAppUtils.getSourceImageDir(workspace);
    }

    public URL getDeploymentXcodeImagesFolderUrl() {
        URL tempXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        return URLFactory.newDirURL((URL)tempXcodeFolderUrl, (String)DEPLOYMENT_XCODE_IMAGES_FOLDER_NAME);
    }

    private URL getExtensionXcodeProjectZipFileUrl() {
        URL extensionDirectoryUrl = FileUtils.getSupportFilesDirectoryUrl();
        URL zipFileUrl = URLFactory.newURL((URL)extensionDirectoryUrl, (String)EXTENSION_XCODE_PROJECT_ZIP_FILE_NAME);
        return URLFactory.newJarURL((URL)zipFileUrl, null);
    }

    public URL getExtensionXcodeProjectUrl() {
        URL zipFileUrl = this.getExtensionXcodeProjectZipFileUrl();
        return URLFactory.newDirURL((URL)zipFileUrl, (String)XCODE_TEMPLATE_PROJECT_FOLDER_NAME);
    }

    private URL getExtensionXcodeLibraryZipFileUrl() {
        URL extensionDirectoryUrl = FileUtils.getSupportFilesDirectoryUrl();
        URL zipFileUrl = URLFactory.newURL((URL)extensionDirectoryUrl, (String)EXTENSION_XCODE_LIBRARY_ZIP_FILE_NAME);
        return URLFactory.newJarURL((URL)zipFileUrl, null);
    }

    public URL getExtensionXcodeFrameworkProjectUrl() {
        URL zipFileUrl = this.getExtensionXcodeLibraryZipFileUrl();
        return URLFactory.newDirURL((URL)zipFileUrl, (String)XCODE_TEMPLATE_FRAMEWORKS_FOLDER_NAME);
    }

    public static URL getExtensionIosResourcesUrl() {
        URL extensionDirectoryUrl = FileUtils.getSupportFilesDirectoryUrl();
        URL resourcesUrl = URLFactory.newURL((URL)extensionDirectoryUrl, (String)"resources");
        return URLFactory.newURL((URL)resourcesUrl, (String)"ios");
    }

    public URL getOsxUserHomeDirectoryUrl() {
        String userHome = ADFMobileConstants.USER_HOME;
        return URLFactory.newDirURL((String)userHome);
    }

    public URL getCordovaPlistUrl() {
        URL deploymentXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        return URLFactory.newURL((URL)deploymentXcodeFolderUrl, (String)CORDOVA_PLIST_FILE_NAME);
    }

    public URL getCordovaPlistExtensionUrl() {
        return URLFactory.newJarURL((URL)this.getExtensionXcodeProjectUrl(), (String)CORDOVA_PLIST_FILE_NAME);
    }

    public URL getBuiltApplicationUrl() {
        URL parentDirUrl = this.getDestinationRootOutputFolderUrl();
        URL applicationsFolderPathUrl = URLFactory.newDirURL((URL)parentDirUrl, (String)XCODEBUILD_APPLICATIONS_FOLDER_NAME);
        return URLFactory.newDirURL((URL)applicationsFolderPathUrl, (String)this.getApplicationBundleName());
    }

    public URL getDestinationRootOutputFolderUrl() {
        URL deploymentFolderUrl = this.getOutputDirectoryURL();
        return URLFactory.newDirURL((URL)deploymentFolderUrl, (String)XCODE_BUILD_DSTROOT_FOLDER_NAME);
    }

    public URL getDeviceApplicationDirUrl() {
        URL parentDirUrl = this.getDestinationRootOutputFolderUrl();
        return URLFactory.newDirURL((URL)parentDirUrl, (String)IOS_APPLICATION_DEVICE_DIRECTORY_RELATIVE_PATH);
    }

    public URL getBuiltIpaFileUrl() {
        URL parentDirUrl = this.getDeviceApplicationDirUrl();
        return URLFactory.newURL((URL)parentDirUrl, (String)this.getIpaFileName());
    }

    public String getIpaFileNameNoExt() {
        return this.getApplicationBundleNameNoExt();
    }

    public String getIpaFileName() {
        String IPA_FILE_EXTENSION = ".ipa";
        return this.getIpaFileNameNoExt() + ".ipa";
    }

    public URL getAutomaticallyAddToItunesDirUrl() throws DeployException {
        String automaticallyAddToITunesDirectory = IosDeployUtil.getIosAutomaticallyAddToITunesPath();
        return URLFactory.newDirURL((String)automaticallyAddToITunesDirectory);
    }

    public URL getApplicationPlistFileUrl() {
        URL deploymentXcodeFolderUrl = this.getDeploymentXcodeFolderUrl();
        return URLFactory.newURL((URL)deploymentXcodeFolderUrl, (String)APPLICATION_PLIST_FILE_NAME);
    }

    public URL getApplicationDefaultResourceFolderURL() {
        URL resourcesFolderUrl = McAppUtils.getResourcesDir(this.getWorkspace());
        return URLFactory.newDirURL((URL)resourcesFolderUrl, (String)"ios");
    }

    public URL getApplicationResourceImageUrl(String iosResourceImageFileName) {
        URL iosResourceFolderUrl = this.getApplicationDefaultResourceFolderURL();
        return URLFactory.newURL((URL)iosResourceFolderUrl, (String)iosResourceImageFileName);
    }

    public URL getProjectXliffBasePathUrl() {
        URL projectFileUrl = this.getProject().getURL();
        URL projectDirectoryUrl = URLFileSystem.getParent((URL)projectFileUrl);
        return URLFactory.newDirURL((URL)projectDirectoryUrl, (String)"src");
    }

    @Override
    public boolean doesTemplateExist() {
        URL destinationFolder = this.getDeploymentXcodeFolderUrl();
        URL destinationFrameworkZipFolder = this.getDeploymentXcodeFrameworkFolderUrl();
        return URLFileSystem.exists((URL)destinationFolder) && URLFileSystem.exists((URL)destinationFrameworkZipFolder);
    }

    @Override
    public boolean isDebugMode() {
        return this._iosDeployOptions.getDebugFlag();
    }

    public IosCvmFileUtils getIosCvmFileUtils() {
        return this._iosCvmFileUtils;
    }

    public OracleCvmFileUtils getOracleCvmFileUtils() {
        return this._oracleCvmFileUtils;
    }

    @Override
    public void copyPlatformSpecificSecurityFiles() throws IOException {
    }

    @Override
    public void addFilesToExistingZip(URL zipFileURL, URL newFilesBasePathURL, Logger logger) throws DeployException, IllegalArgumentException {
        if (null == zipFileURL || null == newFilesBasePathURL || null == logger || !URLFileSystem.isDirectoryPath((URL)newFilesBasePathURL) || !URLFileSystem.exists((URL)zipFileURL) || URLFileSystem.isDirectoryPath((URL)zipFileURL)) {
            throw new IllegalArgumentException();
        }
        String ZIP_TOOL_NAME = "zip";
        String ZIP_TOOL_ARG_UPDATE_RECURSIVE = "-ur";
        String ZIP_TOOL_ARG_THIS_DIR = "./";
        try {
            String zipFileName = zipFileURL.getFile();
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("zip");
            cmdList.add("-ur");
            cmdList.add(zipFileName);
            cmdList.add("./");
            File baseDirectory = new File(newFilesBasePathURL.getFile());
            ExecResults execResults = ExecWrapper.runTool(cmdList, null, baseDirectory);
            ExecResultsLogger execResultsLogger = new ExecResultsLogger(logger, execResults, null, null);
            execResultsLogger.logExecResults(Level.FINEST);
            if (!execResults.returnCodeOK()) {
                String errMsg = MobileResourceUtils.getMsg("ADF-MBL-02002", "zip", execResults.getMessageContentAsString());
                throw new DeployException(errMsg);
            }
        }
        catch (Exception e) {
            DeployException de = null;
            de = !(e instanceof DeployException) ? new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02002", "zip", e.getMessage())) : (DeployException)((Object)e);
            throw de;
        }
    }

    public final String getApplicationBundleNameNoExt() {
        return this._iosDeployOptions.getApplicationArchiveName();
    }

    private final String getApplicationBundleName() {
        return this.getApplicationBundleNameNoExt() + IOS_APPLICATION_BUNDLE_EXTENSION;
    }

    final class OracleCvmFileUtils {
        OracleCvmFileUtils() {
        }

        public URL getX86SourceUrl() {
            URL oracleCvmSdkSrcUrl = null;
            oracleCvmSdkSrcUrl = IosFileUtils.this.isDebugMode() ? this._getSourceUrl(IosFileUtils.XCODE_TEMPLATE_EMULATOR_DEBUG_FOLDER_NAME) : this._getSourceUrl(IosFileUtils.XCODE_TEMPLATE_EMULATOR_RELEASE_FOLDER_NAME);
            return oracleCvmSdkSrcUrl;
        }

        public URL getArmSourceUrl() {
            URL oracleCvmSdkSrcUrl = null;
            oracleCvmSdkSrcUrl = IosFileUtils.this.isDebugMode() ? this._getSourceUrl(IosFileUtils.XCODE_TEMPLATE_DEVICE_DEBUG_FOLDER_NAME) : this._getSourceUrl(IosFileUtils.XCODE_TEMPLATE_DEVICE_RELEASE_FOLDER_NAME);
            return oracleCvmSdkSrcUrl;
        }

        public URL getTargetUrl() {
            URL deploymentFrameworkFolderUrl = IosFileUtils.this.getDeploymentXcodeFrameworkFolderUrl();
            return URLFactory.newDirURL((URL)deploymentFrameworkFolderUrl, (String)IosFileUtils.XCODE_TEMPLATE_FRAMEWORKS_CVM_FOLDER_NAME);
        }

        private URL _getSourceUrl(String subFolderName) {
            URL libFolderURL = URLFactory.newDirURL((URL)FileUtils.getSupportFilesDirectoryUrl(), (String)IosFileUtils.XCODE_TEMPLATE_LIBRARY_FOLDER_NAME);
            URL extensionLibraryDir = URLFactory.newDirURL((URL)libFolderURL, (String)subFolderName);
            URL zipFileUrl = FileUtils.getLibraryZipFileUrl(extensionLibraryDir, "OracleCVM.sdk.zip");
            return URLFactory.newJarURL((URL)zipFileUrl, (String)IosFileUtils.XCODE_TEMPLATE_FRAMEWORKS_CVM_FOLDER_NAME);
        }
    }

    final class IosCvmFileUtils {
        IosCvmFileUtils() {
        }

        public URL getX86SourceUrl() {
            return URLFactory.newDirURL((URL)this._getSourceRootDirectoryUrl(), (String)"x86");
        }

        public URL getArmSourceUrl() {
            return URLFactory.newDirURL((URL)this._getSourceRootDirectoryUrl(), (String)"arm");
        }

        public URL getJarSourceUrl() {
            return URLFactory.newDirURL((URL)this._getSourceRootDirectoryUrl(), (String)"jar");
        }

        public URL getTargetUrl() {
            return IosFileUtils.this.getDeploymentXcodeLibFolderUrl();
        }

        private URL _getSourceRootDirectoryUrl() {
            URL iosCvmJdkSrcDirUrl = null;
            iosCvmJdkSrcDirUrl = IosFileUtils.this.isDebugMode() ? URLFactory.newDirURL((URL)this._getTemplateIosCvmJdkRootDirectoryUrl(), (String)"jvmti") : URLFactory.newDirURL((URL)this._getTemplateIosCvmJdkRootDirectoryUrl(), (String)"release");
            return iosCvmJdkSrcDirUrl;
        }

        private URL _getTemplateIosCvmJdkRootDirectoryUrl() {
            URL extensionDirectoryUrl = FileUtils.getSupportFilesDirectoryUrl();
            URL iOSUrl = URLFactory.newDirURL((URL)extensionDirectoryUrl, (String)IosFileUtils.IOS_DIR_NAME);
            return iOSUrl;
        }
    }

    class SimulatorFileUtils {
        private static final String SIMULATOR_HOME_INSTALL_RELATIVE_DIRECTORY_PATH = "Library/Application Support/iPhone Simulator";
        private static final String SIMULATOR_APP_FOLDER_NAME = "Applications";
        private static final String SIMULATOR_LIBRARY_PREFERENCES_RELATIVE_DIR = "Library/Preferences/";
        private static final String GLOBAL_PREFERENCES_FILE_NAME = ".GlobalPreferences.plist";

        SimulatorFileUtils() {
        }

        public URL getAppInstallDirectoryPathNameUrl() {
            URL simulatorAppInstallDirUrl = this.getSimulatorAppInstallationDirUrl();
            String appBundleId = IosFileUtils.this._iosDeployOptions.getAppBundleId();
            URL directoryUrl = URLFactory.newDirURL((URL)simulatorAppInstallDirUrl, (String)appBundleId);
            return directoryUrl;
        }

        public URL getApplicationGlobalPreferenceAliasFileUrl() throws DeployException {
            URL appInstallDirUrl = this.getApplicationPreferencesDirectoryUrl();
            return URLFactory.newURL((URL)appInstallDirUrl, (String)GLOBAL_PREFERENCES_FILE_NAME);
        }

        public URL getApplicationPreferencesDirectoryUrl() {
            URL appInstallDirUrl = this.getAppInstallDirectoryPathNameUrl();
            return URLFactory.newDirURL((URL)appInstallDirUrl, (String)SIMULATOR_LIBRARY_PREFERENCES_RELATIVE_DIR);
        }

        public URL getGlobalPreferenceFileUrl() {
            URL simulatorVersionDir = this.getIphoneSimulatorVersionDirectoryUrl();
            URL simulatorPreferencesDirectoryUrl = URLFactory.newDirURL((URL)simulatorVersionDir, (String)SIMULATOR_LIBRARY_PREFERENCES_RELATIVE_DIR);
            return URLFactory.newURL((URL)simulatorPreferencesDirectoryUrl, (String)GLOBAL_PREFERENCES_FILE_NAME);
        }

        private URL getSimulatorAppInstallationDirUrl() {
            URL simulatorVersionDir = this.getIphoneSimulatorVersionDirectoryUrl();
            return URLFactory.newDirURL((URL)simulatorVersionDir, (String)"Applications");
        }

        private URL getIphoneSimulatorVersionDirectoryUrl() {
            if (!ModelUtil.hasLength((String)IosFileUtils.this._deployToEmulatorVersion)) {
                IosFileUtils.this._deployToEmulatorVersion = IosDeployUtil.getSimulatorTargetVersion(IosFileUtils.this._iosDeployOptions);
            }
            String userHomeDirectory = ADFMobileConstants.USER_HOME;
            URL userHomeDirectoryUrl = URLFactory.newDirURL((String)userHomeDirectory);
            URL simulatorDir = URLFactory.newDirURL((URL)userHomeDirectoryUrl, (String)SIMULATOR_HOME_INSTALL_RELATIVE_DIRECTORY_PATH);
            return URLFactory.newDirURL((URL)simulatorDir, (String)IosFileUtils.this._deployToEmulatorVersion);
        }

        public List<URL> getDeployedSimulatorApplicationBundles() throws IOException {
            URLFilenameFilter filter = new URLFilenameFilter(){

                public boolean accept(URL url, String name) {
                    boolean isIosApplicationBundleDirectory = false;
                    if (name.endsWith(IosFileUtils.IOS_APPLICATION_BUNDLE_EXTENSION)) {
                        URL childFileSytemElement = URLFactory.newDirURL((URL)url, (String)name);
                        isIosApplicationBundleDirectory = URLFileSystem.isDirectory((URL)childFileSytemElement);
                    }
                    return isIosApplicationBundleDirectory;
                }
            };
            URL iosAppBundleInstallDir = this.getAppInstallDirectoryPathNameUrl();
            ArrayList<URL> list = new ArrayList<URL>();
            if (URLFileSystem.exists((URL)iosAppBundleInstallDir)) {
                URL[] appBundleFolderUrls = URLFileSystem.list((URL)iosAppBundleInstallDir, (URLFilenameFilter)filter);
                if (appBundleFolderUrls == null) {
                    throw new IOException(MobileResourceUtils.getMsg("ADF-MBL-01015", iosAppBundleInstallDir.getPath()));
                }
                list.addAll(Arrays.asList(appBundleFolderUrls));
            }
            return list;
        }
    }
}

