/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.exec.ExecResults;
import oracle.adfmf.common.util.exec.ExecResultsLogger;
import oracle.adfmf.common.util.exec.ExecWrapper;
import oracle.adfmf.common.util.xsltransformer.TransformException;
import oracle.adfmf.common.util.xsltransformer.XMLTransformer;
import oracle.adfmf.common.util.xsltransformer.XSLParameter;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.adfmf.framework.dt.deploy.ios.core.IosFileUtils;
import oracle.adfmf.framework.dt.deploy.ios.core.IosImageUtil;
import oracle.adfmf.framework.dt.deploy.ios.core.PlistUtils;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IosDeployer {
    private static final String IOS_NAMESPACE = "";
    private static final String XSL_PARAM_FAR_URL_NODESET = "XSL_PARAM_FeatureArchiveUrlNodeSet";
    private static final String ITUNES_ARTWORK = "iTunesArtwork";

    public static void createIosPreferenceFiles(IosFileUtils iosFiles, Logger logger) throws DeployException {
        logger.log(Level.FINEST, "About to create iOS preference files driven by file 'adfmf-application.xml'.");
        try {
            ArrayList<XSLParameter> xslParamList = new ArrayList<XSLParameter>();
            URL pListDestinationPath = iosFiles.getSettingsBundleDirectoryUrl();
            String XSL_PARAM_SETTINGS_BUNDLE_DIRECTORY_PATH = "XSL_PARAM_SettingsBundleFolderPath";
            xslParamList.add(new XSLParameter(IOS_NAMESPACE, "XSL_PARAM_SettingsBundleFolderPath", pListDestinationPath.toExternalForm()));
            String XSL_PARAM_FEATURE_XML_RELATIVE_PATH_IN_FAR = "XSL_PARAM_FeatureXmlRelativePathInFAR";
            xslParamList.add(new XSLParameter(IOS_NAMESPACE, "XSL_PARAM_FeatureXmlRelativePathInFAR", ADFMobileConstants.FEATURE_XML_FAR_PATH));
            IosDeployer.addFarUrlsToXslParamList(xslParamList, iosFiles);
            URL xslUrl = iosFiles.getXslPreferenceTransformFileUrl();
            URL adfmfAppXmlFileUrl = iosFiles.getAdfmfApplicationXmlFileUrl();
            XMLTransformer.transformXml(xslUrl, adfmfAppXmlFileUrl, xslParamList, logger);
        }
        catch (TransformException e) {
            throw new DeployException((Throwable)e);
        }
        logger.log(Level.FINEST, "Successfully created iOS preferences driven by file 'adfmf-application.xml'.");
    }

    private static void addFarUrlsToXslParamList(List<XSLParameter> xslParamList, IosFileUtils iosFiles) throws DeployException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            String TEMP_DOCUMENT_ROOT_NAME = "Root";
            Element rootElement = document.createElementNS(null, "Root");
            document.appendChild(rootElement);
            String FAR_URL_ELEMENT_TAG_NAME = "FAR_URL";
            List<URL> list = iosFiles.getFeatureFarExtractionFolderUrls();
            for (URL currFarUrl : list) {
                Element element = document.createElementNS(null, "FAR_URL");
                element.appendChild(document.createTextNode(currFarUrl.toExternalForm()));
                rootElement.appendChild(element);
            }
            NodeList nodeList = rootElement.getChildNodes();
            xslParamList.add(new XSLParameter(IOS_NAMESPACE, XSL_PARAM_FAR_URL_NODESET, nodeList));
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
    }

    public static boolean isXcodeInstalled(Logger logger) throws DeployException, IOException, InterruptedException {
        boolean xCodeFound = true;
        String sdkPath = IosDeployUtil.getIosSdkPath();
        if (!FileUtils.isiOSSdkVersionValid(sdkPath)) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01016", "6.0");
            throw new DeployException(msg);
        }
        URL xcodebuildDirUrl = URLFactory.newDirURL((String)IosDeployUtil.getXcodebuildPath());
        IosDeployUtil.throwExceptionOnInvalidXcodeVersion(logger, xcodebuildDirUrl);
        return xCodeFound;
    }

    public static void deployToArchive(IosFileUtils iosFiles) throws IOException {
        URL appIpaFileURL = iosFiles.getBuiltIpaFileUrl();
        URL deployProfileDir = iosFiles.getOutputDirectoryURL();
        FileUtils.copyFile(appIpaFileURL, deployProfileDir, null);
    }

    public static void deployToDevice(IosFileUtils iosFiles) throws IOException {
        URL appIpaFileURL = iosFiles.getBuiltIpaFileUrl();
        URL iTunesAutoAddDir = iosFiles.getAutomaticallyAddToItunesDirUrl();
        FileUtils.copyFile(appIpaFileURL, iTunesAutoAddDir, null);
    }

    public static void copyAdfMobileXmlFile(IosFileUtils iosFiles, Logger logger) throws IOException {
        if (logger.getLevel() == Level.FINEST) {
            logger.log(Level.FINEST, "About to copy adfmf-application.xml to the template XCode project.");
        }
        DeployFileUtils.copyAdfMobileXmlFiles(iosFiles);
        URL cvmDestinationURL = iosFiles.getDeploymentXcodeLibFolderUrl();
        iosFiles.copyCvmAndLoggingPropertiesFiles(cvmDestinationURL, cvmDestinationURL);
        if (logger.getLevel() == Level.FINEST) {
            String msg = "Successfully copied adfmf-application.xml to the template XCode project.";
            logger.log(Level.FINEST, "Successfully copied adfmf-application.xml to the template XCode project.");
        }
    }

    public static void copyImagesFolder(IosFileUtils iosFiles, Logger logger) throws IOException {
        logger.log(Level.FINEST, "About to copy project image content to the template XCode project.");
        URL sourceImageLocation = iosFiles.getProjectImagesFolderUrl();
        URL destinationImageLocation = iosFiles.getDeploymentXcodeImagesFolderUrl();
        FileUtils.copyDirectory(sourceImageLocation, destinationImageLocation);
        if (logger.getLevel() == Level.FINEST) {
            String msg = String.format("Successfully copied project image content from directory '%s' to '%s'.", URLFileSystem.getPlatformPathName((URL)sourceImageLocation), URLFileSystem.getPlatformPathName((URL)destinationImageLocation));
            logger.log(Level.FINEST, msg);
        }
    }

    public static void copyCustomImages(IosFileUtils iosFiles, ImageOptions imageOptions, Logger logger) throws IOException {
        logger.log(Level.FINEST, "Copying customized image content to the template XCode project.");
        URL destinationImageLocation = iosFiles.getDeploymentXcodeFolderUrl();
        URL iosResourceSourceURL = iosFiles.getApplicationDefaultResourceFolderURL();
        FileUtils.copyDirectoryContent(iosResourceSourceURL, destinationImageLocation);
        IosImageUtil.copyApplicationImages(imageOptions, iosFiles);
        if (logger.getLevel() == Level.FINEST) {
            String msg = String.format("Successfully copied customized image content to '%s'.", URLFileSystem.getPlatformPathName((URL)destinationImageLocation));
            logger.log(Level.FINEST, msg);
        }
    }

    private static void copyImageHelper(Workspace workspace, String srcImagePath, URL destinationImageLocation, String destinationFileName, Logger logger, String defaultFileName) throws IOException {
        block6: {
            try {
                if (null != srcImagePath && !srcImagePath.isEmpty()) {
                    String absolutePath = FileUtils.getAbsoluteLocation(workspace, srcImagePath);
                    URL sourceImageLocation = URLFactory.newFileURL((String)absolutePath);
                    FileUtils.copyFile(sourceImageLocation, destinationImageLocation, destinationFileName);
                } else {
                    URL iosResourceImageUrl;
                    URL uRL = iosResourceImageUrl = null != defaultFileName && !defaultFileName.isEmpty() ? IosDeployUtil.getApplicationResourceImageUrl(defaultFileName) : IosDeployUtil.getApplicationResourceImageUrl(destinationFileName);
                    if (null != iosResourceImageUrl && !iosResourceImageUrl.getPath().isEmpty()) {
                        FileUtils.copyFile(iosResourceImageUrl, destinationImageLocation, destinationFileName);
                        String msg = MobileResourceUtils.getMsg("ADF-MBL-21000", URLFileSystem.getPlatformPathName((URL)iosResourceImageUrl));
                        logger.log(Level.INFO, msg);
                    } else {
                        String msg = MobileResourceUtils.getMsg("ADF-MBL-10009", srcImagePath);
                        logger.log(Level.WARNING, msg);
                    }
                }
            }
            catch (IOException e) {
                if (logger.getLevel() != Level.WARNING) break block6;
                String msg = MobileResourceUtils.getMsg("ADF-MBL-10009", srcImagePath);
                logger.log(Level.WARNING, msg);
            }
        }
    }

    public static void copyTemplateXcodeProject(IosFileUtils iosFiles, Logger logger) throws IOException {
        if (!iosFiles.doesTemplateExist()) {
            URL destinationFolder = iosFiles.getDeploymentXcodeFolderUrl();
            URL destinationFrameworkZipFolder = iosFiles.getDeploymentXcodeFrameworkFolderUrl();
            logger.log(Level.FINEST, "About to copy the template Xcode project");
            URL sourceTemplateZipFile = iosFiles.getExtensionXcodeProjectUrl();
            FileUtils.copyDirectory(sourceTemplateZipFile, destinationFolder);
            URL sourceFrameworkZipFile = iosFiles.getExtensionXcodeFrameworkProjectUrl();
            FileUtils.copyDirectory(sourceFrameworkZipFile, destinationFrameworkZipFolder);
            logger.log(Level.FINEST, "Successfully copied the template Xcode project.");
        } else {
            URL cordovaPlistUrl = iosFiles.getCordovaPlistUrl();
            FileUtils.deleteFile(cordovaPlistUrl);
            URL cordovaPlistInTemplateUrl = iosFiles.getCordovaPlistExtensionUrl();
            FileUtils.copyFile(cordovaPlistInTemplateUrl, URLFileSystem.getParent((URL)cordovaPlistUrl), null);
        }
    }

    public static void startSimulator(Logger logger) throws DeployException, IOException {
        String SCRIPT = "tell application \"iPhone Simulator\" to activate";
        try {
            IosDeployer._executeAppleScript(logger, "tell application \"iPhone Simulator\" to activate");
        }
        catch (InterruptedException e) {
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("tell application \"iPhone Simulator\" to activate");
            FileUtils.logCommand(logger, null, cmdList);
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01007");
            throw new DeployException(msg, (Throwable)e);
        }
    }

    public static void stopSimulator(Logger logger) throws DeployException, IOException {
        String SCRIPT = "tell application \"iPhone Simulator\" to quit";
        try {
            IosDeployer._executeAppleScript(logger, "tell application \"iPhone Simulator\" to quit");
        }
        catch (InterruptedException e) {
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("tell application \"iPhone Simulator\" to quit");
            FileUtils.logCommand(logger, null, cmdList);
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01008");
            throw new DeployException(msg, (Throwable)e);
        }
    }

    public static void deployToEmulator(IosFileUtils iosFiles, Logger logger) throws IOException, DeployException {
        IosDeployer._cleanSimulatorApplicationDirectory(iosFiles, logger);
        IosDeployUtil.nativeCopyDirectoryInclusive(iosFiles.getBuiltApplicationUrl(), iosFiles.getSimulatorFileUtils().getAppInstallDirectoryPathNameUrl(), logger);
        IosDeployUtil.createGlobalPreferenceFileAlias(iosFiles, logger);
    }

    public static void buildXcodeApplication(McIosFrameworkProfile profile, IosFileUtils iosFiles, boolean bDebugBuild, boolean bEmulatorBuild, Logger logger) throws IOException, InterruptedException {
        IosDeployer.deleteRootXcodebuildOutputFolder(iosFiles);
        IosDeployer.buildXcodeApplicationForProcessor(profile, iosFiles, bDebugBuild, bEmulatorBuild, logger);
        URL sourceAppUrl = iosFiles.getBuiltApplicationUrl();
        IosDeployer.validateBuiltAppExists(sourceAppUrl, logger);
        logger.log(Level.FINEST, "Successfully built Xcode Application.");
    }

    private static void deleteRootXcodebuildOutputFolder(IosFileUtils iosFiles) throws IOException {
        URL dstRootFolderUrl = iosFiles.getDestinationRootOutputFolderUrl();
        FileUtils.deleteDirectory(dstRootFolderUrl);
    }

    private static void validateBuiltAppExists(URL xCodeApplicationUrl, Logger logger) throws DeployException {
        if (!URLFileSystem.exists((URL)xCodeApplicationUrl)) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-00031", xCodeApplicationUrl.getPath());
            throw new DeployException(msg);
        }
        logger.log(Level.FINEST, "The Xcode simulator app exists at: " + xCodeApplicationUrl.toString());
    }

    private static void buildXcodeApplicationForProcessor(McIosFrameworkProfile profile, IosFileUtils iosFiles, boolean bDebugBuild, boolean bEmulatorBuild, Logger logger) throws IOException, InterruptedException {
        List<String> cmdList = IosDeployer.getXcodeCommandList(iosFiles, profile, bDebugBuild, bEmulatorBuild, logger);
        URL destinationFolderUrl = iosFiles.getDeploymentXcodeFolderUrl();
        String destPath = destinationFolderUrl.getPath();
        File workingDirectory = new File(destPath);
        FileUtils.logCommand(logger, destPath, cmdList);
        ExecResults execResults = ExecWrapper.runTool(cmdList, null, workingDirectory);
        List<String> xcodeErrorTokenList = IosDeployUtil.getXcodeErrorTokenList();
        List<String> xcodeWarningTokenList = IosDeployUtil.getXcodeWarningTokenList();
        ExecResultsLogger execResultsLogger = new ExecResultsLogger(logger, execResults, xcodeErrorTokenList, xcodeWarningTokenList);
        execResultsLogger.setLogCommandLine(false);
        execResultsLogger.logExecResults(Level.FINEST);
        if (!execResults.completedOK(xcodeErrorTokenList)) {
            throw new IOException(MobileResourceUtils.getMsg("ADF-MBL-02002", execResults.getCommandLineFullyQualifiedPath(), execResults.getErrorMessagesAsString(xcodeErrorTokenList)));
        }
    }

    private static List<String> getXcodeCommandList(IosFileUtils iosFiles, McIosFrameworkProfile profile, boolean bDebugBuild, boolean bEmulatorBuild, Logger logger) throws DeployException {
        String xcodebuildFullPath = IosDeployUtil.getXcodebuildFullPath();
        List<String> arguments = IosDeployer.getXcodebuildArguments(iosFiles, profile, bDebugBuild, bEmulatorBuild, logger);
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(xcodebuildFullPath);
        cmdList.addAll(arguments);
        return cmdList;
    }

    private static List<String> getXcodebuildArguments(IosFileUtils iosFiles, McIosFrameworkProfile profile, boolean bDebugBuild, boolean bEmulatorBuild, Logger logger) throws DeployException {
        String ARGUMENT_VALUE_CERTIFICATE;
        String ARGUMENT_SWITCH_CLEAN = "clean";
        String ARGUMENT_SWITCH_INSTALL = "install";
        String ARGUMENT_SWITCH_CONFIGURATION = "-configuration";
        String ARGUMENT_SWITCH_SDK = "-sdk";
        String ARGUMENT_VALUE_CONFIGURATION_NAME_DEBUG = "Debug";
        String ARGUMENT_VALUE_CONFIGURATION_NAME_RELEASE = "Release";
        String ARGUMENT_VALUE_IPHONEOS_DEVICE_SDK = "iphoneos";
        String iOSSimulatorSdkPath = IosDeployUtil.getIosSdkPath();
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("clean");
        argList.add("install");
        argList.add("-configuration");
        argList.add(bDebugBuild ? "Debug" : "Release");
        argList.add("-sdk");
        argList.add(bEmulatorBuild ? iOSSimulatorSdkPath : "iphoneos");
        String ARGUMENT_SWITCH_DSTROOT = "DSTROOT";
        URL xcodebuildOutputFolderUrl = iosFiles.getDestinationRootOutputFolderUrl();
        String dstroot_path = xcodebuildOutputFolderUrl.getPath();
        argList.add("DSTROOT=" + dstroot_path);
        if (!bEmulatorBuild && null != (ARGUMENT_VALUE_CERTIFICATE = IosDeployUtil.getCertificate()) && !ARGUMENT_VALUE_CERTIFICATE.isEmpty()) {
            String BUILD_SETTING_CODE_SIGN_IDENTITY = "CODE_SIGN_IDENTITY";
            argList.add("CODE_SIGN_IDENTITY=" + ARGUMENT_VALUE_CERTIFICATE);
        }
        String minimumAppTargetVersion = IosDeployUtil.getMinimumIosVersion(profile);
        String BUILD_SETTING_IPHONEOS_DEPLOYMENT_TARGET = "IPHONEOS_DEPLOYMENT_TARGET";
        argList.add("IPHONEOS_DEPLOYMENT_TARGET=" + minimumAppTargetVersion);
        String deviceFamily = IosDeployUtil.getTargetFamily(profile);
        String BUILD_SETTING_TARGETED_DEVICE_FAMILY = "TARGETED_DEVICE_FAMILY";
        String targetFamily = "1,2";
        if (deviceFamily.compareTo("iPhone") == 0) {
            targetFamily = "1";
        } else if (deviceFamily.compareTo("iPad") == 0) {
            targetFamily = "2";
        }
        argList.add("TARGETED_DEVICE_FAMILY=" + targetFamily);
        String BUILD_SETTING_PRODUCT_NAME = "PRODUCT_NAME";
        argList.add("PRODUCT_NAME=" + iosFiles.getApplicationBundleNameNoExt());
        String BUILD_SETTING_ADD_SETTINGS_BUNDLE = "ADD_SETTINGS_BUNDLE";
        boolean existPreferences = PlistUtils.hasPreferences(iosFiles, logger);
        String hasSettingsBundle = existPreferences ? "YES" : "NO";
        argList.add("ADD_SETTINGS_BUNDLE=" + hasSettingsBundle);
        return argList;
    }

    public static void packageXcodeApplication(IosFileUtils iosFiles, McIosFrameworkProfile profile, Logger logger) throws DeployException {
        try {
            URL sourceAppUrl = iosFiles.getBuiltApplicationUrl();
            URL destinationFolderUrl = iosFiles.getDeviceApplicationDirUrl();
            FileUtils.deleteDirectory(destinationFolderUrl);
            FileUtils.createDirectory(destinationFolderUrl);
            List<String> cmdList = IosDeployer.getPackageApplicationCommandList(sourceAppUrl, iosFiles);
            String destPath = destinationFolderUrl.getPath();
            File workingDirectory = new File(destPath);
            FileUtils.logCommand(logger, destPath, cmdList);
            ExecResults execResult = ExecWrapper.runTool(cmdList, null, workingDirectory);
            List<String> xcodeErrorTokenList = IosDeployUtil.getXcodeErrorTokenList();
            List<String> xcodeWarningTokenList = IosDeployUtil.getXcodeWarningTokenList();
            ExecResultsLogger execResultsLogger = new ExecResultsLogger(logger, execResult, xcodeErrorTokenList, xcodeWarningTokenList);
            execResultsLogger.setLogCommandLine(false);
            execResultsLogger.logExecResults(Level.FINEST);
            if (!execResult.completedOK(xcodeErrorTokenList)) {
                throw new IOException(MobileResourceUtils.getMsg("ADF-MBL-02002", execResult.getCommandLineFullyQualifiedPath(), execResult.getErrorMessagesAsString(xcodeErrorTokenList)));
            }
            URL applicationIpaURL = iosFiles.getBuiltIpaFileUrl();
            String iTunesArtWorkFilePath = profile.getImageOptions().getStringValue("itunesArtwork");
            String absoluteItunesArtworkPath = FileUtils.getAbsoluteLocation(iosFiles.getWorkspace(), iTunesArtWorkFilePath);
            String iTunesArtworkDir = "art";
            URL finalArtworkURL = URLFactory.newDirURL((URL)destinationFolderUrl, (String)"art");
            IosDeployer.copyImageHelper(iosFiles.getWorkspace(), absoluteItunesArtworkPath, finalArtworkURL, ITUNES_ARTWORK, logger, "iTunesArtwork.png");
            iosFiles.addFilesToExistingZip(applicationIpaURL, finalArtworkURL, logger);
            logger.log(Level.FINEST, "Successfully packaged the Xcode Application.");
        }
        catch (IOException e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-00032");
            throw new DeployException(msg, (Throwable)e);
        }
        catch (InterruptedException e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-00032");
            throw new DeployException(msg, (Throwable)e);
        }
    }

    private static List<String> getPackageApplicationCommandList(URL sourceAppUrl, IosFileUtils iosFiles) throws DeployException {
        String xcrunToolPath = IosDeployUtil.getXcrunFullPath();
        List<String> arguments = IosDeployer.getXcrunPackageApplicationArguments(sourceAppUrl, iosFiles);
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(xcrunToolPath);
        cmdList.addAll(arguments);
        return cmdList;
    }

    private static List<String> getXcrunPackageApplicationArguments(URL sourceAppUrl, IosFileUtils iosFiles) {
        String ARGUMENT_SWITCH_SDK = "-sdk";
        String ARGUMENT_SWITCH_APP_V = "-v";
        String ARGUMENT_SWITCH_PACKAGE_O = "-o";
        String ARGUMENT_SWITCH_SIGN = "--sign";
        String ARGUMENT_SWITCH_EMBED = "--embed";
        String ARGUMENT_VALUE_IPHONEOS_DEVICE_SDK = "iphoneos";
        String ARGUMENT_VALUE_PACKAGE_APP = "PackageApplication";
        String ARGUMMENT_VALUE_APP_PATH = sourceAppUrl.getFile();
        String ARGUMENT_VALUE_APP_NAME = iosFiles.getBuiltIpaFileUrl().getPath();
        String ARGUMENT_VALUE_CERTIFICATE = IosDeployUtil.getCertificate();
        String ARGUMENT_VALUE_PROVISIOING_PROFILE = IosDeployUtil.getProvisioningProfile();
        ArrayList<String> argList = new ArrayList<String>();
        int slashLastIndex = ARGUMMENT_VALUE_APP_PATH.lastIndexOf(47);
        if (slashLastIndex == ARGUMMENT_VALUE_APP_PATH.length() - 1) {
            ARGUMMENT_VALUE_APP_PATH = ARGUMMENT_VALUE_APP_PATH.substring(0, slashLastIndex);
        }
        argList.add("-sdk");
        argList.add("iphoneos");
        argList.add("PackageApplication");
        argList.add("-v");
        argList.add(ARGUMMENT_VALUE_APP_PATH);
        argList.add("-o");
        argList.add(ARGUMENT_VALUE_APP_NAME);
        if (null != ARGUMENT_VALUE_CERTIFICATE && !ARGUMENT_VALUE_CERTIFICATE.isEmpty()) {
            argList.add("--sign");
            argList.add(ARGUMENT_VALUE_CERTIFICATE);
        }
        argList.add("--embed");
        argList.add(ARGUMENT_VALUE_PROVISIOING_PROFILE);
        return argList;
    }

    public static void updatePlistConfiguration(McIosFrameworkProfile profile, IosFileUtils iosFiles, Logger logger) throws DeployException {
        logger.log(Level.FINEST, "Starting update to Oracle_ADFmc_Container_Template-Info.plist");
        PlistUtils.updatePlistConfiguration(profile, iosFiles);
        logger.log(Level.FINEST, "Successfully completed updates to  Oracle_ADFmc_Container_Template-Info.plist");
    }

    public static void copyAdfSourceDirectory(IosFileUtils iosFiles, Logger logger) throws DeployException {
        logger.log(Level.FINEST, "Starting to copy ADF source directory.");
        URL temporaryXcodeFolderUrl = iosFiles.getDeploymentXcodeFolderUrl();
        try {
            URL applicationAdfFolderUrl = McAppUtils.getApplicationAdfFolderUrl(iosFiles.getWorkspace());
            FileUtils.copyDirectoryInclusive(applicationAdfFolderUrl, temporaryXcodeFolderUrl);
            logger.log(Level.FINEST, "Successfully completed copying ADF source directory.");
        }
        catch (IOException e) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02017"), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02017"), (Throwable)e);
        }
    }

    public static void deployIosStringResources(IosFileUtils iosFiles, Logger logger) throws DeployException {
        try {
            logger.log(Level.FINEST, "Starting transformation of XLIFF string resources to iOS representation.");
            ArrayList<XSLParameter> xslParamList = new ArrayList<XSLParameter>();
            URL xcodeStringsDirectoryUrl = iosFiles.getXcodeStringsDirectoryUrl();
            String XSL_PARAM_TARGET_DIR_PATH = "XSL_PARAM_TargetDirectoryPath";
            xslParamList.add(new XSLParameter(IOS_NAMESPACE, "XSL_PARAM_TargetDirectoryPath", xcodeStringsDirectoryUrl.toExternalForm()));
            String XSL_PARAM_FEATURE_XML_RELATIVE_PATH_IN_FAR = "XSL_PARAM_FeatureXmlRelativePathInFAR";
            xslParamList.add(new XSLParameter(IOS_NAMESPACE, "XSL_PARAM_FeatureXmlRelativePathInFAR", ADFMobileConstants.FEATURE_XML_FAR_PATH));
            String XSL_PARAM_APPLICATION_XLIFF_DIR_PATH = "XSL_PARAM_ApplicationXliffBasePath";
            URL adfMetaInfUrl = McAppUtils.getApplicationAdfMetaInfUrl(iosFiles.getWorkspace());
            xslParamList.add(new XSLParameter(IOS_NAMESPACE, "XSL_PARAM_ApplicationXliffBasePath", adfMetaInfUrl.toExternalForm()));
            IosDeployer.addFarUrlsToXslParamList(xslParamList, iosFiles);
            URL xslUrl = iosFiles.getXslStringResourceTransformFileUrl();
            URL adfmfAppXmlFileUrl = iosFiles.getAdfmfApplicationXmlFileUrl();
            XMLTransformer.transformXml(xslUrl, adfmfAppXmlFileUrl, xslParamList, logger);
            IosDeployer.copyIosStringResources(xcodeStringsDirectoryUrl, iosFiles.getSettingsBundleDirectoryUrl(), logger);
        }
        catch (TransformException e) {
            throw new DeployException((Throwable)e);
        }
        logger.log(Level.FINEST, "Completed transformation of XLIFF string resources to iOS representation.");
    }

    public static void copyIosStringResources(URL sourceDirUrl, URL targetDirUrl, Logger logger) throws DeployException {
        logger.log(Level.FINEST, "Start copying the content of directory '" + sourceDirUrl.toExternalForm() + "'");
        boolean sourceDirectoryExists = URLFileSystem.exists((URL)sourceDirUrl);
        boolean isDirectory = URLFileSystem.isDirectory((URL)sourceDirUrl);
        try {
            assert (sourceDirectoryExists && isDirectory);
            if (!sourceDirectoryExists || !isDirectory) {
                String msg = sourceDirectoryExists + " does not exist.";
                throw new IllegalArgumentException(msg);
            }
            if (!isDirectory) {
                String msg = sourceDirectoryExists + " is not a directory.";
                throw new IllegalArgumentException(msg);
            }
            FileUtils.copyDirectoryContent(sourceDirUrl, targetDirUrl);
            logger.log(Level.FINEST, "Completed copying the content of directory '" + sourceDirUrl.toExternalForm() + "'");
        }
        catch (IOException e) {
            throw new DeployException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new DeployException((Throwable)e);
        }
    }

    public static void validateProvisioningProfile() throws DeployException {
        String certificate = IosDeployUtil.getCertificate();
        String provisioningProfile = IosDeployUtil.getProvisioningProfile();
        if (!ModelUtil.hasLength((String)certificate) || !ModelUtil.hasLength((String)provisioningProfile)) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-00053");
            throw new DeployException(msg);
        }
    }

    private static List<URL> _getSimulatorSubFolderUrlsToDelete(IosFileUtils iosFiles) throws IOException {
        ArrayList<URL> deleteList = new ArrayList<URL>();
        deleteList.addAll(iosFiles.getSimulatorFileUtils().getDeployedSimulatorApplicationBundles());
        return deleteList;
    }

    private static void _cleanSimulatorApplicationDirectory(IosFileUtils iosFiles, Logger logger) throws IOException {
        List<URL> deleteList = IosDeployer._getSimulatorSubFolderUrlsToDelete(iosFiles);
        for (URL currUrl : deleteList) {
            if (!URLFileSystem.exists((URL)currUrl)) continue;
            logger.finest("The following simulator application directory exists and will be deleted in preparation to deploy a new application bundle. " + currUrl);
            FileUtils.deleteDirectory(currUrl);
            logger.finest(MobileResourceUtils.getMsg("ADF-MBL-20017", URLFileSystem.getPlatformPathName((URL)currUrl)));
        }
    }

    private static void _executeAppleScript(Logger logger, String appleScriptExpression) throws DeployException, IOException, InterruptedException {
        String OSA_SCRIPT_TOOL = "osascript";
        String OSA_SCRIPT_ARG_EXPRESSION_FLAG = "-e";
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("osascript");
        cmdList.add("-e");
        cmdList.add(appleScriptExpression);
        ExecResults execResults = ExecWrapper.runTool(cmdList);
        List<String> osaScriptErrorTokenList = IosDeployUtil.getOsaScriptErrorTokenList();
        ArrayList<String> osaScriptWarningTokenList = new ArrayList<String>();
        ExecResultsLogger execResultsLogger = new ExecResultsLogger(logger, execResults, osaScriptErrorTokenList, osaScriptWarningTokenList);
        execResultsLogger.logExecResults(Level.FINEST);
        if (!execResults.completedOK(osaScriptErrorTokenList)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02002", execResults.getCommandLineFullyQualifiedPath(), execResults.getErrorMessagesAsString(osaScriptErrorTokenList)));
        }
    }
}

