/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.exec.ExecResults;
import oracle.adfmf.common.util.exec.ExecResultsLogger;
import oracle.adfmf.common.util.exec.ExecWrapper;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.core.IosFileUtils;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.options.DeploymentOptions;
import oracle.adfmf.framework.dt.preferences.PlatformSDKsPrefs;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;

public class IosDeployUtil {
    private static final String VERSION_ARG = "-version";
    private static final String XCODEBUILD_TOOL_NAME = "xcodebuild";
    private static final String XCRUN_TOOL_PATH = "/usr/bin/xcrun";
    private static final String SDK_ARGUMENT = "-sdk";
    private static final List<String> s_defaultSimulatorVersionList = new ArrayList<String>();
    private static final String ORIENTATION_PORTRAIT = "UIInterfaceOrientationPortrait";
    private static final String ORIENTATION_UPSIDEDOWN = "UIInterfaceOrientationPortraitUpsideDown";
    private static final String ORIENTATION_LANDSCAPE_LEFT = "UIInterfaceOrientationLandscapeLeft";
    private static final String ORIENTATION_LANDSCAPE_RIGHT = "UIInterfaceOrientationLandscapeRight";
    private static final String XCODE_CMD_LINE_TOKEN_ERROR_DEFAULT = "Error:";
    private static final String XCODE_CMD_LINE_TOKEN_ERROR_BAD_RETURN_CODE = "returned 1 :";
    private static final String XCODE_CMD_LINE_TOKEN_WARNING = "Warning:";
    private static final String LN_CMD_LINE_TOKEN_ERROR = "ln: ";

    public static String getSimulatorTargetVersion(DeploymentOptions iosDeployOptions) {
        String configuredSimulatorVersion = iosDeployOptions.getSimulatorTargetVersion();
        String simulatorTargetVersion = null;
        simulatorTargetVersion = configuredSimulatorVersion.equals(iosDeployOptions.getSimulatorDefaultTargetVersionValue()) ? IosDeployUtil.getDefaultSimulatorVersion() : configuredSimulatorVersion;
        return simulatorTargetVersion;
    }

    private static String getDefaultSimulatorVersion() {
        List<String> simulatorVersionList = IosDeployUtil.invokeXcodebuildShowSdks(null);
        assert (null != simulatorVersionList && !simulatorVersionList.isEmpty());
        return simulatorVersionList.get(simulatorVersionList.size() - 1);
    }

    public static String getIosSdkPath() throws DeployException {
        Preferences preferences = Preferences.getPreferences();
        PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
        String iosSdkDir = platformPrefs.getiOSSdkDir();
        if (!ModelUtil.hasLength((String)iosSdkDir)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00000"));
        }
        String trimmedSdkDir = iosSdkDir.trim();
        if (!ModelUtil.hasLength((String)trimmedSdkDir)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00000"));
        }
        File tmpDir = new File(trimmedSdkDir);
        if (!tmpDir.exists()) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00001"));
        }
        return trimmedSdkDir;
    }

    public static String getIosSdkToolPath() throws DeployException {
        return IosDeployUtil.getIosSdkPath().concat("\\platform-tools");
    }

    public static String getIosSdkLibPath() throws DeployException {
        return IosDeployUtil.getIosSdkPath().concat("\\lib");
    }

    public static String getIosAutomaticallyAddToITunesPath() throws DeployException {
        Preferences preferences = Preferences.getPreferences();
        PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
        String automaticallyAddToiTunesDir = platformPrefs.getiOSAutomaticallyAddToiTunesDir();
        if (!ModelUtil.hasLength((String)automaticallyAddToiTunesDir)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-01004"));
        }
        String trimmedItunesDir = automaticallyAddToiTunesDir.trim();
        if (!ModelUtil.hasLength((String)trimmedItunesDir)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-01004"));
        }
        File tmpDir = new File(trimmedItunesDir);
        if (!tmpDir.exists()) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-01005"));
        }
        return trimmedItunesDir;
    }

    public static final McIosFrameworkProfile getMcIosFrameworkProfile(DeployShell deployShell) throws DeployException {
        return McIosFrameworkProfile.newMcIosFrameworkProfile(deployShell);
    }

    public static ExecResults invokeXcodebuildVersion(Logger logger, URL iosXcodebuildDirUrl) throws IOException, InterruptedException {
        logger.log(Level.FINEST, "About to invoke xcodebuild.");
        ArrayList<String> cmdList = new ArrayList<String>();
        if (null == iosXcodebuildDirUrl) {
            cmdList.add(XCODEBUILD_TOOL_NAME);
        } else {
            URL xcodebuildUrl = URLFactory.newURL((URL)iosXcodebuildDirUrl, (String)XCODEBUILD_TOOL_NAME);
            cmdList.add(xcodebuildUrl.getPath());
        }
        cmdList.add(VERSION_ARG);
        ExecResults execResults = ExecWrapper.runTool(cmdList);
        List<String> xcodeErrorTokenList = IosDeployUtil.getXcodeErrorTokenList();
        List<String> xcodeWarningTokenList = IosDeployUtil.getXcodeWarningTokenList();
        ExecResultsLogger execResultsLogger = new ExecResultsLogger(logger, execResults, xcodeErrorTokenList, xcodeWarningTokenList);
        execResultsLogger.logExecResults(Level.FINEST);
        if (!execResults.returnCodeOK()) {
            throw new IOException(MobileResourceUtils.getMsg("ADF-MBL-02002", execResults.getCommandLineFullyQualifiedPath(), execResults.getErrorMessagesAsString(xcodeErrorTokenList)));
        }
        return execResults;
    }

    public static String getXcodebuildPath() throws DeployException {
        Preferences preferences = Preferences.getPreferences();
        PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
        String iosXcodebuildDir = platformPrefs.getiOSxcodebuildDir();
        if (null == iosXcodebuildDir || !ModelUtil.hasLength((String)iosXcodebuildDir.trim())) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00033"));
        }
        String trimmedXcodebuildDir = iosXcodebuildDir.trim();
        File tmpDir = new File(trimmedXcodebuildDir);
        if (!tmpDir.exists() || !tmpDir.isDirectory()) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00034"));
        }
        return trimmedXcodebuildDir;
    }

    public static String getXcodebuildFullPath() throws DeployException {
        String binDirPath = IosDeployUtil.getXcodebuildPath();
        URL parentDirUrl = URLFactory.newDirURL((String)binDirPath);
        URL xcodebuildUrl = URLFactory.newURL((URL)parentDirUrl, (String)XCODEBUILD_TOOL_NAME);
        return xcodebuildUrl.getPath();
    }

    public static String getXcrunFullPath() throws DeployException {
        URL xcrunUrl = URLFactory.newURL((String)XCRUN_TOOL_PATH);
        return xcrunUrl.getPath();
    }

    public static boolean getDebugBuildFlag(McIosFrameworkProfile profile) {
        DeploymentOptions options = profile.getDeploymentOptions();
        return options.getDebugFlag();
    }

    public static String getProvisioningProfile() {
        Preferences preferences = Preferences.getPreferences();
        PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
        return platformPrefs.getiOSProvisioningProfile();
    }

    public static String getCertificate() {
        Preferences preferences = Preferences.getPreferences();
        PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
        return platformPrefs.getiOSCertificate();
    }

    public static String getBundleIdentifier(McIosFrameworkProfile profile) {
        DeploymentOptions options = profile.getDeploymentOptions();
        return options.getAppBundleId();
    }

    public static boolean getUsePrerenderedIcons(McIosFrameworkProfile profile) {
        DeploymentOptions options = profile.getDeploymentOptions();
        return options.getUsePrerenderedIcons();
    }

    public static ArrayList<String> getSupportedIphoneOrientation(McIosFrameworkProfile profile) {
        ArrayList<String> supportedOrientationList = new ArrayList<String>();
        DeploymentOptions options = profile.getDeploymentOptions();
        if (options.getIphoneOrientationSupportPortrait()) {
            supportedOrientationList.add(ORIENTATION_PORTRAIT);
        }
        if (options.getIphoneOrientationSupportPortraitUpsideDown()) {
            supportedOrientationList.add(ORIENTATION_UPSIDEDOWN);
        }
        if (options.getIphoneOrientationSupportLandscapeLeft()) {
            supportedOrientationList.add(ORIENTATION_LANDSCAPE_LEFT);
        }
        if (options.getIphoneOrientationSupportLandscapeRight()) {
            supportedOrientationList.add(ORIENTATION_LANDSCAPE_RIGHT);
        }
        return supportedOrientationList;
    }

    public static ArrayList<String> getSupportedIpadOrientation(McIosFrameworkProfile profile) {
        ArrayList<String> supportedOrientationList = new ArrayList<String>();
        DeploymentOptions options = profile.getDeploymentOptions();
        if (options.getIpadOrientationSupportPortrait()) {
            supportedOrientationList.add(ORIENTATION_PORTRAIT);
        }
        if (options.getIpadOrientationSupportPortraitUpsideDown()) {
            supportedOrientationList.add(ORIENTATION_UPSIDEDOWN);
        }
        if (options.getIpadOrientationSupportLandscapeLeft()) {
            supportedOrientationList.add(ORIENTATION_LANDSCAPE_LEFT);
        }
        if (options.getIpadOrientationSupportLandscapeRight()) {
            supportedOrientationList.add(ORIENTATION_LANDSCAPE_RIGHT);
        }
        return supportedOrientationList;
    }

    public static URL getApplicationResourceImageUrl(String iosResourceImageFileName) {
        Workspace oActiveWorkspace = Ide.getActiveWorkspace();
        URL resourcesFolderUrl = McAppUtils.getResourcesDir(oActiveWorkspace);
        URL iosResourceFolderUrl = URLFactory.newDirURL((URL)resourcesFolderUrl, (String)"ios");
        return URLFactory.newURL((URL)iosResourceFolderUrl, (String)iosResourceImageFileName);
    }

    public static String getMinimumIosVersion(McIosFrameworkProfile profile) {
        DeploymentOptions options = profile.getDeploymentOptions();
        return options.getDeployTargetVersion();
    }

    public static String getTargetFamily(McIosFrameworkProfile profile) {
        DeploymentOptions options = profile.getDeploymentOptions();
        return options.getTargetFamily();
    }

    public static List<String> invokeXcodebuildShowSdks(IndeterminateProgressMonitor progressMonitor) {
        List<String> listOfSdks = null;
        try {
            ArrayList<String> cmdList = new ArrayList<String>();
            String xcodebuildFullPath = IosDeployUtil.getXcodebuildFullPath();
            cmdList.add(xcodebuildFullPath);
            String showSdksArg = "-showsdks";
            cmdList.add("-showsdks");
            if (null != progressMonitor) {
                if (progressMonitor.isCanceled()) {
                    return s_defaultSimulatorVersionList;
                }
                progressMonitor.getPanel().setNote(MobileResourceUtils.getText("IOS_SIMULATOR_PROGRESS_DIALOG_NOTE_SDKS"));
            }
            ArrayList<String> simulatorVersionArrayList = new ArrayList<String>();
            ExecResults showSdksResults = ExecWrapper.runTool(cmdList);
            if (showSdksResults.returnCodeOK()) {
                if (null != progressMonitor) {
                    if (progressMonitor.isCanceled()) {
                        return s_defaultSimulatorVersionList;
                    }
                    progressMonitor.getPanel().setNote(MobileResourceUtils.getText("IOS_SIMULATOR_PROGRESS_DIALOG_NOTE_VERSIONS"));
                }
                String iPhoneSimulator = "iphonesimulator";
                for (String message : showSdksResults.getStandardOutput()) {
                    String productVersion;
                    String sdkVersion;
                    int lastIndex = message.lastIndexOf(SDK_ARGUMENT);
                    if (lastIndex == -1 || message.length() <= lastIndex + SDK_ARGUMENT.length() || null == (sdkVersion = message.substring(lastIndex + SDK_ARGUMENT.length())) || sdkVersion.trim().indexOf("iphonesimulator") != 0 || !ModelUtil.hasLength((String)(productVersion = IosDeployUtil.getProductVersion(sdkVersion.trim())))) continue;
                    simulatorVersionArrayList.add(productVersion);
                }
            }
            listOfSdks = simulatorVersionArrayList.isEmpty() ? s_defaultSimulatorVersionList : simulatorVersionArrayList;
        }
        catch (IOException e) {
            listOfSdks = s_defaultSimulatorVersionList;
        }
        catch (InterruptedException e) {
            listOfSdks = s_defaultSimulatorVersionList;
        }
        assert (null != listOfSdks && !listOfSdks.isEmpty());
        IosDeployUtil.sortVersionList(listOfSdks);
        return listOfSdks;
    }

    private static String getProductVersion(String sdkVersion) {
        String productVersionNumber = null;
        try {
            ArrayList<String> cmdList = new ArrayList<String>();
            String xcodebuildFullPath = IosDeployUtil.getXcodebuildFullPath();
            cmdList.add(xcodebuildFullPath);
            cmdList.add(VERSION_ARG);
            cmdList.add(SDK_ARGUMENT);
            cmdList.add(sdkVersion);
            ExecResults showSdksResults = ExecWrapper.runTool(cmdList);
            if (showSdksResults.returnCodeOK()) {
                String productVersion = "ProductVersion:";
                for (String message : showSdksResults.getStandardOutput()) {
                    int index = message.indexOf("ProductVersion:");
                    if (index == -1 || message.length() <= index + "ProductVersion:".length()) continue;
                    productVersionNumber = message.substring(index + "ProductVersion:".length()).trim();
                }
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return productVersionNumber;
    }

    public static List<String> getOsaScriptErrorTokenList() {
        String OSASCRIPT_CMD_LINE_ERROR_TOKEN_SEVERE = "SEVERE:";
        String OSASCRIPT_CMD_LINE_ERROR_TOKEN_SYNTAX_ERROR = "syntax error:";
        ArrayList<String> errorTokenList = new ArrayList<String>();
        errorTokenList.add("SEVERE:");
        errorTokenList.add("syntax error:");
        return errorTokenList;
    }

    public static List<String> getXcodeErrorTokenList() {
        ArrayList<String> errorTokenList = new ArrayList<String>();
        errorTokenList.add(XCODE_CMD_LINE_TOKEN_ERROR_DEFAULT);
        errorTokenList.add(XCODE_CMD_LINE_TOKEN_ERROR_BAD_RETURN_CODE);
        return errorTokenList;
    }

    public static List<String> getXcodeWarningTokenList() {
        ArrayList<String> warningTokenList = new ArrayList<String>();
        warningTokenList.add(XCODE_CMD_LINE_TOKEN_WARNING);
        return warningTokenList;
    }

    private static List<String> getLnErrorTokenList() {
        ArrayList<String> errorTokenList = new ArrayList<String>();
        errorTokenList.add(LN_CMD_LINE_TOKEN_ERROR);
        return errorTokenList;
    }

    public static void createGlobalPreferenceFileAlias(IosFileUtils iosFiles, Logger logger) throws DeployException {
        URL sourceFileUrl = iosFiles.getSimulatorFileUtils().getGlobalPreferenceFileUrl();
        URL aliasFileUrl = iosFiles.getSimulatorFileUtils().getApplicationGlobalPreferenceAliasFileUrl();
        String sourceFilePath = sourceFileUrl.getPath();
        String aliasFilePath = aliasFileUrl.getPath();
        URL aliasFileParentDirectoryUrl = iosFiles.getSimulatorFileUtils().getApplicationPreferencesDirectoryUrl();
        if (!FileUtils.createDirectory(aliasFileParentDirectoryUrl)) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01010", URLFileSystem.getPlatformPathName((URL)aliasFileParentDirectoryUrl));
            throw new DeployException(msg);
        }
        try {
            FileUtils.deleteFile(aliasFileUrl);
            IosDeployUtil._createSymbolicLinkAliasFile(sourceFilePath, aliasFilePath, logger);
        }
        catch (IOException e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01011", aliasFilePath, sourceFilePath);
            throw new DeployException(msg, (Throwable)e);
        }
        catch (InterruptedException e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01011", aliasFilePath, sourceFilePath);
            throw new DeployException(msg, (Throwable)e);
        }
    }

    private static void _createSymbolicLinkAliasFile(String sourceFilePath, String aliasFilePath, Logger logger) throws IOException, InterruptedException {
        ArrayList<String> cmdList = new ArrayList<String>();
        String COMMAND_LINK = "ln";
        String OPTION_CREATE_SYMBOLIC_LINK = "-s";
        String OPTION_VERBOSE = "-v";
        cmdList.add("ln");
        cmdList.add("-s");
        cmdList.add("-v");
        cmdList.add(sourceFilePath);
        cmdList.add(aliasFilePath);
        ExecResults execResults = ExecWrapper.runTool(cmdList);
        List<String> lnErrorTokenList = IosDeployUtil.getLnErrorTokenList();
        ExecResultsLogger execResultsLogger = new ExecResultsLogger(logger, execResults, lnErrorTokenList, null);
        execResultsLogger.logExecResults(Level.FINEST);
        if (!execResults.returnCodeOK()) {
            FileUtils.logCommand(logger, null, cmdList);
            throw new IOException(MobileResourceUtils.getMsg("ADF-MBL-02002", execResults.getCommandLineFullyQualifiedPath(), execResults.getMessageContentAsString()));
        }
    }

    private static void sortVersionList(List<String> versionList) {
        int VERSION1_LESS_THAN_VERSION2 = -1;
        boolean VERSION1_GREATER_THAN_VERSION2 = true;
        boolean VERSION1_EQUAL_VERSION2 = false;
        Collections.sort(versionList, new Comparator<String>(){

            @Override
            public int compare(String versionString1, String versionString2) {
                VersionNumber versionNumber1 = new VersionNumber(versionString1);
                VersionNumber versionNumber2 = new VersionNumber(versionString2);
                if (versionNumber1.isBefore(versionNumber2)) {
                    return -1;
                }
                if (versionNumber1.isAfter(versionNumber2)) {
                    return 1;
                }
                assert (versionNumber1.equals((Object)versionNumber2));
                return 0;
            }
        });
    }

    public static void nativeCopyDirectory(URL sourceDirUrl, URL targetDirUrl, Logger logger) throws DeployException {
        IosDeployUtil._nativeCopyDirectory(sourceDirUrl, targetDirUrl, logger, true);
    }

    public static void nativeCopyDirectoryInclusive(URL sourceDirUrl, URL targetDirUrl, Logger logger) throws DeployException {
        IosDeployUtil._nativeCopyDirectory(sourceDirUrl, targetDirUrl, logger, false);
    }

    public static void throwExceptionOnInvalidXcodeVersion(Logger logger, URL xcodebuildDirUrl) throws IOException, DeployException, InterruptedException {
        ExecResults versionResults = IosDeployUtil.invokeXcodebuildVersion(logger, xcodebuildDirUrl);
        boolean validXCode = false;
        String xcode = "Xcode";
        for (String message : versionResults.getStandardOutput()) {
            int lastIndex = message.lastIndexOf("Xcode");
            if (lastIndex == -1 || message.length() <= lastIndex + "Xcode".length()) continue;
            String xcodeVersion = message.substring(lastIndex + "Xcode".length()).trim();
            validXCode = IosDeployUtil._isXcodeVersionNot5(xcodeVersion);
            break;
        }
        if (!validXCode) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01017");
            throw new DeployException(msg);
        }
    }

    private static boolean _isXcodeVersionNot5(String xcodeVersion) {
        boolean isVersionLessThanXcode5 = false;
        if (ModelUtil.hasLength((String)xcodeVersion)) {
            String xcode5 = "5";
            VersionNumber versionNumber5 = new VersionNumber("5");
            VersionNumber thisVersionNumber = new VersionNumber(xcodeVersion);
            isVersionLessThanXcode5 = thisVersionNumber.isBefore(versionNumber5);
        }
        return isVersionLessThanXcode5;
    }

    private static void _nativeCopyDirectory(URL sourceDirUrl, URL targetDirUrl, Logger logger, boolean copyDirContentOnly) throws DeployException {
        String COPY_TOOL_NAME = "cp";
        String COPY_TOOL_ARG_RECURSIVE_COPY = "-R";
        String COPY_TOOL_ARG_PRESERVE_FILE_ATTRIBUTES = "-p";
        if (null == sourceDirUrl || null == targetDirUrl || null == logger || !URLFileSystem.isDirectory((URL)sourceDirUrl) || !URLFileSystem.isDirectoryPath((URL)targetDirUrl)) {
            throw new IllegalArgumentException();
        }
        try {
            if (!URLFileSystem.exists((URL)targetDirUrl)) {
                URLFileSystem.mkdirs((URL)targetDirUrl);
            }
            String sourceDirPath = URLFileSystem.getPlatformPathName((URL)sourceDirUrl);
            if (copyDirContentOnly) {
                sourceDirPath = sourceDirPath + "/";
            }
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("cp");
            cmdList.add("-R");
            cmdList.add("-p");
            cmdList.add(sourceDirPath);
            cmdList.add(URLFileSystem.getPlatformPathName((URL)targetDirUrl));
            ExecResults execResults = ExecWrapper.runTool(cmdList);
            ExecResultsLogger execResultsLogger = new ExecResultsLogger(logger, execResults, null, null);
            execResultsLogger.logExecResults(Level.FINEST);
            if (!execResults.returnCodeOK()) {
                FileUtils.logCommand(logger, null, cmdList);
                String errMsg = MobileResourceUtils.getMsg("ADF-MBL-02002", "cp", execResults.getMessageContentAsString());
                throw new DeployException(errMsg);
            }
        }
        catch (Exception e) {
            DeployException de = null;
            de = !(e instanceof DeployException) ? new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02002", "cp", e.getMessage())) : (DeployException)((Object)e);
            throw de;
        }
    }

    static {
        s_defaultSimulatorVersionList.add("5.0");
    }
}

