/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios;

import oracle.adfmf.common.util.McTechnologyUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.McProfile;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.options.DeploymentOptions;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.LinkedDirtyable;
import oracle.jdeveloper.deploy.PlatformDeployable;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.deploy.shell.JavaDeployment;
import oracle.jdevimpl.deploy.dt.jar.ArchiveEditor;

public final class McIosFrameworkProfile
extends McProfile
implements PlatformDeployable {
    public static final String ACTION_DEPLOY_FRAMEWORK_TO_IOS_DEVICE = "McProfile.deployFrameworkToIosDevice";
    public static final String ACTION_DEPLOY_FRAMEWORK_TO_IOS_SIMULATOR = "McProfile.deployFrameworkToIosSimulator";
    public static final String ACTION_DEPLOY_FRAMEWORK_TO_IOS_PACKAGE = "McProfile.packageFrameworkToIos";
    public static final Platform PLATFORM_IOS_FRAMEWORK = new Platform(PlatformType.JSE, "1.3", MobileResourceUtils.getText("IOS_FRAMEWORK_TARGET_PLATFORM_LABEL"), null);
    private Workspace _workspace;

    public McIosFrameworkProfile() {
    }

    public static McIosFrameworkProfile newMcIosFrameworkProfile(Workspace workspace) {
        if (null == workspace) {
            throw new IllegalArgumentException();
        }
        McIosFrameworkProfile iosProfile = new McIosFrameworkProfile();
        iosProfile._initialize(workspace);
        return iosProfile;
    }

    public static McIosFrameworkProfile newMcIosFrameworkProfile(Namespace namespace) {
        if (null == namespace) {
            throw new IllegalArgumentException();
        }
        ArchiveProfile archiveProfile = ArchiveEditor.getArchiveProfile((Namespace)namespace);
        if (null == archiveProfile || !(archiveProfile instanceof McIosFrameworkProfile)) {
            throw new IllegalArgumentException();
        }
        McIosFrameworkProfile iosProfile = (McIosFrameworkProfile)archiveProfile;
        assert (null != iosProfile._workspace);
        assert (null != iosProfile.getDataContainer());
        return iosProfile;
    }

    public static McIosFrameworkProfile newMcIosFrameworkProfile(DeployShell deployShell) throws DeployException {
        if (null == deployShell) {
            throw new IllegalArgumentException();
        }
        JavaDeployment d = JavaDeployment.getInstance((DeployShell)deployShell);
        Profile profile = d.getProfile();
        assert (profile != null);
        if (!(profile instanceof McIosFrameworkProfile)) {
            throw new DeployException("Deployment Profile is not a subclass of McIosFrameworkProfile.");
        }
        McIosFrameworkProfile iosProfile = (McIosFrameworkProfile)profile;
        assert (null != iosProfile._workspace);
        assert (null != iosProfile.getDataContainer());
        return iosProfile;
    }

    public static McIosFrameworkProfile newMcIosFrameworkProfile(HashStructure hash, Workspace workspace) {
        if (null == workspace || null == hash) {
            throw new IllegalArgumentException();
        }
        McIosFrameworkProfile iosProfile = new McIosFrameworkProfile(hash);
        iosProfile._initialize(workspace);
        return iosProfile;
    }

    public Platform getPlatform() {
        return PLATFORM_IOS_FRAMEWORK;
    }

    public void setPlatform(Platform oPlatform) {
        assert (false);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        this._verifyState();
        return this._equalsImpl((McIosFrameworkProfile)((Object)o));
    }

    public int hashCode() {
        this._verifyState();
        int PRIME = 31;
        int result = 17;
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._hash);
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._workspace);
        return result;
    }

    protected void initArchiveProfile(Class<? extends DataContainer> profileContainerClass) {
        super.initArchiveProfile(profileContainerClass);
    }

    public DeploymentOptions getDeploymentOptions() {
        this._verifyState();
        String optionsHashKey = DeploymentOptions.getHashStructureKeyName();
        HashStructure optionsHash = this._hash.getOrCreateHashStructure(optionsHashKey);
        DeploymentOptions deploymentOptions = DeploymentOptions.newDeploymentOptions(optionsHash, this._workspace);
        return deploymentOptions;
    }

    public void setDeploymentOptions(DeploymentOptions mcDeploymentOptions) {
        if (mcDeploymentOptions == null) {
            throw new IllegalArgumentException();
        }
        if (ModelUtil.areDifferent((Object)((Object)this.getDeploymentOptions()), (Object)((Object)mcDeploymentOptions))) {
            this.setDeploymentOptionsImpl(mcDeploymentOptions);
            this.markDirty(true);
        }
    }

    @Override
    protected Workspace getWorkspace() {
        return this._workspace;
    }

    private void setDeploymentOptionsImpl(DeploymentOptions mcDeploymentOptions) {
        this.unlinkEmbeddedDirtyable((LinkedDirtyable)this.getDeploymentOptions());
        this._hash.putHashStructure("iosDeploymentOptions", mcDeploymentOptions.getHashStructure());
        this.linkEmbeddedDirtyable((LinkedDirtyable)this.getDeploymentOptions());
    }

    public ImageOptions getImageOptions() {
        HashStructure imageHash = this._hash.getOrCreateHashStructure("mnfImageOptions");
        return new ImageOptions(imageHash);
    }

    public void setImageOptions(ImageOptions imageOptions) {
        if (imageOptions == null) {
            throw new IllegalArgumentException();
        }
        if (ModelUtil.areDifferent((Object)((Object)this.getImageOptions()), (Object)((Object)imageOptions))) {
            this.setImageOptionsImpl(imageOptions);
            this.markDirty(true);
        }
    }

    private void setImageOptionsImpl(ImageOptions imageOptions) {
        this.unlinkEmbeddedDirtyable((LinkedDirtyable)this.getImageOptions());
        this._hash.putHashStructure("mnfImageOptions", imageOptions.getHashStructure());
        this.linkEmbeddedDirtyable((LinkedDirtyable)this.getImageOptions());
    }

    public Object copyTo(Object target) {
        this._verifyState();
        if (null != target && !(target instanceof McIosFrameworkProfile)) {
            throw new IllegalArgumentException();
        }
        boolean copyIntoNewInstance = null == target;
        Object copy = super.copyTo(target);
        this._copyToImpl(copy, copyIntoNewInstance);
        return copy;
    }

    private void _copyToImpl(Object copy, boolean copyIntoNewInstance) {
        assert (copy instanceof McIosFrameworkProfile);
        McIosFrameworkProfile iosProfile = (McIosFrameworkProfile)((Object)copy);
        if (!copyIntoNewInstance) {
            iosProfile._workspace = null;
        }
        iosProfile._initialize(this._workspace);
    }

    private boolean _equalsImpl(McIosFrameworkProfile otherProfile) {
        return super.equals((Object)otherProfile) && ModelUtil.areEqual((Object)this._workspace, (Object)otherProfile._workspace);
    }

    private void _initialize(Workspace workspace) {
        if (null == workspace) {
            throw new IllegalArgumentException();
        }
        if (null != this._workspace) {
            throw new IllegalStateException();
        }
        this._workspace = workspace;
        Project project = McTechnologyUtils.findFirstUIProjectInWorkspace(this._workspace);
        this.setDataContainer((DataContainer)project);
    }

    private void _verifyState() {
        if (null == this._workspace || null == this.getDataContainer()) {
            throw new IllegalStateException();
        }
    }

    private McIosFrameworkProfile(HashStructure hashStructure) {
        super(hashStructure);
    }
}

