/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.features.ui.editor;

import java.util.ArrayList;
import oracle.adfdt.common.deploy.editor.AdfLibraryEditor;
import oracle.adfdt.common.deploy.editor.ConnectionsPanel;
import oracle.adfdt.common.deploy.editor.LibDepsPanel;
import oracle.adfdt.common.deploy.editor.ValidationPanel;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.features.FeatureArchiveProfile;
import oracle.ide.Context;
import oracle.ide.panels.Navigable;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdevimpl.deploy.dt.panels.FileGroupsNavigable;
import oracle.jdevimpl.deploy.dt.panels.FileGroupsPanel;
import oracle.jdevimpl.deploy.dt.panels.jar.ArchiveDepsPanel;
import oracle.jdevimpl.deploy.dt.panels.jar.ArchiveOptionsPanel;

public class FeatureArchiveEditor
extends AdfLibraryEditor {
    private static final String LIB_DEPENDENCIES_HELP_ID = "f1_adfmf_far_deployment_libdependencies_html";
    private static final String CONNECTIONS_HELP_ID = "f1_adfmf_far_deployment_connections_html";
    private static final String FAR_OPTIONS_HELP_ID = "f1_adfmf_far_deployment_options_html";

    public FeatureArchiveEditor(String title, FeatureArchiveProfile profile, Context context) {
        super(title, (ArchiveProfile)profile, context);
    }

    protected Navigable[] getNavigables() {
        Navigable[] archiveNavigableArray = super.getNavigables();
        ArrayList<Object> newNavs = new ArrayList<Object>();
        for (int i = 0; i < archiveNavigableArray.length; ++i) {
            Class currTraversableClass = archiveNavigableArray[i].getTraversableClass();
            if (currTraversableClass.equals(FileGroupsPanel.class) || currTraversableClass.equals(ArchiveDepsPanel.class) || currTraversableClass.equals(ArchiveOptionsPanel.class) || currTraversableClass.equals(ValidationPanel.class)) continue;
            newNavs.add(archiveNavigableArray[i]);
            if (currTraversableClass.equals(LibDepsPanel.class)) {
                archiveNavigableArray[i].setHelpID(LIB_DEPENDENCIES_HELP_ID);
                continue;
            }
            if (!currTraversableClass.equals(ConnectionsPanel.class)) continue;
            archiveNavigableArray[i].setHelpID(CONNECTIONS_HELP_ID);
        }
        Navigable farOptionsPanel = new Navigable(MobileResourceUtils.getText("FEATURE_ARCHIVE_EDITOR_FAR_OPTIONS_PANEL_LABEL"), ArchiveOptionsPanel.class);
        farOptionsPanel.setHelpID(FAR_OPTIONS_HELP_ID);
        newNavs.add(farOptionsPanel);
        newNavs.add(new FileGroupsNavigable());
        return newNavs.toArray(new Navigable[0]);
    }

    protected boolean isShowNewDeleteButtons() {
        return true;
    }

    protected boolean isShowUpDownButtons() {
        return true;
    }
}

