/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.features.deployers;

import java.util.HashMap;
import java.util.Map;
import oracle.adfmf.framework.dt.deploy.common.deployers.AbstractDeployerWrapper;
import oracle.adfmf.framework.dt.deploy.common.deployers.ProjectXmlValidatorDeployer;
import oracle.adfmf.framework.dt.deploy.features.deployers.FeatureArchiveDeployer;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.common.BatchDeployer;
import oracle.jdeveloper.deploy.common.BuildDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;
import oracle.jdeveloper.deploy.common.ModulePackager;
import oracle.jdeveloper.deploy.jar.JarDeployerFactory;
import oracle.jdevimpl.deploy.common.ProfileDependencyAnalyzer;

public class FeatureArchiveDeployerFactory
implements DeployerFactory {
    public static int getFeatureArchivePackagingId() {
        return FeatureDeployerSequenceId.FEATURE_ARCHIVE_BATCH_DEPLOYER_ID.getInt();
    }

    public Deployer newDeployer(int deploySequenceId, DeployShell deployShell) {
        if (!FeatureDeployerSequenceId.contains(deploySequenceId)) {
            return null;
        }
        FeatureDeployerSequenceId featureDeployId = FeatureDeployerSequenceId.fromInt(deploySequenceId);
        Object newDeployer = null;
        switch (featureDeployId) {
            case PACKAGING_SEQUENCE_ID: {
                newDeployer = this._createPackagingBatchDeployer(deployShell);
                break;
            }
            case DEPENDENCY_ANALYZER_ID: {
                newDeployer = new ProfileDependencyAnalyzer(deploySequenceId, deployShell);
                break;
            }
            case BUILD_DEPLOYER_ID: {
                newDeployer = new BuildDeployer(deploySequenceId, deployShell);
                break;
            }
            case MODULE_PACKAGER_ID: {
                newDeployer = new ModulePackager(deploySequenceId, deployShell);
                break;
            }
            case FEATURE_ARCHIVE_PACKAGING_ID: {
                newDeployer = new DynamicDeployer(FeatureDeployerSequenceId.PACKAGING_SEQUENCE_ID.getInt());
                break;
            }
            case FEATURE_ARCHIVE_XML_VALIDATOR_ID: {
                newDeployer = new ProjectXmlValidatorDeployer(deploySequenceId, true);
                break;
            }
            case DEFAULT_SEQUENCE_ID: {
                newDeployer = new FeatureArchiveDeployer(deploySequenceId, deployShell);
                break;
            }
            case ARCHIVE_DEPLOYER_ID: {
                newDeployer = new FeatureArchiveDeployer(deploySequenceId, deployShell);
                break;
            }
            case FEATURE_ARCHIVE_BATCH_DEPLOYER_ID: {
                newDeployer = this.createFeatureArchiveBatchDeployer();
            }
        }
        if (AbstractDeployerWrapper.isDeployerWrappable(newDeployer)) {
            newDeployer = AbstractDeployerWrapper.newInstance(deploySequenceId, deployShell.getLogger(), (Deployer)newDeployer);
        }
        return newDeployer;
    }

    private BatchDeployer createFeatureArchiveBatchDeployer() {
        return new BatchDeployer(FeatureDeployerSequenceId.FEATURE_ARCHIVE_BATCH_DEPLOYER_ID.getInt(), new int[]{FeatureDeployerSequenceId.FEATURE_ARCHIVE_XML_VALIDATOR_ID.getInt(), FeatureDeployerSequenceId.FEATURE_ARCHIVE_PACKAGING_ID.getInt()});
    }

    private Deployer _createPackagingBatchDeployer(DeployShell deployShell) {
        BatchDeployer newDeployer = null;
        newDeployer = deployShell.getFlag("ignoreDependencies") ? new BatchDeployer(FeatureDeployerSequenceId.PACKAGING_SEQUENCE_ID.getInt(), new int[]{FeatureDeployerSequenceId.BUILD_DEPLOYER_ID.getInt(), FeatureDeployerSequenceId.MODULE_PACKAGER_ID.getInt()}) : new BatchDeployer(FeatureDeployerSequenceId.PACKAGING_SEQUENCE_ID.getInt(), new int[]{FeatureDeployerSequenceId.DEPENDENCY_ANALYZER_ID.getInt(), FeatureDeployerSequenceId.BUILD_DEPLOYER_ID.getInt(), FeatureDeployerSequenceId.MODULE_PACKAGER_ID.getInt()});
        return newDeployer;
    }

    private static enum FeatureDeployerSequenceId {
        FEATURE_ARCHIVE_PACKAGING_ID("Deployment.FEATURE_ARCHIVE_PACKAGING_ID"),
        FEATURE_ARCHIVE_XML_VALIDATOR_ID("Deployment.FEATURE_ARCHIVE_XML_VALIDATOR_ID"),
        FEATURE_ARCHIVE_BATCH_DEPLOYER_ID("Deployment.FEATURE_ARCHIVE_BATCH_DEPLOYER_ID"),
        DEFAULT_SEQUENCE_ID(DeploymentConstants.DEFAULT_SEQUENCE),
        ARCHIVE_DEPLOYER_ID(DeploymentConstants.ARCHIVE_DEPLOYER),
        PACKAGING_SEQUENCE_ID(DeploymentConstants.PACKAGING_SEQUENCE),
        DEPENDENCY_ANALYZER_ID(JarDeployerFactory.DEPENDENCY_ANALYZER),
        BUILD_DEPLOYER_ID(DeploymentConstants.BUILD_DEPLOYER),
        MODULE_PACKAGER_ID(DeploymentConstants.MODULE_PACKAGER);

        private int _value;
        private static Map<Integer, FeatureDeployerSequenceId> s_featureDeployerMap;

        public static boolean contains(int deploySequenceId) {
            return s_featureDeployerMap.containsKey(deploySequenceId);
        }

        public static FeatureDeployerSequenceId fromInt(int deploySequenceId) {
            if (s_featureDeployerMap.containsKey(deploySequenceId)) {
                return s_featureDeployerMap.get(deploySequenceId);
            }
            throw new IllegalArgumentException();
        }

        public int getInt() {
            return this._value;
        }

        private FeatureDeployerSequenceId(String stringIdentifier) {
            this._value = DeploymentManager.getDeploymentSequenceId((String)stringIdentifier);
        }

        private FeatureDeployerSequenceId(int intIdentifier) {
            this._value = intIdentifier;
        }

        static {
            s_featureDeployerMap = new HashMap<Integer, FeatureDeployerSequenceId>();
            for (FeatureDeployerSequenceId id : FeatureDeployerSequenceId.values()) {
                s_featureDeployerMap.put(id._value, id);
            }
        }
    }
}

