/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.features.deployers;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import oracle.adf.model.adapter.AbstractDefinition;
import oracle.adf.model.adapter.AdapterException;
import oracle.adf.model.adapter.DTContext;
import oracle.adf.model.adapter.rest.RestURLDCDefinition;
import oracle.adfdt.common.deploy.impl.AdfLibraryDeployer;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.adfdt.model.ide.navigator.nodes.DataControlConfigurationNode;
import oracle.adfdt.model.ide.settings.ADFMSettings;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdtinternal.model.ide.adapter.AdapterDCHelper;
import oracle.adfinternal.model.adapter.url.URLDCDefinition;
import oracle.adfinternal.model.adapter.url.xml.XMLDCDef;
import oracle.adfinternal.model.adapter.webservice.WSDefinition;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.features.FeatureArchiveProfile;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.ide.Context;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.shell.JavaDeployment;

public class FeatureArchiveDeployer
extends AdfLibraryDeployer {
    public FeatureArchiveDeployer(int deploySequenceId, DeployShell deployShell) {
        super(deploySequenceId, deployShell);
    }

    public void deployImpl(int deploySequence, DeployShell deployShell) throws DeployException {
        this._deleteDeploymentJar(deployShell);
        List<JUDTAdapterDataControl> webServiceDataControlList = this._getWebServiceDataControls(deployShell);
        boolean addWebServiceBeanXmlFiles = false;
        if (!webServiceDataControlList.isEmpty()) {
            try {
                addWebServiceBeanXmlFiles = true;
                this._createJavaBeanDefinitionFiles(deployShell, webServiceDataControlList);
            }
            catch (Exception e) {
                throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02003"), (Throwable)e);
            }
        }
        super.deployImpl(deploySequence, deployShell);
        this._depMod.removeEntry("adflibREADME.txt");
        this._depMod.removeEntry("META-INF/adflibWEBINDEX.txt");
        if (addWebServiceBeanXmlFiles) {
            URL xmlFileBaseDirUrl = this._getWebServiceBeanDefinitionXmlBaseUrl(deployShell);
            URL[] dcUrls = new URL[]{xmlFileBaseDirUrl};
            this._depMod.addDirectoryTrees(dcUrls, null);
        }
        this._depMod.commit();
    }

    private List<JUDTAdapterDataControl> _getWebServiceDataControls(DeployShell deployShell) throws DeployException {
        ArrayList<JUDTAdapterDataControl> webServiceDCList = new ArrayList<JUDTAdapterDataControl>();
        String DCX_FILTER = ".dcx";
        Context context = deployShell.getContext();
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        try {
            QueryCriteria criteria = new QueryCriteria();
            criteria.put((Object)"file.extension", (Object)".dcx");
            List<XMLSourceNode> dcxFileList = DeployFileUtils.getProjectXmlSourceNodesFromIndex(workspace, project, criteria, deployShell.getLogger());
            if (dcxFileList.isEmpty()) {
                return Collections.unmodifiableList(webServiceDCList);
            }
            if (dcxFileList.size() > 1) {
                throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02005"));
            }
            Node dcxNode = (Node)dcxFileList.get(0);
            if (!(dcxNode instanceof DataControlConfigurationNode)) {
                return Collections.unmodifiableList(webServiceDCList);
            }
            DataControlConfigurationNode dcConfigNode = (DataControlConfigurationNode)dcxNode;
            List dataControlList = dcConfigNode.createConfiguration(context).getDataControls();
            if (null == dataControlList) {
                return Collections.unmodifiableList(webServiceDCList);
            }
            for (DataControl currDataControl : dataControlList) {
                AbstractDefinition abstractDef;
                JUDTAdapterDataControl currJudtDataControl;
                DataControlDefinition currNativeDC;
                if (!(currDataControl instanceof JUDTAdapterDataControl) || !((currNativeDC = (currJudtDataControl = (JUDTAdapterDataControl)currDataControl).getNativeDataControlDefinition()) instanceof AbstractDefinition) || !((abstractDef = (AbstractDefinition)currNativeDC) instanceof WSDefinition) && !(abstractDef instanceof XMLDCDef) && !(abstractDef instanceof URLDCDefinition) && !(abstractDef instanceof RestURLDCDefinition)) continue;
                webServiceDCList.add(currJudtDataControl);
            }
            return Collections.unmodifiableList(webServiceDCList);
        }
        catch (Exception e) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02006"), (Throwable)e);
        }
    }

    private void _createJavaBeanDefinitionFiles(DeployShell deployShell, List<JUDTAdapterDataControl> judtAdapterDataControlList) throws DeployException {
        Logger logger = deployShell.getLogger();
        URL deployProjectUrl = this._getDeploymentProjectUrl(deployShell);
        Project deployProject = null;
        try {
            deployProject = (Project)NodeFactory.findOrCreate(Project.class, (URL)deployProjectUrl);
        }
        catch (Exception e) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02004"), (Throwable)e);
        }
        if (null == deployProject) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02004"));
        }
        for (JUDTAdapterDataControl currCtrl : judtAdapterDataControlList) {
            DataControlDefinition currDataControlDef = currCtrl.getNativeDataControlDefinition();
            assert (currDataControlDef instanceof AbstractDefinition);
            AbstractDefinition currAbstractDefinition = (AbstractDefinition)currDataControlDef;
            currAbstractDefinition.setCachingMode(0);
            currCtrl.setDefProject((Object)deployProject);
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-22002", currAbstractDefinition.getName()));
            boolean dtContextUpdated = false;
            try {
                DTContext.getInstance().put((Object)"_DC_PROJECT_", (Object)deployShell.getContext().getProject());
                dtContextUpdated = true;
                StructureDefinition structDef = currAbstractDefinition.getStructure();
                AdapterDCHelper.addCreatableTypes((JUDTAdapterDataControl)currCtrl, (StructureDefinition)structDef);
            }
            catch (AdapterException adapterException) {
                logger.severe(MobileResourceUtils.getMsg("ADF-MBL-02011", currAbstractDefinition.getName()));
                throw adapterException;
            }
            finally {
                if (!dtContextUpdated) continue;
                DTContext.getInstance().remove((Object)"_DC_PROJECT_");
            }
        }
        try {
            SaveAllCommand cmd = new SaveAllCommand();
            SaveAllCommand.saveAll((boolean)true);
            deployProject.delete();
        }
        catch (Exception e) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02007"), (Throwable)e);
        }
    }

    private URL _getDeploymentOutputUrl(DeployShell deployShell) throws DeployException {
        return URLFileSystem.getParent((URL)this._getDeploymentJarUrl(deployShell));
    }

    private URL _getWebServiceBeanDefinitionXmlBaseUrl(DeployShell deployShell) throws DeployException {
        URL metadataDirectory = ADFMSettings.getMetadataDirectory((Project)deployShell.getContext().getProject());
        String dirName = URLFileSystem.getName((URL)metadataDirectory);
        return URLFactory.newURL((URL)this._getDeploymentOutputUrl(deployShell), (String)dirName);
    }

    private URL _getDeploymentProjectUrl(DeployShell deployShell) throws DeployException {
        String DEPLOY_PROJECT_NAME = "deployProject.jpr";
        return URLFactory.newURL((URL)this._getDeploymentOutputUrl(deployShell), (String)"deployProject.jpr");
    }

    private URL _getDeploymentJarUrl(DeployShell deployShell) throws DeployException {
        JavaDeployment d = JavaDeployment.getInstance((DeployShell)deployShell);
        Profile profile = d.getProfile();
        assert (profile != null);
        assert (profile instanceof FeatureArchiveProfile);
        if (!(profile instanceof FeatureArchiveProfile)) {
            throw new DeployException("Deployment Profile is not a FeatureArchiveProfile.");
        }
        FeatureArchiveProfile farProfile = (FeatureArchiveProfile)profile;
        return farProfile.getJarURL();
    }

    private void _deleteDeploymentJar(DeployShell deployShell) throws DeployException {
        URL jarUrl = this._getDeploymentJarUrl(deployShell);
        if (URLFileSystem.exists((URL)jarUrl)) {
            try {
                URLFileSystem.deleteEx((URL)jarUrl);
            }
            catch (IOException e) {
                throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02008", jarUrl.toExternalForm()), (Throwable)e);
            }
        }
    }
}

