/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.features;

import java.net.URL;
import java.util.ArrayList;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.customization.CustomizationUtils;
import oracle.adfmf.framework.dt.deploy.features.FeatureArchiveProfile;
import oracle.ide.Context;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.FileGroups;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.SelectionRules;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.jar.spi.ArchiveProfileFactory;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;

public class FeatureArchiveProfileFactory
extends ArchiveProfileFactory {
    private static final String _ALL_FILES_FILTER = "**";
    private static final String _FEATURES_FILE_GROUP_INTERNAL_NAME = "Features";
    private static final String _LIBRARIES_FILE_GROUP_INTERNAL_NAME = "Libraries";
    private static final String _CUSTOMIZATION_CLASS_EXT = ".class";

    public ArchiveProfile create(String name, DataContainer dataContainer, Context context) {
        ArchiveProfile profile = super.create(name, dataContainer, context);
        PackagingFileGroup featureFileGroup = this._createFeaturesFileGroup();
        LibraryFileGroup libraryFileGroup = this._createLibraryFileGroup(context);
        FileGroups newFileGroups = new FileGroups();
        FileGroups currFileGroups = profile.getFileGroups();
        if (null != currFileGroups) {
            FileGroup[] currGroupArray = currFileGroups.getGroups();
            for (int i = 0; i < currGroupArray.length; ++i) {
                newFileGroups.addFileGroup(currGroupArray[i]);
            }
        }
        newFileGroups.addFileGroup((FileGroup)featureFileGroup);
        newFileGroups.addFileGroup((FileGroup)libraryFileGroup);
        profile.setFileGroups(newFileGroups);
        return profile;
    }

    protected ArchiveProfile newArchiveProfile() {
        return new FeatureArchiveProfile();
    }

    private LibraryFileGroup _createLibraryFileGroup(Context context) {
        String librariesFileGroupDisplayName = MobileResourceUtils.getText("ADF_MOBILE_FEATURE_LIBRARIES_FILE_GROUP_DISPLAY_NAME");
        LibraryFileGroup libraryFileGroup = new LibraryFileGroup(librariesFileGroupDisplayName, _LIBRARIES_FILE_GROUP_INTERNAL_NAME);
        libraryFileGroup.setTargetWithinJar("lib");
        SelectionRules filters = this._createFilters(context);
        libraryFileGroup.setFilters(filters);
        return libraryFileGroup;
    }

    private PackagingFileGroup _createFeaturesFileGroup() {
        Contributor publicHtmlContributor = new Contributor(5, null);
        SelectionRules publicHtmlFilterSelectionRules = new SelectionRules();
        publicHtmlFilterSelectionRules.addInclude(_ALL_FILES_FILTER, true);
        String featuresFileGroupDisplayName = MobileResourceUtils.getText("ADF_MOBILE_FEATURE_FEATURES_FILE_GROUP_DISPLAY_NAME");
        PackagingFileGroup featureFileGroup = new PackagingFileGroup(featuresFileGroupDisplayName, _FEATURES_FILE_GROUP_INTERNAL_NAME);
        featureFileGroup.setTargetWithinJar("public_html");
        featureFileGroup.addContributor(publicHtmlContributor);
        featureFileGroup.setFilters(publicHtmlFilterSelectionRules);
        return featureFileGroup;
    }

    private SelectionRules _createFilters(Context context) {
        SelectionRules filters = new SelectionRules();
        Workspace workspace = context.getWorkspace();
        filters.addInclude(_ALL_FILES_FILTER, true);
        if (CustomizationUtils.isCustomizationsEnabled(workspace)) {
            this._excludeCC(workspace, filters);
        }
        return filters;
    }

    private void _excludeCC(Workspace workspace, SelectionRules filters) {
        ArrayList<String> ccLibList = new ArrayList<String>();
        for (Project project : workspace.projects()) {
            JLibrary[] jLibArray;
            JProjectLibraries projectLibs = JProjectLibraries.getInstance((PropertyStorage)project);
            block1: for (JLibrary jLib : jLibArray = projectLibs.getLibraries()) {
                URL[] jarUrls;
                URLPath path = jLib.getClassPath();
                for (URL jarUrl : jarUrls = path.getEntries()) {
                    Object libId;
                    URL fileUrl = JarUtil.getJarFileURL((URL)jarUrl);
                    if (!this._isCCJar(workspace, fileUrl) || (libId = jLib.getID()) == null || !(libId instanceof String)) continue;
                    ccLibList.add((String)libId);
                    continue block1;
                }
            }
        }
        for (String ccLib : ccLibList) {
            filters.addExclude(ccLib, false);
        }
    }

    private boolean _isCCJar(Workspace workspace, URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        if (!".jar".equalsIgnoreCase(suffix)) {
            return false;
        }
        ArrayList<String> custClassList = CustomizationUtils.getCustClassNames(workspace);
        String custClassPath = null;
        for (String custClass : custClassList) {
            custClassPath = custClass.replace(".", "/");
            URL custClassUrl = URLFactory.newJarURL((URL)url, (String)(custClassPath = custClassPath + _CUSTOMIZATION_CLASS_EXT));
            if (!URLFileSystem.canRead((URL)custClassUrl)) continue;
            return true;
        }
        return false;
    }
}

