/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.editor.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import oracle.adfmf.common.McTwoColumnPanel;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversalException;
import oracle.javatools.util.ModelUtil;

public class ImageOptionsPanelHelper
extends McTwoColumnPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected static final int IMAGE_BROWSE_BUTTON_COLUMN_OFFSET = 2;
    protected static final int TOP_INDENT_PIXEL_COUNT = 5;
    protected static final int LEFT_INDENT_PIXEL_COUNT = 5;
    protected final Map<String, String> m_supportedImageTypeMap = new HashMap<String, String>();
    private final URL m_applicationRootUrl;
    private final Map<JButton, JTextField> m_buttonToTextMap = new HashMap<JButton, JTextField>();
    private final Map<JTextField, String> m_textToLabelMap = new HashMap<JTextField, String>();
    protected final Map<JTextField, String> m_textToOptionKeyMap = new HashMap<JTextField, String>();

    public ImageOptionsPanelHelper(String[] supportedImageFileTypeArray) {
        for (int i = 0; i < supportedImageFileTypeArray.length; ++i) {
            this.m_supportedImageTypeMap.put(supportedImageFileTypeArray[i], "");
        }
        this.m_applicationRootUrl = McAppUtils.getAppRootURL(null);
    }

    protected void registerImageProperties(JTextField imageEditControl, JButton imageBrowseButton, String imageOptionKeyName, String dialogTitle) {
        this.m_buttonToTextMap.put(imageBrowseButton, imageEditControl);
        this.m_textToLabelMap.put(imageEditControl, dialogTitle);
        this.m_textToOptionKeyMap.put(imageEditControl, imageOptionKeyName);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (this.m_buttonToTextMap.containsKey(source)) {
            JTextField textField = this.m_buttonToTextMap.get(source);
            String title = this.m_textToLabelMap.get(textField);
            this.setImageEditControl(textField, title);
        }
    }

    public void initializeImageControlsData(ImageOptions imageOptions) {
        for (Map.Entry<JTextField, String> currEntry : this.m_textToOptionKeyMap.entrySet()) {
            JTextField currTextField = currEntry.getKey();
            String currOptionKey = currEntry.getValue();
            currTextField.setText(imageOptions.getStringValue(currOptionKey));
        }
    }

    public void getImageControlsData(ImageOptions imageOptions) throws TraversalException {
        for (Map.Entry<JTextField, String> currEntry : this.m_textToOptionKeyMap.entrySet()) {
            JTextField currTextField = currEntry.getKey();
            String currOptionKey = currEntry.getValue();
            String currImagePath = currTextField.getText();
            if (null == currImagePath) continue;
            if (!currImagePath.isEmpty()) {
                this.checkImageValidity(currImagePath);
            }
            imageOptions.setStringValue(currOptionKey, currImagePath);
        }
    }

    private String selectAppImage(String sDlgTitle, String sDefaultSelectedPath, String sFilterStr) {
        String platformPath;
        URL oSelectedURL;
        String sRetSelectedURLPath = sDefaultSelectedPath;
        URL oInitialURL = null;
        if (sDefaultSelectedPath != null && sDefaultSelectedPath.length() > 0) {
            String absolutePath = FileUtils.getAbsoluteLocation(null, sDefaultSelectedPath);
            oInitialURL = URLFactory.newFileURL((String)absolutePath);
        }
        DefaultURLFilter oURLFilter = new DefaultURLFilter(sFilterStr, FileUtils.buildStringArrayFromMapKeys(this.m_supportedImageTypeMap));
        URLChooser oURLChooser = DialogUtil.newURLChooser(null, (URL)oInitialURL);
        oURLChooser.setRoots(new URL[]{this.m_applicationRootUrl});
        oURLChooser.setSelectionScope(0);
        oURLChooser.setSelectionMode(0);
        oURLChooser.setShowJarsAsDirs(false);
        oURLChooser.clearChooseableURLFilters();
        oURLChooser.setURLFilter((URLFilter)oURLFilter);
        oURLChooser.removeShortcutButtons();
        int iStatus = oURLChooser.showOpenDialog((Component)((Object)this), sDlgTitle);
        if (iStatus == 0 && (oSelectedURL = oURLChooser.getSelectedURL()) != null && this.verifyImageWithinApplicationDir(platformPath = URLFileSystem.getPlatformPathName((URL)oSelectedURL))) {
            sRetSelectedURLPath = FileUtils.getProjectRelativeFilePath(URLFactory.newFileURL((String)platformPath), McAppUtils.getAppRootURL(null));
        }
        return sRetSelectedURLPath;
    }

    private void verifyImageTypeSupported(String imagePath) throws TraversalException {
        String fileExtension = FileUtils.getFileExtension(imagePath);
        if (!ModelUtil.hasLength((String)fileExtension) || !this.m_supportedImageTypeMap.containsKey(fileExtension)) {
            String supportedTypes = FileUtils.buildCommaDelimitedStringFromMapKeys(this.m_supportedImageTypeMap);
            String absolutePath = FileUtils.getAbsoluteLocation(null, imagePath);
            URL imageUrl = URLFactory.newFileURL((String)absolutePath);
            String fileName = URLFileSystem.getFileName((URL)imageUrl);
            String errorMessage = MobileResourceUtils.getMsg("ADF-MBL-00009", fileName, supportedTypes);
            String dialogTitle = MobileResourceUtils.getText("ERR_INVALID_IMAGE_TYPE_DLG_TITLE");
            JOptionPane.showMessageDialog((Component)((Object)this), errorMessage, dialogTitle, 0);
            throw new TraversalException(null);
        }
    }

    private boolean verifyImageWithinApplicationDir(String imagePath) {
        String applicationRootPath = URLFileSystem.getPlatformPathName((URL)this.m_applicationRootUrl);
        if (!imagePath.startsWith(applicationRootPath)) {
            String message = MobileResourceUtils.getMsg("ADF-MBL-00008", applicationRootPath);
            String dlgTitle = MobileResourceUtils.getText("ERR_IMAGE_NOT_IN_APP_DIR_DLG_TITLE");
            JOptionPane.showMessageDialog((Component)((Object)this), message, dlgTitle, 0);
            return false;
        }
        return true;
    }

    private void verifyImagePathValid(String imagePath) throws TraversalException {
        String absolutePath = FileUtils.getAbsoluteLocation(null, imagePath);
        if (!FileUtils.doesFileExist(absolutePath)) {
            String message = MobileResourceUtils.getMsg("ADF-MBL-00007", this.getImagePath(absolutePath));
            String dlgTitle = MobileResourceUtils.getText("ERR_INVALID_IMAGE_PATH_DLG_TITLE");
            JOptionPane.showMessageDialog((Component)((Object)this), message, dlgTitle, 0);
            throw new TraversalException(null);
        }
    }

    private String getImagePath(String iconPath) {
        if (ModelUtil.hasLength((String)iconPath)) {
            URL urlIconPath = URLFactory.newURL((String)iconPath);
            return URLFileSystem.getPlatformPathName((URL)urlIconPath);
        }
        return "";
    }

    protected void checkImageValidity(String imagePath) throws TraversalException {
        this.verifyImagePathValid(imagePath);
        this.verifyImageTypeSupported(imagePath);
    }

    protected void setImageEditControl(JTextField imageTextField, String dialogTitle) {
        String selectedurlPath = this.selectAppImage(dialogTitle, imageTextField.getText(), MobileResourceUtils.getText("IMAGE_OPTIONS_FILTER_DESCRIPTION"));
        if (selectedurlPath != null) {
            imageTextField.setText(selectedurlPath);
        }
    }

    protected void setOptionValue(ImageOptions imageOptions, String imageKey, JTextField control) throws TraversalException {
        String imagePath;
        if (null != control && null != (imagePath = control.getText())) {
            if (!imagePath.isEmpty()) {
                this.checkImageValidity(imagePath);
            }
            imageOptions.setStringValue(imageKey, imagePath);
        }
    }

    protected static enum ImageNumber {
        IMAGE_1(1),
        IMAGE_2(2),
        IMAGE_3(3),
        IMAGE_4(4);

        private Integer m_imageNum;
        private static final Map<Integer, ImageNumber> m_sNumToEnumMap;

        private ImageNumber(int imageNum) {
            this.m_imageNum = imageNum;
        }

        public static ImageNumber fromInt(int i) {
            if (!m_sNumToEnumMap.containsKey(i)) {
                throw new IllegalArgumentException();
            }
            return m_sNumToEnumMap.get(i);
        }

        static {
            m_sNumToEnumMap = new HashMap<Integer, ImageNumber>();
            for (ImageNumber attrib : ImageNumber.values()) {
                m_sNumToEnumMap.put(attrib.m_imageNum, attrib);
            }
        }
    }
}

