/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.editor.panels;

import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.editor.panels.ImageOptionsPanelHelper;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Borders;
import oracle.javatools.util.ModelUtil;

public class ImageOptionsChooserPanel
extends ImageOptionsPanelHelper {
    private static final long serialVersionUID = 1L;
    private ControlGroupPanel _imagePanel;
    private final String _deviceTypeName;
    private final String _translatedDeviceName;
    private JTextField _applicationImageTextField;
    private JTextField _portraitSplashScreenTextField;
    private JTextField _landscapeSplashScreenTextField;
    private final String _browseDialogTitlePrefix = MobileResourceUtils.getText("CHOOSE_APPL_ICON");

    public ImageOptionsChooserPanel(String deviceTypeName, String translatedName, String[] supportedImageFileTypeArray) {
        super(supportedImageFileTypeArray);
        this._deviceTypeName = deviceTypeName;
        this._translatedDeviceName = translatedName;
        this.createControls();
    }

    public final String getDeviceTypeName() {
        return this._deviceTypeName;
    }

    public final String getTranslatedDeviceName() {
        return this._translatedDeviceName;
    }

    public ControlGroupPanel getPanel() {
        return this._imagePanel;
    }

    public void initializeImageControlsData(HashStructure imageOptionsHash) {
        for (Map.Entry currEntry : this.m_textToOptionKeyMap.entrySet()) {
            JTextField currTextField = (JTextField)currEntry.getKey();
            String currOptionKey = (String)currEntry.getValue();
            currTextField.setText(imageOptionsHash.getString(currOptionKey));
        }
    }

    public void getImageControlsData(HashStructure imageOptionsHash) throws TraversalException {
        for (Map.Entry currEntry : this.m_textToOptionKeyMap.entrySet()) {
            JTextField currTextField = (JTextField)currEntry.getKey();
            String currOptionKey = (String)currEntry.getValue();
            String currImagePath = currTextField.getText();
            if (null == currImagePath) continue;
            if (!currImagePath.isEmpty()) {
                this.checkImageValidity(currImagePath);
            }
            imageOptionsHash.putString(currOptionKey, currImagePath);
        }
    }

    public boolean validateImages() {
        boolean isValid = true;
        for (Map.Entry currEntry : this.m_textToOptionKeyMap.entrySet()) {
            JTextField currTextField = (JTextField)currEntry.getKey();
            String currImagePath = currTextField.getText();
            if (null != currImagePath && !currImagePath.isEmpty()) {
                if (this._validateImage(currImagePath)) continue;
                isValid = false;
                break;
            }
            isValid = false;
            break;
        }
        return isValid;
    }

    public void setJListParent(JList deviceTypeJList) {
        this.addDocumentListenerToTextField(this._applicationImageTextField, deviceTypeJList);
        this.addDocumentListenerToTextField(this._portraitSplashScreenTextField, deviceTypeJList);
        this.addDocumentListenerToTextField(this._landscapeSplashScreenTextField, deviceTypeJList);
    }

    protected String getApplicationImageLabel() {
        return MobileResourceUtils.getText("IMAGE_OPTIONS_APPLICATION_ICON");
    }

    protected String getPortraitSplashScreenImageLabel() {
        return MobileResourceUtils.getText("IMAGE_OPTIONS_SPLASHSCREEN_PORTRAIT");
    }

    protected String getLandscapeSplashScreenImageLabel() {
        return MobileResourceUtils.getText("IMAGE_OPTIONS_SPLASHSCREEN_LANDSCAPE");
    }

    protected String getImagePanelSeparatorLabel() {
        return MobileResourceUtils.getText("IMAGE_OPTIONS_CHOOSE_APP_ICONS");
    }

    protected String getDialogTitle(String imageLabel) {
        String DLG_TITLE_IMAGE_FORMAT = "%s%s";
        return String.format("%s%s", this._browseDialogTitlePrefix, DeployFileUtils.stripMnemonicAndColonFromLabel(imageLabel));
    }

    private void createControls() {
        boolean gridX = false;
        int gridY = 0;
        this._imagePanel = new ControlGroupPanel();
        this._applicationImageTextField = this.createImageControls(this.getApplicationImageLabel(), "appIconPath", 0, gridY++);
        this._portraitSplashScreenTextField = this.createImageControls(this.getPortraitSplashScreenImageLabel(), "portraitSplashScreenPath", 0, gridY++);
        this._landscapeSplashScreenTextField = this.createImageControls(this.getLandscapeSplashScreenImageLabel(), "landscapeSplashScreenPath", 0, gridY++);
    }

    private JTextField createImageControls(String imageLabel, String imageOptionKeyName, int gridX, int gridY) {
        JTextField imageEditControl = this._imagePanel.addLabeledTextField(imageLabel, 0, gridX, gridY, false, false, false);
        JButton imageBrowseButton = this._imagePanel.addButton(gridX + 2, gridY, OracleIcons.getIcon((String)"lov.png"));
        this.registerImageProperties(imageEditControl, imageBrowseButton, imageOptionKeyName, this.getDialogTitle(imageLabel));
        imageBrowseButton.addActionListener(this);
        return imageEditControl;
    }

    private boolean _validateImage(String imagePath) {
        String absolutePath = FileUtils.getAbsoluteLocation(null, imagePath);
        String fileExtension = FileUtils.getFileExtension(imagePath);
        return FileUtils.doesFileExist(absolutePath) && ModelUtil.hasLength((String)fileExtension) && this.m_supportedImageTypeMap.containsKey(fileExtension);
    }

    private void addDocumentListenerToTextField(JTextField textField, JList deviceTypeJList) {
        textField.getDocument().addDocumentListener(new ImagePathDocumentListener(textField, deviceTypeJList));
    }

    private final class ImagePathDocumentListener
    implements DocumentListener {
        private final JList _parentJList;
        private final JTextField _thisTextField;

        public ImagePathDocumentListener(JTextField field, JList parentJList) {
            this._thisTextField = field;
            this._parentJList = parentJList;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this._validateApplicationArchiveName();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this._validateApplicationArchiveName();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this._validateApplicationArchiveName();
        }

        private void _validateApplicationArchiveName() {
            String currImagePath = this._thisTextField.getText();
            if (null != currImagePath && !currImagePath.isEmpty() && ImageOptionsChooserPanel.this._validateImage(currImagePath)) {
                Borders.restoreBorder((JComponent)this._thisTextField);
            } else {
                Borders.attachErrorBorder((JComponent)this._thisTextField);
            }
            this._parentJList.repaint();
        }
    }
}

