/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.editor.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.editor.McArchiveEditor;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.adfmf.framework.dt.deploy.editor.panels.ImageOptionsChooserPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;

public class DeviceImageOptionsPanel
extends ControlGroupPanel {
    private static final long serialVersionUID = 1L;
    private transient BufferedImage _portraitImage = null;
    private transient BufferedImage _errorImageOverlay = null;
    private transient BufferedImage _errorImage = null;
    private static final String _portraitPngPath = "oracle/adfmf/amx/dt/editor/icons/Portrait.png";
    private static final String _errorOverlayPngPath = "oracle/adfmf/framework/dt/deploy/editor/panels/error_overlay.png";
    private final URL _portraitURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("oracle/adfmf/amx/dt/editor/icons/Portrait.png");
    private final URL _errorOverlayURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("oracle/adfmf/framework/dt/deploy/editor/panels/error_overlay.png");
    private final ImageIcon _validPathsImage = new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("oracle/adfmf/amx/dt/editor/icons/Portrait.png"));
    private static final int DEVICE_TYPE_LIST_WIDTH = 180;
    private static final int DEVICE_TYPE_LIST_HEIGHT = 33;
    private String _panelHintText = null;
    private JList _deviceTypeJList = null;
    protected final Map<String, ImageOptionsChooserPanel> _imageOptionsChooserPanelMap = new HashMap<String, ImageOptionsChooserPanel>();

    public void onEntry(TraversableContext context) {
        super.onEntry(context);
        ImageOptions imageOptions = McArchiveEditor.getImageOptions((Namespace)context);
        for (Map.Entry<String, ImageOptionsChooserPanel> currEntry : this._imageOptionsChooserPanelMap.entrySet()) {
            ImageOptionsChooserPanel currDeviceType = currEntry.getValue();
            HashStructure imageOptionsHash = DeployFileUtils.getDeviceTypeHash(imageOptions, currDeviceType.getDeviceTypeName());
            currDeviceType.initializeImageControlsData(imageOptionsHash);
            currDeviceType.onEntry(context);
        }
    }

    public void onExit(TraversableContext context) throws TraversalException {
        super.onExit(context);
        ImageOptions imageOptions = McArchiveEditor.getImageOptions((Namespace)context);
        for (Map.Entry<String, ImageOptionsChooserPanel> currEntry : this._imageOptionsChooserPanelMap.entrySet()) {
            ImageOptionsChooserPanel currDeviceType = currEntry.getValue();
            HashStructure imageOptionsHash = DeployFileUtils.getDeviceTypeHash(imageOptions, currDeviceType.getDeviceTypeName());
            currDeviceType.getImageControlsData(imageOptionsHash);
        }
        context.findAndReplace("mc-app-images", (Object)imageOptions);
    }

    protected void createControls() {
        ControlGroupPanel parentPanel = new ControlGroupPanel();
        boolean gridX = false;
        int gridY = 0;
        this.addPlatformListPanel(parentPanel, 0, gridY++);
        this.addImageOptionsChooserPanel(parentPanel, 0, gridY++);
        boolean containerGridX = false;
        int containerGridY = 0;
        int HORIZONTAL_INDENT_SDK_PANEL = 6;
        this.add((Component)((Object)parentPanel), this.gbc(0, containerGridY++, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 6, 0, 0)));
        this.add(Box.createGlue(), this.gbc(0, containerGridY, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0)));
    }

    protected void createPlatformDisplayTypes() {
    }

    protected void addPlatformListPanel(ControlGroupPanel parentPanel, int parentGridX, int parentGridY) {
        boolean gridX = false;
        boolean gridY = false;
        Object[] listElementArray = new ImageOptionsChooserPanel[this._imageOptionsChooserPanelMap.size()];
        int count = 0;
        for (Map.Entry<String, ImageOptionsChooserPanel> currEntry : this._imageOptionsChooserPanelMap.entrySet()) {
            listElementArray[count++] = currEntry.getValue();
        }
        ControlGroupPanel supportedPlatformPanel = new ControlGroupPanel();
        supportedPlatformPanel.setWeightX(1.0);
        supportedPlatformPanel.setBottomIndentPixelSize(3);
        this._deviceTypeJList = supportedPlatformPanel.addScrollableLabeledObjectJList(0, 0, 1, MobileResourceUtils.getText("IMAGE_OPTIONS_PLATFORM_TYPES"), listElementArray, 180, 33, Color.BLACK, 0);
        FileListCellRenderer renderer = new FileListCellRenderer();
        this._deviceTypeJList.setCellRenderer(renderer);
        this._deviceTypeJList.addListSelectionListener(new DeviceSelectionListener());
        this._deviceTypeJList.setSelectedIndex(0);
        parentPanel.addPanel(supportedPlatformPanel, parentGridX, parentGridY);
    }

    protected void addImageOptionsChooserPanel(ControlGroupPanel parentPanel, int parentGridX, int parentGridY) {
        for (Map.Entry<String, ImageOptionsChooserPanel> currEntry : this._imageOptionsChooserPanelMap.entrySet()) {
            ImageOptionsChooserPanel currentPanel = currEntry.getValue();
            currentPanel.setJListParent(this._deviceTypeJList);
            currEntry.setValue(currentPanel);
            parentPanel.addPanel(currentPanel.getPanel(), parentGridX, parentGridY);
        }
    }

    protected String getPanelHint() {
        return this._panelHintText;
    }

    protected void setPanelHint(String hintText) {
        this._panelHintText = hintText;
    }

    private String _getDisplayValueFromItemComponent(ImageOptionsChooserPanel value) {
        String deviceTypeName = value.getTranslatedDeviceName();
        return deviceTypeName;
    }

    private void _setComponentIcon(ImageOptionsChooserPanel imageOptionsChooserPanel, JLabel description) {
        boolean hasValidPaths = imageOptionsChooserPanel.validateImages();
        ImageIcon icon = this._validPathsImage;
        try {
            if (!hasValidPaths) {
                if (null == this._portraitImage) {
                    this._portraitImage = ImageIO.read(this._portraitURL);
                }
                if (null == this._errorImageOverlay) {
                    this._errorImageOverlay = ImageIO.read(this._errorOverlayURL);
                }
                if (null == this._errorImage) {
                    int w = Math.max(this._portraitImage.getWidth(), this._errorImageOverlay.getWidth());
                    int h = Math.max(this._portraitImage.getHeight(), this._errorImageOverlay.getHeight());
                    this._errorImage = new BufferedImage(w, h, 2);
                    Graphics g = this._errorImage.getGraphics();
                    g.drawImage(this._portraitImage, 0, 0, null);
                    g.drawImage(this._errorImageOverlay, this._portraitImage.getWidth() - this._errorImageOverlay.getWidth(), this._portraitImage.getHeight() - this._errorImageOverlay.getHeight(), null);
                }
                icon = new ImageIcon(this._errorImage);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        description.setIcon(icon);
    }

    private class DeviceSelectionListener
    implements ListSelectionListener {
        private DeviceSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean adjust = listSelectionEvent.getValueIsAdjusting();
            if (!adjust) {
                assert (listSelectionEvent.getSource() instanceof JList);
                JList list = (JList)listSelectionEvent.getSource();
                int selectedPlatformUiIndex = list.getSelectedIndex();
                int currPlatformIndex = 0;
                for (Map.Entry<String, ImageOptionsChooserPanel> currEntry : DeviceImageOptionsPanel.this._imageOptionsChooserPanelMap.entrySet()) {
                    ImageOptionsChooserPanel currPlatform = currEntry.getValue();
                    if (currPlatformIndex == selectedPlatformUiIndex) {
                        currPlatform.getPanel().setVisible(true);
                    } else {
                        currPlatform.getPanel().setVisible(false);
                        list.repaint();
                    }
                    ++currPlatformIndex;
                }
            }
        }
    }

    private class FileListCellRenderer
    extends DefaultListCellRenderer {
        private FileListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            assert (value instanceof ImageOptionsChooserPanel);
            ImageOptionsChooserPanel panel = (ImageOptionsChooserPanel)value;
            String displayValue = DeviceImageOptionsPanel.this._getDisplayValueFromItemComponent(panel);
            this.setText(displayValue);
            Component ret = super.getListCellRendererComponent((JList<?>)list, displayValue, index, isSelected, cellHasFocus);
            DeviceImageOptionsPanel.this._setComponentIcon(panel, this);
            return ret;
        }
    }
}

