/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.util;

import oracle.adfmf.framework.dt.deploy.common.util.AESEncrypter;
import oracle.jdeveloper.deploy.DeployException;

public class EncryptionUtils {
    public static char[] encryptWithPadding(char[] plainText) throws DeployException {
        byte[] key = null;
        char[] encryptedValue = null;
        try {
            key = EncryptionUtils._getKey();
            encryptedValue = AESEncrypter.encryptWithPadding(plainText, key);
        }
        catch (DeployException e) {
            EncryptionUtils.zeroCharBuffer(encryptedValue);
            throw e;
        }
        finally {
            EncryptionUtils.zeroByteBuffer(key);
        }
        return encryptedValue;
    }

    public static char[] decryptWithPadding(char[] encryptedText) throws DeployException {
        byte[] key = null;
        char[] decryptedValue = null;
        try {
            key = EncryptionUtils._getKey();
            decryptedValue = AESEncrypter.decryptWithPadding(encryptedText, key);
        }
        catch (DeployException e) {
            EncryptionUtils.zeroCharBuffer(decryptedValue);
            throw e;
        }
        finally {
            EncryptionUtils.zeroByteBuffer(key);
        }
        return decryptedValue;
    }

    public static char[] removeZeroPad(char[] plainText) throws DeployException {
        return AESEncrypter.removeZeroPad(plainText);
    }

    public static void zeroCharBuffer(char[] charBuffer) {
        boolean NULL_CHAR = false;
        if (null == charBuffer) {
            return;
        }
        for (int i = 0; i < charBuffer.length; ++i) {
            charBuffer[i] = '\u0000';
        }
    }

    public static char[] copyCharBuffer(char[] charBuffer) {
        char[] copyBuffer = null;
        if (null != charBuffer) {
            copyBuffer = new char[charBuffer.length];
            if (charBuffer.length > 0) {
                System.arraycopy(charBuffer, 0, copyBuffer, 0, charBuffer.length);
            }
        }
        return copyBuffer;
    }

    public static boolean hasLength(char[] charBuffer) {
        return null != charBuffer && charBuffer.length > 0;
    }

    public static void zeroByteBuffer(byte[] byteBuffer) {
        if (null == byteBuffer) {
            return;
        }
        for (int i = 0; i < byteBuffer.length; ++i) {
            byteBuffer[i] = 0;
        }
    }

    private static byte[] _getKey() {
        String key = "29D72032E088BEF4AE9949A4EB22DEA2";
        return AESEncrypter.hexStringToByteArray("29D72032E088BEF4AE9949A4EB22DEA2");
    }
}

