/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;

public class DeployPropertiesFileUtil {
    private static final String _PROPERTIES_FILE_NAME = "deployment.properties";
    private Properties _properties;
    private final URL _propertyFileUrl;
    private final Logger _logger;

    public DeployPropertiesFileUtil(Logger logger) {
        URL extensionRootDirUrl = FileUtils.getSupportFilesDirectoryUrl();
        this._propertyFileUrl = FileUtils.newFileUrl(extensionRootDirUrl, _PROPERTIES_FILE_NAME);
        this._logger = logger;
    }

    public String getProperty(String propertyKeyName, String defaultValue) throws DeployException {
        this._loadProperties();
        String propertyValue = this._properties.getProperty(propertyKeyName, defaultValue);
        if (null != this._logger && this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest(String.format("The value for property, '%s' is: %s", propertyKeyName, propertyValue));
        }
        return propertyValue;
    }

    public Set<String> getMultiValuedProperty(String propertyKeyName, String defaultValue, String delimiterRegex, boolean trimWhitespace) throws DeployException {
        HashSet<String> propertyValues = new HashSet<String>();
        String propertyValue = this.getProperty(propertyKeyName, defaultValue);
        if (ModelUtil.hasLength((String)propertyValue)) {
            String[] propertyValueArray = propertyValue.split(delimiterRegex);
            for (int i = 0; i < propertyValueArray.length; ++i) {
                String currProperty = propertyValueArray[i];
                if (trimWhitespace) {
                    currProperty = currProperty.trim();
                }
                if (!ModelUtil.hasLength((String)currProperty)) continue;
                propertyValues.add(currProperty);
            }
        }
        return propertyValues;
    }

    public URL getFileUrl() {
        return this._propertyFileUrl;
    }

    private void _loadProperties() throws DeployException {
        if (null == this._properties) {
            this._properties = new Properties();
            String propertyFilePath = URLFileSystem.getPlatformPathName((URL)this._propertyFileUrl);
            File propertiesFile = new File(propertyFilePath);
            if (propertiesFile.exists() && propertiesFile.canRead()) {
                if (null != this._logger) {
                    this._logger.info(MobileResourceUtils.getMsg("ADF-MBL-22011", propertyFilePath));
                }
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(propertiesFile);
                    this._properties.load(inputStream);
                }
                catch (Exception e) {
                    String errMessage = MobileResourceUtils.getMsg("ADF-MBL-02015", URLFileSystem.getPlatformPathName((URL)this.getFileUrl()));
                    throw new DeployException(errMessage, (Throwable)e);
                }
                finally {
                    FileUtils.closeStream(inputStream, this._logger);
                }
            }
        }
    }
}

