/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.adfmf.framework.dt.deploy.common.util.EncryptionUtils;
import oracle.jdeveloper.deploy.DeployException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class AESEncrypter {
    private static final String _UTF8_CHARSET = "UTF-8";
    private static final int _AES_BLOCK_SIZE = 16;

    public static char[] encryptWithPadding(char[] plainText, byte[] keyValue) throws DeployException {
        if (null == plainText || null == keyValue || 0 == keyValue.length) {
            throw new IllegalArgumentException();
        }
        byte[] paddedData = null;
        byte[] encryptedByteArrayValue = null;
        char[] encryptedValue = null;
        try {
            Cipher cipher = AESEncrypter._getCipher(keyValue, AESEncrypter._getEncryptMode());
            paddedData = AESEncrypter._padWithZeros(plainText);
            encryptedByteArrayValue = cipher.doFinal(paddedData);
            encryptedValue = new BASE64Encoder().encode(encryptedByteArrayValue).toCharArray();
        }
        catch (Exception e) {
            try {
                EncryptionUtils.zeroCharBuffer(encryptedValue);
                throw new DeployException((Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptionUtils.zeroByteBuffer(paddedData);
                EncryptionUtils.zeroByteBuffer(encryptedByteArrayValue);
                throw throwable;
            }
        }
        EncryptionUtils.zeroByteBuffer(paddedData);
        EncryptionUtils.zeroByteBuffer(encryptedByteArrayValue);
        return encryptedValue;
    }

    public static char[] decryptWithPadding(char[] encryptedText, byte[] keyValue) throws DeployException {
        char[] returnValue = null;
        byte[] encryptedValue = null;
        byte[] decryptedValue = null;
        if (null == encryptedText || null == keyValue || 0 == keyValue.length) {
            throw new IllegalArgumentException();
        }
        try {
            Cipher cipher = AESEncrypter._getCipher(keyValue, AESEncrypter._getDecryptMode());
            encryptedValue = new BASE64Decoder().decodeBuffer(String.valueOf(encryptedText));
            decryptedValue = cipher.doFinal(encryptedValue);
            returnValue = AESEncrypter._getCharBufferFromByteArray(decryptedValue);
        }
        catch (Exception e) {
            try {
                EncryptionUtils.zeroCharBuffer(returnValue);
                throw new DeployException((Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptionUtils.zeroByteBuffer(encryptedValue);
                EncryptionUtils.zeroByteBuffer(decryptedValue);
                throw throwable;
            }
        }
        EncryptionUtils.zeroByteBuffer(encryptedValue);
        EncryptionUtils.zeroByteBuffer(decryptedValue);
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] removeZeroPad(char[] plainText) throws DeployException {
        byte[] output;
        char[] returnValue;
        block10: {
            returnValue = null;
            output = null;
            ByteBuffer input = null;
            try {
                if (null == plainText) {
                    throw new IllegalArgumentException();
                }
                input = AESEncrypter._getByteArrayFromCharArray(plainText);
                int len = input.limit();
                int rest = len % 16;
                int zeroByteIdx = len;
                if (0 == rest) {
                    byte[] buffer = input.array();
                    for (int i = 0; i < len; ++i) {
                        if (buffer[i] != 0) continue;
                        zeroByteIdx = i;
                        break;
                    }
                }
                if (zeroByteIdx > 0) {
                    output = new byte[zeroByteIdx];
                    System.arraycopy(input.array(), 0, output, 0, zeroByteIdx);
                    returnValue = AESEncrypter._getCharBufferFromByteArray(output);
                } else {
                    returnValue = new char[]{};
                }
                if (null == input) break block10;
            }
            catch (Exception e) {
                try {
                    EncryptionUtils.zeroCharBuffer(returnValue);
                    throw new DeployException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (null != input) {
                        EncryptionUtils.zeroByteBuffer(input.array());
                    }
                    EncryptionUtils.zeroByteBuffer(output);
                    throw throwable;
                }
            }
            EncryptionUtils.zeroByteBuffer(input.array());
        }
        EncryptionUtils.zeroByteBuffer(output);
        return returnValue;
    }

    public static byte[] hexStringToByteArray(String hex) {
        int RADIX_BASE_16 = 16;
        byte[] result = null;
        if (null == hex) {
            return result;
        }
        result = new byte[hex.length() / 2];
        int i = 0;
        int pos = 0;
        while (pos < hex.length()) {
            byte b;
            result[i] = b = (byte)Integer.parseInt(hex.substring(pos, pos + 2), 16);
            pos += 2;
            ++i;
        }
        return result;
    }

    private static int _getDecryptMode() {
        return 2;
    }

    private static int _getEncryptMode() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cipher _getCipher(byte[] keyValue, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] aesInitializationVector = null;
        byte[] sharedKey = null;
        Cipher cipher = null;
        try {
            String AES_SECRET_KEY_ALGORITHM = "AES";
            String AES_TRANSFORMATION_ALGO_MODE_PADDING = "AES/CBC/NoPadding";
            String SHARED_KEY = "BAC464B197083EE626273DC4C9EBD8AE82E0897E3D8388EE06CB3EF7BCFFF458";
            SecretKeySpec key = new SecretKeySpec(keyValue, "AES");
            cipher = Cipher.getInstance("AES/CBC/NoPadding");
            aesInitializationVector = new byte[16];
            sharedKey = AESEncrypter.hexStringToByteArray("BAC464B197083EE626273DC4C9EBD8AE82E0897E3D8388EE06CB3EF7BCFFF458");
            System.arraycopy(sharedKey, 0, aesInitializationVector, 0, 16);
            IvParameterSpec paramSpec = new IvParameterSpec(aesInitializationVector);
            EncryptionUtils.zeroByteBuffer(aesInitializationVector);
            cipher.init(mode, (Key)key, paramSpec);
        }
        catch (Throwable throwable) {
            EncryptionUtils.zeroByteBuffer(sharedKey);
            EncryptionUtils.zeroByteBuffer(aesInitializationVector);
            throw throwable;
        }
        EncryptionUtils.zeroByteBuffer(sharedKey);
        EncryptionUtils.zeroByteBuffer(aesInitializationVector);
        return cipher;
    }

    private static byte[] _padWithZeros(char[] plainText) throws DeployException {
        ByteBuffer inputByteArray = null;
        byte[] paddedValue = null;
        try {
            inputByteArray = AESEncrypter._getByteArrayFromCharArray(plainText);
            int rest = inputByteArray.limit() % 16;
            paddedValue = rest > 0 ? new byte[inputByteArray.limit() + (16 - rest)] : new byte[inputByteArray.limit()];
            System.arraycopy(inputByteArray.array(), 0, paddedValue, 0, inputByteArray.limit());
        }
        catch (Exception e) {
            EncryptionUtils.zeroByteBuffer(paddedValue);
            throw new DeployException((Throwable)e);
        }
        finally {
            EncryptionUtils.zeroByteBuffer(inputByteArray.array());
        }
        return paddedValue;
    }

    private static char[] _getCharBufferFromByteArray(byte[] byteArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
        Charset utf8CharSet = Charset.forName(_UTF8_CHARSET);
        CharBuffer charBuffer = utf8CharSet.decode(byteBuffer);
        return charBuffer.array();
    }

    private static ByteBuffer _getByteArrayFromCharArray(char[] charArray) {
        Charset utf8CharSet = Charset.forName(_UTF8_CHARSET);
        CharBuffer charBuffer = CharBuffer.wrap(charArray);
        ByteBuffer byteBuffer = utf8CharSet.encode(charBuffer);
        return byteBuffer;
    }
}

