/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.ui;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.common.ui.BrowserPanel;
import oracle.adfmf.framework.dt.deploy.common.ui.IosSigningOptions;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversalException;

public class IosSigningPanel
extends ControlGroupPanel {
    private static final long serialVersionUID = 1L;
    private final URLChooser _provisioningProfileChooser = DialogUtil.newURLChooser();
    private JTextField _provisioningProfileEditCtrl;
    private JTextField _certificate;
    private static final Map<String, String> _sSupportedProfileTypeMap = new HashMap<String, String>();
    private static final String _MOBILE_PROVISION_FILE_EXTENSION = ".mobileprovision";

    public IosSigningPanel() {
        this._initializeComponent();
    }

    private void _initializeComponent() {
        this._initializeProvisioningProfileChooser();
        boolean BROWSER_PANEL_CONTROL_LEFT_INDENT = false;
        boolean gridX = false;
        int gridY = 0;
        ControlGroupPanel deviceSigningSeperatorPanel = new ControlGroupPanel();
        deviceSigningSeperatorPanel.setWeightX(1.0);
        deviceSigningSeperatorPanel.addLabeledSeparator(MobileResourceUtils.getText("BUILD_OPTIONS_DEVICE_SIGNING"), 0, gridY++);
        deviceSigningSeperatorPanel.addHintLabel(MobileResourceUtils.getText("BUILD_OPTIONS_SIGNING_HINT"), 0, gridY++, 3);
        BrowserPanel browserPanel = new BrowserPanel((Component)((Object)this), this._provisioningProfileChooser, MobileResourceUtils.getText("BUILD_OPTIONS_PROVISIONING_PROFILE"), null, false, MobileResourceUtils.getText("CHOOSE_PROVISIONING_PROFILE_LOCATION"), false, 0);
        this._provisioningProfileEditCtrl = browserPanel.getTextField();
        this._certificate = browserPanel.addLabeledTextField(MobileResourceUtils.getText("BUILD_OPTIONS_CERTIFICATE"), 0, 0, gridY++, false, false, false);
        gridY = 0;
        this.addPanel(deviceSigningSeperatorPanel, 0, gridY++);
        this.addPanel(browserPanel, 0, gridY++);
    }

    public void onEntry(IosSigningOptions iosSigningOptions) {
        String provisioningFilePath = iosSigningOptions.getProvisioningProfileFilePath();
        if (FileUtils.doesFileExist(provisioningFilePath)) {
            this._provisioningProfileChooser.setSelectedURL(URLFactory.newFileURL((String)provisioningFilePath));
        }
        this._provisioningProfileEditCtrl.setText(iosSigningOptions.getProvisioningProfileFilePath());
        this._certificate.setText(iosSigningOptions.getCertificate());
    }

    public IosSigningOptions onExit() throws TraversalException {
        return new IosSigningOptions(this._provisioningProfileEditCtrl.getText(), this._certificate.getText());
    }

    private void _initializeProvisioningProfileChooser() {
        DialogUtil.initURLChooser((URLChooser)this._provisioningProfileChooser, null);
        this._provisioningProfileChooser.setSelectionScope(0);
        this._provisioningProfileChooser.setSelectionMode(0);
        this._provisioningProfileChooser.setShowJarsAsDirs(false);
        this._provisioningProfileChooser.clearChooseableURLFilters();
        DefaultURLFilter oURLFilter = new DefaultURLFilter(MobileResourceUtils.getText("PROVISIONING_PROFILE_OPTIONS_FILTER_DESCRIPTION"), FileUtils.buildStringArrayFromMapKeys(_sSupportedProfileTypeMap));
        this._provisioningProfileChooser.setURLFilter((URLFilter)oURLFilter);
    }

    static {
        _sSupportedProfileTypeMap.put(_MOBILE_PROVISION_FILE_EXTENSION, "");
    }
}

