/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.PreferenceUtils;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Borders;
import oracle.javatools.ui.completion.CompletionPopupHandler;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.javatools.ui.completion.FileCompletionProvider;
import oracle.javatools.util.ModelUtil;

public class BrowserPanel
extends ControlGroupPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private static final int _TEXT_FIELD_LABEL_COLUMN_SPAN_WIDTH = 1;
    private static final int _TEXT_FIELD_COLUMN_SPAN_WIDTH = 1;
    private static final int _TEXT_FIELD_NO_MAXIMUM_LEN = 0;
    private static final String _CHOOSER_DIRECTORY_DEFAULT_TITLE_LABEL = MobileResourceUtils.getText("CHOOSE_DIR_LABEL");
    private static final String _CHOOSER_FILE_DEFAULT_TITLE_LABEL = MobileResourceUtils.getText("CHOOSE_FILE_LABEL");
    private final CompletionTextField _textField;
    private final String _textFieldHint;
    private final JButton _browserButton;
    private final URLChooser _urlChooser;
    private final Component _uiParent;
    private static final int _VALIDATION_TIMER_DELAY_MS = 500;
    private final Timer _validationTimer = new Timer(500, new TimerListener());
    private boolean _directoriesOnly;
    private String _chooserDialogTitle;

    public BrowserPanel(Component uiParent, URLChooser urlChooser, String textFieldLabel, String textFieldHint, boolean alignVertically, int leftIndentPixelLength) {
        this(uiParent, urlChooser, textFieldLabel, textFieldHint, true, _CHOOSER_DIRECTORY_DEFAULT_TITLE_LABEL, alignVertically, leftIndentPixelLength);
    }

    public BrowserPanel(Component uiParent, URLChooser urlChooser, String textFieldLabel, String textFieldHint, boolean directoriesOnly, String chooserDialogTitle, boolean alignVertically, int leftIndentPixelLength) {
        int gridY = 0;
        boolean gridX = false;
        this._directoriesOnly = directoriesOnly;
        this._chooserDialogTitle = chooserDialogTitle;
        this.setLeftIndentPixelSize(leftIndentPixelLength);
        if (!ModelUtil.hasLength((String)this._chooserDialogTitle)) {
            this._chooserDialogTitle = this._directoriesOnly ? _CHOOSER_DIRECTORY_DEFAULT_TITLE_LABEL : _CHOOSER_FILE_DEFAULT_TITLE_LABEL;
        }
        this.setBottomIndentPixelSize(1);
        this._textField = this.addLabeledCompletionTextField(textFieldLabel, textFieldHint, 1, 1, 0, 0, gridY, false, alignVertically, false);
        int buttonGridX = 0;
        buttonGridX = alignVertically ? 1 : 2;
        int n = ++gridY;
        ++gridY;
        this._browserButton = this.addButton(buttonGridX, n, OracleIcons.getIcon((String)"lov.png"));
        this._textFieldHint = textFieldHint;
        this._uiParent = uiParent;
        this._urlChooser = urlChooser;
        FileCompletionProvider provider = new FileCompletionProvider(this._directoriesOnly);
        CompletionPopupHandler popupHandler = this._textField.getPopupHandler();
        popupHandler.registerInsightProvider((CompletionProvider)provider);
        popupHandler.setAlignWithField(true);
        this._textField.getDocument().addDocumentListener(this);
        this._validationTimer.setRepeats(false);
        this._browserButton.addActionListener(this);
    }

    public String getText() {
        return this._textField.getText();
    }

    public void setText(String textValue) {
        this._textField.setText(textValue);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String path = this._getPathFromURLChooser();
        if (path != null) {
            this._textField.setText(path);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this._validationTimer.restart();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this._validationTimer.restart();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this._validationTimer.restart();
    }

    private String _getPathFromURLChooser() {
        URL url;
        this._setChooserStartingUrl();
        int result = this._urlChooser.showOpenDialog(this._uiParent, this._chooserDialogTitle);
        String path = null;
        if (result == 0 && (url = this._urlChooser.getSelectedURL()) != null) {
            path = URLFileSystem.getPlatformPathName((URL)url);
        }
        return path;
    }

    private void _setChooserStartingUrl() {
        String directoryPath = this._textField.getText();
        URL startingUrl = FileUtils.getUrlFromPath(directoryPath);
        if (null == startingUrl) {
            startingUrl = FileUtils.getUrlFromPath(PreferenceUtils.getAndroidDefaultSdkPath());
        }
        if (null != startingUrl) {
            this._urlChooser.setSelectedURL(startingUrl);
        }
    }

    public URL getUrlFromSdkHintText() {
        URL sdkHintTextUrl = null;
        if (ModelUtil.hasLength((String)this._textFieldHint)) {
            String hintTextPath = this._textFieldHint.substring(MobileResourceUtils.getText("SDK_PATH_EXAMPLE_TOKEN").length()).trim();
            String correctedWindowsPath = PreferenceUtils.getCorrectWindowsProgramFilesPath(hintTextPath);
            sdkHintTextUrl = BrowserPanel._getUrlFromPath(correctedWindowsPath);
        }
        return sdkHintTextUrl;
    }

    public JTextField getTextField() {
        return this._textField;
    }

    private static URL _getUrlFromPath(String directoryPath) {
        URL startingUrl = null;
        if (null != directoryPath && directoryPath.trim().length() > 0 && !URLFileSystem.isDirectory((URL)(startingUrl = URLFactory.newDirURL((String)directoryPath.trim())))) {
            startingUrl = null;
        }
        return startingUrl;
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this._validateDirectory();
        }

        private void _validateDirectory() {
            String path = BrowserPanel.this._textField.getText().trim();
            if (!ModelUtil.hasLength((String)path)) {
                Borders.restoreBorder((JComponent)BrowserPanel.this._textField);
                return;
            }
            boolean showErrorBorder = false;
            if (BrowserPanel.this._directoriesOnly) {
                showErrorBorder = !URLFileSystem.isDirectory((URL)URLFactory.newDirURL((String)path));
            } else {
                boolean bl = showErrorBorder = !FileUtils.doesFileExist(path);
            }
            if (showErrorBorder) {
                Borders.attachErrorBorder((JComponent)BrowserPanel.this._textField);
            } else {
                Borders.restoreBorder((JComponent)BrowserPanel.this._textField);
            }
        }
    }
}

