/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.common.ui.AndroidSigningOptions;
import oracle.adfmf.framework.dt.deploy.common.ui.BrowserPanel;
import oracle.adfmf.framework.dt.deploy.common.util.EncryptionUtils;
import oracle.adfmf.framework.dt.preferences.PlatformSDKsPrefs;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;

public class AndroidSigningPanel
extends ControlGroupPanel {
    private static final long serialVersionUID = 1L;
    private final URLChooser _keyStoreUrlChooser = DialogUtil.newURLChooser();
    private JPasswordField _debugKeyPasswordField;
    private JTextField _keystoreLocationTextField;
    private JPasswordField _keystorePasswordField;
    private JTextField _keyAliasTextField;
    private JPasswordField _keyPasswordField;
    private static final Map<String, String> _sSupportedKeystoreFileTypeMap = new HashMap<String, String>();
    private static final String _KEYSTORE_FILE_EXTENSION = ".keystore";
    private static final int _INDENT_PIXEL_LEN = 5;

    public AndroidSigningPanel() {
        this._initializeComponent();
    }

    public void onEntry(AndroidSigningOptions androidSigningOptions) throws TraversalException {
        String keystorePath = androidSigningOptions.getReleaseSigningKeystorePath();
        if (FileUtils.doesFileExist(keystorePath)) {
            this._keyStoreUrlChooser.setSelectedURL(URLFactory.newFileURL((String)keystorePath));
        }
        this._keystoreLocationTextField.setText(keystorePath);
        this._keyAliasTextField.setText(androidSigningOptions.getReleaseSigningKeyAlias());
        this._setPassword(this._keystorePasswordField, androidSigningOptions.getReleaseSigningKeystorePassword());
        this._setPassword(this._keyPasswordField, androidSigningOptions.getReleaseSigningKeyPassword());
        char[] debugSigningPassword = androidSigningOptions.getDebugSigningPassword();
        if (null != debugSigningPassword) {
            this._setPassword(this._debugKeyPasswordField, androidSigningOptions.getDebugSigningPassword());
        } else {
            Preferences preferences = Preferences.getPreferences();
            PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
            char[] defaultPassword = platformPrefs.getAndroidDefaultDebugSigningPassword();
            this._debugKeyPasswordField.setText(String.valueOf(defaultPassword));
            EncryptionUtils.zeroCharBuffer(defaultPassword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidSigningOptions onExit() throws TraversalException {
        AndroidSigningOptions androidSigningOptions;
        char[] encryptedKeystorePassword = null;
        char[] encryptedKeyPassword = null;
        char[] encryptedDebugKeyPassword = null;
        try {
            String keyAlias;
            String keyStorePath = DeployFileUtils.getTrimmedStringValue(this._keystoreLocationTextField.getText());
            if (ModelUtil.hasLength((String)keyStorePath)) {
                this._checkKeystoreValidity(keyStorePath);
            }
            if (ModelUtil.hasLength((String)(keyAlias = this._keyAliasTextField.getText()))) {
                this._validateKeyAlias(keyAlias);
            }
            encryptedKeystorePassword = this._getValidatedPasswordField(this._keystorePasswordField, MobileResourceUtils.getText("ANDROID_KEYSTORE_PASSWORD"));
            encryptedKeyPassword = this._getValidatedPasswordField(this._keyPasswordField, MobileResourceUtils.getText("ANDROID_KEY_PASSWORD"));
            encryptedDebugKeyPassword = this._getValidatedPasswordField(this._debugKeyPasswordField, MobileResourceUtils.getText("ANDROID_DEBUG_KEY_PASSWORD_FIELD_LABEL"));
            androidSigningOptions = new AndroidSigningOptions(keyStorePath, keyAlias, encryptedKeystorePassword, encryptedKeyPassword, encryptedDebugKeyPassword);
        }
        catch (Throwable throwable) {
            EncryptionUtils.zeroCharBuffer(encryptedKeystorePassword);
            EncryptionUtils.zeroCharBuffer(encryptedKeyPassword);
            EncryptionUtils.zeroCharBuffer(encryptedDebugKeyPassword);
            throw throwable;
        }
        EncryptionUtils.zeroCharBuffer(encryptedKeystorePassword);
        EncryptionUtils.zeroCharBuffer(encryptedKeyPassword);
        EncryptionUtils.zeroCharBuffer(encryptedDebugKeyPassword);
        return androidSigningOptions;
    }

    private void _initializeKeystoreUrlChooser() {
        DialogUtil.initURLChooser((URLChooser)this._keyStoreUrlChooser, null);
        this._keyStoreUrlChooser.setSelectionScope(0);
        this._keyStoreUrlChooser.setSelectionMode(0);
        this._keyStoreUrlChooser.setShowJarsAsDirs(false);
        this._keyStoreUrlChooser.clearChooseableURLFilters();
        DefaultURLFilter urlFilter = new DefaultURLFilter(MobileResourceUtils.getText("ANDROID_SIGNING_FILTER_URL_CHOOSER_TITLE"), FileUtils.buildStringArrayFromMapKeys(_sSupportedKeystoreFileTypeMap));
        this._keyStoreUrlChooser.setURLFilter((URLFilter)urlFilter);
    }

    private void _initializeComponent() {
        this._initializeKeystoreUrlChooser();
        boolean gridX = false;
        int gridY = 0;
        ControlGroupPanel debugSigningPanel = this._createDebugSigningPanel();
        ControlGroupPanel releaseSigningPanel = this._createReleaseSigningPanel();
        ArrayList<ControlGroupPanel> panelList = new ArrayList<ControlGroupPanel>();
        panelList.add(debugSigningPanel);
        panelList.add(releaseSigningPanel);
        ArrayList<String> tabTitleList = new ArrayList<String>();
        tabTitleList.add(MobileResourceUtils.getText("ANDROID_DEBUG_SIGNING_TAB_LABEL"));
        tabTitleList.add(MobileResourceUtils.getText("ANDROID_RELEASE_SIGNING_TAB_LABEL"));
        gridY = 0;
        this.addLabeledSeparator(MobileResourceUtils.getText("ANDROID_SIGNING_CREDENTIALS_SEPARATOR_LABEL"), 0, gridY++);
        this.addTabbedWindow(tabTitleList, null, panelList, 0, gridY++);
    }

    private void _checkKeystoreValidity(String keystorePath) throws TraversalException {
        if (ModelUtil.hasLength((String)keystorePath)) {
            String absoluteLocation = this._getKeystoreAbsoluteLocation(keystorePath);
            this._checkKeystoreExists(absoluteLocation);
            this._checkKeystoreTypeSupported(absoluteLocation);
        }
    }

    private String _getKeystoreAbsoluteLocation(String relativeOrAbsolutePath) {
        return FileUtils.getAbsoluteLocation(null, relativeOrAbsolutePath);
    }

    private void _checkKeystoreExists(String absoluteKeystorePath) throws TraversalException {
        if (!FileUtils.doesFileExist(absoluteKeystorePath)) {
            String message = MobileResourceUtils.getMsg("ADF-MBL-00007", absoluteKeystorePath);
            String dlgTitle = MobileResourceUtils.getText("INVALID_SIGNING_KEYSTORE_LOCATION_DLG_TITLE");
            JOptionPane.showMessageDialog((Component)((Object)this), message, dlgTitle, 0);
            throw new TraversalException(null);
        }
    }

    private void _checkKeystoreTypeSupported(String absoluteKeystorePath) throws TraversalException {
        String fileExtension = FileUtils.getFileExtension(absoluteKeystorePath);
        if (!ModelUtil.hasLength((String)fileExtension) || !_sSupportedKeystoreFileTypeMap.containsKey(fileExtension)) {
            String supportedTypes = FileUtils.buildCommaDelimitedStringFromMapKeys(_sSupportedKeystoreFileTypeMap);
            String errorMessage = MobileResourceUtils.getMsg("ADF-MBL-00026", supportedTypes);
            String dialogTitle = MobileResourceUtils.getText("INVALID_SIGNING_KEYSTORE_TYPE_DLG_TITLE");
            JOptionPane.showMessageDialog((Component)((Object)this), errorMessage, dialogTitle, 0);
            throw new TraversalException(null);
        }
    }

    private void _validateDecryptedPassword(char[] password, String passwordLabelName) throws TraversalException {
        int MIN_PASSWORD_LEN = 6;
        if (!EncryptionUtils.hasLength(password) || password.length < 6) {
            String message = MobileResourceUtils.getText("INVALID_SIGNING_PASSWORD", passwordLabelName);
            String dlgTitle = MobileResourceUtils.getText("INVALID_SIGNING_PASSWORD_DLG_TITLE");
            JOptionPane.showMessageDialog((Component)((Object)this), message, dlgTitle, 0);
            throw new TraversalException(null);
        }
    }

    private void _validateKeyAlias(String keyAlias) throws TraversalException {
        if (!ModelUtil.hasLength((String)keyAlias)) {
            String message = MobileResourceUtils.getText("INVALID_KEY_ALIAS");
            String dlgTitle = MobileResourceUtils.getText("INVALID_KEY_ALIAS_DLG_TITLE");
            JOptionPane.showMessageDialog((Component)((Object)this), message, dlgTitle, 0);
            throw new TraversalException(null);
        }
    }

    private ControlGroupPanel _createDebugSigningPanel() {
        ControlGroupPanel debugSigningPanel = new ControlGroupPanel();
        debugSigningPanel.setLeftIndentPixelSize(5);
        int DEBUG_PANEL_COLUMN_SIZE = 2;
        boolean gridX = false;
        int gridY = 0;
        debugSigningPanel.addHintLabel(MobileResourceUtils.getText("ANDROID_DEBUG_KEY_HINT_LABEL"), 0, gridY++, 2);
        this._debugKeyPasswordField = debugSigningPanel.addLabeledPasswordTextField(MobileResourceUtils.getText("ANDROID_DEBUG_KEY_PASSWORD_FIELD_LABEL"), 0, 0, gridY++, false);
        debugSigningPanel.addGlue(0, gridY++);
        return debugSigningPanel;
    }

    private ControlGroupPanel _createReleaseSigningPanel() {
        int RELEASE_PANEL_COLUMN_SIZE = 3;
        int BROWSER_PANEL_CONTROL_LEFT_INDENT = 5;
        ControlGroupPanel releaseSigningHintPanel = new ControlGroupPanel();
        releaseSigningHintPanel.setLeftIndentPixelSize(5);
        double PANEL_WEIGHT_X = 1.0;
        releaseSigningHintPanel.setWeightX(1.0);
        boolean gridX = false;
        int gridY = 0;
        releaseSigningHintPanel.addHintLabel(MobileResourceUtils.getText("ANDROID_RELEASE_KEY_HINT_LABEL"), 0, gridY++, 3);
        BrowserPanel browserPanel = new BrowserPanel((Component)((Object)this), this._keyStoreUrlChooser, MobileResourceUtils.getText("ANDROID_SIGNING_KEYSTORE_LOCATION_LABEL"), null, false, MobileResourceUtils.getText("ANDROID_CHOOSE_SIGNING_KEYSTORE_LOCATION"), false, 5);
        this._keystoreLocationTextField = browserPanel.getTextField();
        this._keystorePasswordField = browserPanel.addLabeledPasswordTextField(MobileResourceUtils.getText("ANDROID_KEYSTORE_PASSWORD"), 0, 0, gridY++, false);
        this._keyAliasTextField = browserPanel.addLabeledTextField(MobileResourceUtils.getText("ANDROID_ALIAS"), 0, 0, gridY++, false, false, false);
        this._keyPasswordField = browserPanel.addLabeledPasswordTextField(MobileResourceUtils.getText("ANDROID_KEY_PASSWORD"), 0, 0, gridY++, false);
        gridY = 0;
        ControlGroupPanel releaseSigningPanel = new ControlGroupPanel();
        gridY = 0;
        releaseSigningPanel.addPanel(releaseSigningHintPanel, 0, gridY++);
        releaseSigningPanel.addPanel(browserPanel, 0, gridY++);
        return releaseSigningPanel;
    }

    private char[] _getValidatedPasswordField(JPasswordField passwordField, String label) throws TraversalException {
        char[] decryptedPassword = passwordField.getPassword();
        char[] empytOrEncryptedValue = null;
        try {
            char[] trimmedDecryptedPassword = EncryptionUtils.removeZeroPad(decryptedPassword);
            EncryptionUtils.zeroCharBuffer(decryptedPassword);
            if (EncryptionUtils.hasLength(trimmedDecryptedPassword)) {
                this._validateDecryptedPassword(trimmedDecryptedPassword, DeployFileUtils.stripMnemonicAndColonFromLabel(label));
                empytOrEncryptedValue = EncryptionUtils.encryptWithPadding(trimmedDecryptedPassword);
                EncryptionUtils.zeroCharBuffer(trimmedDecryptedPassword);
            } else {
                empytOrEncryptedValue = trimmedDecryptedPassword;
            }
        }
        catch (DeployException e) {
            throw new TraversalException((Object)e);
        }
        return empytOrEncryptedValue;
    }

    private void _setPassword(JPasswordField field, char[] value) throws TraversalException {
        if (EncryptionUtils.hasLength(value)) {
            try {
                field.setText(String.valueOf(EncryptionUtils.decryptWithPadding(value)));
                EncryptionUtils.zeroCharBuffer(value);
            }
            catch (DeployException e) {
                throw new TraversalException((Object)e);
            }
        }
    }

    static {
        _sSupportedKeystoreFileTypeMap.put(_KEYSTORE_FILE_EXTENSION, "");
    }
}

