/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.ui;

import oracle.adfmf.framework.dt.deploy.common.util.EncryptionUtils;

public final class AndroidSigningOptions {
    private final String _releaseSigningKeystorePath;
    private final String _releaseSigningKeyAlias;
    private final char[] _releaseSigningKeystorePassword;
    private final char[] _releaseSigningKeyPassword;
    private final char[] _debugSigningPassword;
    private boolean _stateIsValid = true;

    public AndroidSigningOptions(String releaseSigningKeystorePath, String releaseSigningKeyAlias, char[] releaseSigningKeystorePassword, char[] releaseSigningKeyPassword, char[] debugSigningPassword) {
        this._releaseSigningKeystorePath = releaseSigningKeystorePath;
        this._releaseSigningKeyAlias = releaseSigningKeyAlias;
        this._releaseSigningKeystorePassword = EncryptionUtils.copyCharBuffer(releaseSigningKeystorePassword);
        this._releaseSigningKeyPassword = EncryptionUtils.copyCharBuffer(releaseSigningKeyPassword);
        this._debugSigningPassword = EncryptionUtils.copyCharBuffer(debugSigningPassword);
    }

    public void invalidate() {
        EncryptionUtils.zeroCharBuffer(this._releaseSigningKeystorePassword);
        EncryptionUtils.zeroCharBuffer(this._releaseSigningKeyPassword);
        EncryptionUtils.zeroCharBuffer(this._debugSigningPassword);
        this._stateIsValid = false;
    }

    public String getReleaseSigningKeystorePath() {
        this._validateState();
        return this._releaseSigningKeystorePath;
    }

    public String getReleaseSigningKeyAlias() {
        this._validateState();
        return this._releaseSigningKeyAlias;
    }

    public char[] getReleaseSigningKeystorePassword() {
        this._validateState();
        return EncryptionUtils.copyCharBuffer(this._releaseSigningKeystorePassword);
    }

    public char[] getReleaseSigningKeyPassword() {
        this._validateState();
        return EncryptionUtils.copyCharBuffer(this._releaseSigningKeyPassword);
    }

    public char[] getDebugSigningPassword() {
        this._validateState();
        return EncryptionUtils.copyCharBuffer(this._debugSigningPassword);
    }

    private void _validateState() {
        if (!this._stateIsValid) {
            throw new IllegalStateException();
        }
    }
}

