/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers.whitelist;

import java.net.URL;
import java.util.Set;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.ApplicationXmlWhiteListPatternReader;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.ConnectionsXmlWhiteListPatternReader;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.WhiteListFileCreator;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.WhiteListUrlPattern;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public class CreateWhiteListDeployer
extends AbstractDeployer {
    private final WhiteListFileCreator _whiteListFileCreator;

    public CreateWhiteListDeployer(int deploySequenceId, WhiteListFileCreator whiteListFileCreator) {
        super(deploySequenceId);
        if (null == whiteListFileCreator) {
            throw new IllegalArgumentException();
        }
        this._whiteListFileCreator = whiteListFileCreator;
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        try {
            Workspace workspace = deployShell.getContext().getWorkspace();
            Set<WhiteListUrlPattern> whiteListedUrls = this._getWhiteListElements(workspace);
            this._whiteListFileCreator.createWhiteListFile(deployShell, whiteListedUrls);
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
    }

    private Set<WhiteListUrlPattern> _getWhiteListElements(Workspace workspace) throws DeployException {
        URL connectionsXmlUrl = McAppUtils.getConnectionsXmlURL(workspace);
        ConnectionsXmlWhiteListPatternReader connReader = new ConnectionsXmlWhiteListPatternReader(connectionsXmlUrl);
        Set<WhiteListUrlPattern> whiteListXmlPatterns = connReader.getWhitelistPatterns();
        URL adfmfApplicationUrl = McAppUtils.getApplicationXmlURL(workspace);
        ApplicationXmlWhiteListPatternReader appReader = new ApplicationXmlWhiteListPatternReader(adfmfApplicationUrl);
        whiteListXmlPatterns.addAll(appReader.getWhitelistPatterns());
        return whiteListXmlPatterns;
    }
}

