/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers.whitelist;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.adfmf.common.util.XmlUtils;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.GetWhiteListedUrlPatterns;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.WhiteListUrlPattern;
import oracle.adfmf.framework.dt.deploy.common.util.DeployUtil;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConnectionsXmlWhiteListPatternReader
implements GetWhiteListedUrlPatterns {
    private final URL _connectionsXmlUrl;

    public ConnectionsXmlWhiteListPatternReader(URL connectionsXmlUrl) {
        this._connectionsXmlUrl = connectionsXmlUrl;
    }

    @Override
    public Set<WhiteListUrlPattern> getWhitelistPatterns() throws DeployException {
        HashSet<WhiteListUrlPattern> whiteListedUrlSet = new HashSet<WhiteListUrlPattern>();
        if (null == this._connectionsXmlUrl) {
            return whiteListedUrlSet;
        }
        XmlModel model = DeployUtil.getXmlModel(this._connectionsXmlUrl);
        whiteListedUrlSet.addAll(this._getUrlConnectionsFromConnectionsXml((AbstractModel)model));
        return whiteListedUrlSet;
    }

    private Set<WhiteListUrlPattern> _getUrlConnectionsFromConnectionsXml(AbstractModel model) {
        Set whiteListedUrls = (Set)new ReadOnlyTask<Set<WhiteListUrlPattern>>(){

            protected Set<WhiteListUrlPattern> runImpl(AbstractModel model) {
                String ATTR_URLCONNECTION = "urlconnection";
                HashSet<WhiteListUrlPattern> whiteListedUrlPatterns = new HashSet<WhiteListUrlPattern>();
                Element root = model.getDocument().getDocumentElement();
                String ALL_NAMESPACES = "*";
                List<Node> domainNodeList = XmlUtils.getNamedChildElementsByNS(root, "*", "urlconnection");
                for (Node currNode : domainNodeList) {
                    assert (currNode instanceof Element);
                    Element currElement = (Element)currNode;
                    String currValue = currElement.getAttribute("url");
                    if (!ModelUtil.hasLength((String)currValue)) continue;
                    whiteListedUrlPatterns.add(new WhiteListUrlPattern(currValue));
                }
                return whiteListedUrlPatterns;
            }
        }.run(model);
        return whiteListedUrls;
    }
}

