/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers.whitelist;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.adfmf.common.util.XmlUtils;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.GetWhiteListedUrlPatterns;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.WhiteListUrlPattern;
import oracle.adfmf.framework.dt.deploy.common.util.DeployUtil;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ApplicationXmlWhiteListPatternReader
implements GetWhiteListedUrlPatterns {
    private final URL _applicationXmlUrl;

    public ApplicationXmlWhiteListPatternReader(URL applicationXmlUrl) {
        this._applicationXmlUrl = applicationXmlUrl;
        if (null == applicationXmlUrl) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Set<WhiteListUrlPattern> getWhitelistPatterns() throws DeployException {
        XmlModel model = DeployUtil.getXmlModel(this._applicationXmlUrl);
        Set whiteListedUrls = (Set)new ReadOnlyTask<Set<WhiteListUrlPattern>>(){

            protected Set<WhiteListUrlPattern> runImpl(AbstractModel model) {
                HashSet<WhiteListUrlPattern> whiteListedUrlPatterns = new HashSet<WhiteListUrlPattern>();
                Node remoteUrlWhiteListNode = XmlUtils.getFirstNamedChildElement(model.getDocument(), "http://xmlns.oracle.com/adf/mf", "remoteURLWhiteList");
                if (null == remoteUrlWhiteListNode) {
                    return whiteListedUrlPatterns;
                }
                assert (remoteUrlWhiteListNode instanceof Element);
                List<Node> domainNodeList = XmlUtils.getNamedChildElementsByNS((Element)remoteUrlWhiteListNode, "http://xmlns.oracle.com/adf/mf", "domain");
                for (Node currNode : domainNodeList) {
                    String currValue = currNode.getTextContent();
                    if (!ModelUtil.hasLength((String)currValue)) continue;
                    whiteListedUrlPatterns.add(new WhiteListUrlPattern(currValue));
                }
                return whiteListedUrlPatterns;
            }
        }.run((AbstractModel)model);
        return whiteListedUrls;
    }
}

