/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.status.Issue;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public abstract class XMLValidatorDeployer
extends AbstractDeployer {
    public XMLValidatorDeployer(int deploySequenceId) {
        super(deploySequenceId);
    }

    protected boolean validateXmls(List<XMLSourceNode> xmlList, Logger logger, DeployShell deployShell) throws DeployException {
        int DEFAULT_STRING_BUFFER_LEN = 255;
        ArrayList<Issue> errorList = new ArrayList<Issue>();
        boolean allValid = true;
        for (XMLSourceNode currNode : xmlList) {
            logger.finest("Validating " + currNode.getURL().toExternalForm() + " ...");
            if (!McAppUtils.validateXml(deployShell.getContext(), currNode, errorList)) {
                allValid = false;
                String errMessage = MobileResourceUtils.getMsg("ADF-MBL-02001");
                LogRecord logRecord = new LogRecord(Level.SEVERE, errMessage);
                logRecord.setParameters(new Object[]{currNode.getURL()});
                logger.log(logRecord);
                StringBuilder sb = new StringBuilder(255);
                TextBuffer textBuffer = currNode.acquireTextBuffer();
                LineMap lineMap = textBuffer.getLineMap();
                int currErrIdx = 0;
                int listSize = errorList.size();
                for (Issue currError : errorList) {
                    int lineFromOffset = lineMap.getLineFromOffset(currError.getOffset());
                    int line = lineFromOffset + 1;
                    int column = currError.getOffset() - lineMap.getLineStartOffset(lineFromOffset) + 1;
                    String errMsg = MobileResourceUtils.getMsg("ADF-MBL-02019", line, column, currError.getMessage());
                    sb.append("\t");
                    sb.append("\t");
                    sb.append(errMsg);
                    if (++currErrIdx >= listSize) continue;
                    sb.append("\n");
                }
                logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-02020"), sb.toString());
                errorList.clear();
            }
            this.throwExceptionIfCancelEventReceived();
        }
        return allValid;
    }
}

