/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.JSONProfileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.codehaus.jackson.JsonParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SkinsDeployer
extends AbstractDeployer {
    private final DeployFileUtils _deployFileUtils;
    private static final List<String> _jsonProfilesToUpdate = new ArrayList<String>(Arrays.asList("js/profile.json", "js/profile-html.json", "js/profile-login.json"));

    public SkinsDeployer(int deploySequenceId, DeployFileUtils deployFileUtils) {
        super(deploySequenceId);
        this._deployFileUtils = deployFileUtils;
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        Context context = deployShell.getContext();
        Workspace workspace = context.getWorkspace();
        Logger logger = deployShell.getLogger();
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-22003"));
        try {
            URL deployedAppControllerURL = this._deployFileUtils.getApplicationControllerDeployDirURL();
            URL appControllerWebContentURL = URLFactory.newDirURL((URL)deployedAppControllerURL, (String)"public_html");
            URLFileSystem.copy((URL)McAppUtils.getMobileConfigURL(workspace), (URL)this._deployFileUtils.getDeploymentAdfmfConfigURL());
            Project appControllerProject = McAppUtils.getApplicationControllerProject(workspace, logger);
            if (null == appControllerProject) {
                logger.warning(MobileResourceUtils.getMsg("ADF-MBL-12003"));
                return;
            }
            URL deployedADFmfSkinsURL = this._deployFileUtils.getDeploymentAdfmfSkinsURL();
            URLFileSystem.copy((URL)McAppUtils.getSkinsURL(appControllerProject), (URL)deployedADFmfSkinsURL);
            URL skinsFolderURL = McAppUtils.getDefaultSkinsFolderUrl();
            FileUtils.copyDirectoryInclusive(skinsFolderURL, appControllerWebContentURL);
            File skinsDirectory = new File(skinsFolderURL.getPath());
            List<String> styleSheetRelativePathArray = this._findAllStyleSheetsInDir(skinsDirectory, FileUtils.getSupportFilesDirectoryUrl());
            XMLDocument adfmfSkinsDOM = SkinsDeployer._getADFMFSkinsDOM(deployedADFmfSkinsURL);
            Element documentElement = adfmfSkinsDOM.getDocumentElement();
            Element mobileFusionFxElement = this._findOrCreateMobileFusionFxElement(adfmfSkinsDOM, documentElement);
            HashMap<String, String> currentStyleSheets = this._getCurrentStyleSheets(mobileFusionFxElement);
            for (String styleSheet : styleSheetRelativePathArray) {
                if (currentStyleSheets.containsKey(styleSheet)) continue;
                Element newStyleSheetElement = adfmfSkinsDOM.createElementNS("http://xmlns.oracle.com/adf/mf/skin", "style-sheet-name");
                newStyleSheetElement.setTextContent(styleSheet);
                mobileFusionFxElement.appendChild(newStyleSheetElement);
            }
            FileUtils.writeXmlFile((Document)adfmfSkinsDOM, deployedADFmfSkinsURL);
            this._updateJsonProfiles(context, logger);
        }
        catch (Exception e) {
            String errMsg = MobileResourceUtils.getMsg("ADF-MBL-00072", e);
            throw new DeployException(errMsg, (Throwable)e);
        }
    }

    private HashMap<String, String> _getCurrentStyleSheets(Element mobileFusionFxElement) {
        HashMap<String, String> currentStyleSheets = new HashMap<String, String>();
        NodeList currentStyleSheetList = mobileFusionFxElement.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf/skin", "style-sheet-name");
        int count = currentStyleSheetList != null ? currentStyleSheetList.getLength() : 0;
        for (int i = 0; i < count; ++i) {
            Element styleSheetElement = (Element)currentStyleSheetList.item(i);
            String path = styleSheetElement.getTextContent();
            currentStyleSheets.put(path, path);
        }
        return currentStyleSheets;
    }

    private Element _findOrCreateMobileFusionFxElement(XMLDocument adfmfSkinsDOM, Element documentElement) {
        Element mobileFusionFxElement = null;
        NodeList skins = documentElement.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf/skin", "skin");
        int count = skins != null ? skins.getLength() : 0;
        for (int i = 0; i < count; ++i) {
            Element skinElement = (Element)skins.item(i);
            NodeList idNodeList = skinElement.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf/skin", "id");
            assert (idNodeList.getLength() == 1);
            Element idElement = (Element)idNodeList.item(0);
            if (idElement.getTextContent().compareTo("mobileFusionFx") != 0) continue;
            mobileFusionFxElement = skinElement;
        }
        if (null == mobileFusionFxElement) {
            mobileFusionFxElement = this._createMobileFusionFxElement(adfmfSkinsDOM, documentElement);
        }
        return mobileFusionFxElement;
    }

    private Element _createMobileFusionFxElement(XMLDocument xmlDocument, Element documentElement) {
        Element newSkinElement = xmlDocument.createElementNS("http://xmlns.oracle.com/adf/mf/skin", "skin");
        Element newFamilyElement = xmlDocument.createElementNS("http://xmlns.oracle.com/adf/mf/skin", "family");
        newFamilyElement.setTextContent("mobileFusionFx");
        newSkinElement.appendChild(newFamilyElement);
        Element newIdElement = xmlDocument.createElementNS("http://xmlns.oracle.com/adf/mf/skin", "id");
        newIdElement.setTextContent("mobileFusionFx");
        newSkinElement.appendChild(newIdElement);
        documentElement.appendChild(newSkinElement);
        return newSkinElement;
    }

    private List<String> _findAllStyleSheetsInDir(File directory, URL getPathRelativeToURL) {
        if (null == directory || directory.isFile() || null == getPathRelativeToURL) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> styleSheetRelativePathArray = new ArrayList<String>();
        if (!directory.isDirectory()) {
            return styleSheetRelativePathArray;
        }
        List<File> cssLList = this._getFileList(directory);
        for (File cssFile : cssLList) {
            if (!cssFile.isFile()) continue;
            URL cssFileURL = URLFactory.newDirURL((File)cssFile);
            String relativePath = FileUtils.getProjectRelativeFilePath(cssFileURL, getPathRelativeToURL);
            styleSheetRelativePathArray.add(relativePath);
        }
        return styleSheetRelativePathArray;
    }

    private static XMLDocument _getADFMFSkinsDOM(URL adfmfSkinsUrl) throws IOException {
        XMLDocument adfmfSkinsDoc = null;
        InputStream xmlInput = null;
        try {
            xmlInput = adfmfSkinsUrl.openStream();
            DOMParser parser = new DOMParser();
            parser.parse(xmlInput);
            XMLDocument xMLDocument = adfmfSkinsDoc = parser.getDocument();
            return xMLDocument;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            FileUtils.closeStream(xmlInput, null);
        }
    }

    private List<File> _getFileList(File startingDir) {
        ArrayList<File> result = new ArrayList<File>();
        if (null != startingDir && startingDir.exists()) {
            List<File> filesDirs = Arrays.asList(startingDir.listFiles());
            for (File file : filesDirs) {
                result.add(file);
                if (file.isFile()) continue;
                List<File> deeperList = this._getFileList(file);
                result.addAll(deeperList);
            }
        }
        return result;
    }

    private void _updateJsonProfiles(Context context, Logger logger) throws FileNotFoundException, JsonParseException, IOException {
        String configuredSkinVersion = this._getConfiguredSkinVersion(context, logger);
        Map<String, String> skinVersionToAmxFileMap = ADFMobileConstants.SkinVersionToAmxFile.getSkinToAmxFileMap();
        String amxFile = skinVersionToAmxFileMap.get(configuredSkinVersion);
        if (null != amxFile) {
            URL wwwURL = this._deployFileUtils.getApplicationWebContentURL();
            for (String fileName : _jsonProfilesToUpdate) {
                URL jsonProfileFileUrl = URLFactory.newURL((URL)wwwURL, (String)fileName);
                if (!URLFileSystem.exists((URL)jsonProfileFileUrl)) continue;
                JSONProfileUtils.updateJsonProfileListValue(jsonProfileFileUrl, "cssResources", amxFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getConfiguredSkinVersion(Context context, Logger logger) {
        String version = "v1.1";
        Workspace workspace = context.getWorkspace();
        URL mobileConfigUrl = McAppUtils.getMobileConfigURL(workspace);
        JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)context);
        if (null == mobileConfigUrl || null == xmlContext) {
            logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00087"));
            return version;
        }
        XmlModel model = xmlContext.getRelatedXmlModel(mobileConfigUrl);
        if (model != null) {
            model.acquireReadLock();
            try {
                Element rootElement = model.getDocument().getDocumentElement();
                NodeList childNodes = rootElement.getChildNodes();
                if (childNodes != null) {
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node child = childNodes.item(i);
                        if (!"skin-version".equals(child.getLocalName())) continue;
                        version = child.getTextContent();
                    }
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
        return version;
    }
}

