/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.adfmf.common.util.McTechnologyUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.common.deployers.XMLValidatorDeployer;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;

public class ProjectXmlValidatorDeployer
extends XMLValidatorDeployer {
    private final boolean _activeProjectOnly;
    private static final String _CRITERIA_FILTER = ".xml|.amx|.dcx|.xlf|.cpx";

    public ProjectXmlValidatorDeployer(int deploySequenceId, boolean activeProjectOnly) {
        super(deploySequenceId);
        this._activeProjectOnly = activeProjectOnly;
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        boolean allValid;
        block3: {
            ArrayList<Project> projectCollection;
            Logger logger;
            Workspace workspace;
            block2: {
                allValid = true;
                workspace = deployShell.getContext().getWorkspace();
                logger = deployShell.getLogger();
                projectCollection = McTechnologyUtils.getTechnologyProjects(workspace, "ADFMobile");
                if (!this._activeProjectOnly) break block2;
                Project activeProject = workspace.getActiveProject();
                if (null == activeProject || !projectCollection.contains(activeProject)) break block3;
                String msg = MobileResourceUtils.getMsg("ADF-MBL-22001", URLFileSystem.getName((URL)activeProject.getURL()));
                logger.info(msg);
                List<XMLSourceNode> projectNodeListToValidate = this._getProjectXmlSourceNodes(logger, workspace, activeProject);
                if (this.validateXmls(projectNodeListToValidate, logger, deployShell)) break block3;
                allValid = false;
                break block3;
            }
            for (Project currProject : projectCollection) {
                String msg = MobileResourceUtils.getMsg("ADF-MBL-22001", URLFileSystem.getName((URL)currProject.getURL()));
                logger.info(msg);
                List<XMLSourceNode> projectNodeListToValidate = this._getProjectXmlSourceNodes(logger, workspace, currProject);
                if (this.validateXmls(projectNodeListToValidate, logger, deployShell)) continue;
                allValid = false;
            }
        }
        if (!allValid) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02000"));
        }
    }

    private List<XMLSourceNode> _getProjectXmlSourceNodes(Logger logger, Workspace workspace, Project project) throws DeployException {
        QueryCriteria criteria = new QueryCriteria();
        criteria.put((Object)"file.extension", (Object)_CRITERIA_FILTER);
        return DeployFileUtils.getProjectXmlSourceNodesFromIndex(workspace, project, criteria, logger);
    }
}

