/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers;

import java.util.List;
import java.util.logging.Logger;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.ProjectUtils;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public class ProjectValidatorDeployer
extends AbstractDeployer {
    public ProjectValidatorDeployer(int deploySequenceId) {
        super(deploySequenceId);
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        Workspace workspace = deployShell.getContext().getWorkspace();
        Logger logger = deployShell.getLogger();
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-22010"));
        if (!ProjectUtils.validateAppControllerProjectDependencies(workspace, logger)) {
            String applicationControllerFolderName = McAppUtils.getApplicationControllerFolderName(workspace);
            String errMsg = MobileResourceUtils.getMsg("ADF-MBL-02022", applicationControllerFolderName);
            throw new DeployException(errMsg);
        }
        List<Project> featureProjectList = McAppUtils.findProjectsWithFeatures(workspace);
        for (Project project : featureProjectList) {
            if (ProjectUtils.hasValidDependencies(project, featureProjectList)) continue;
            String viewControllerName = project.getShortLabel();
            String errMsg = MobileResourceUtils.getMsg("ADF-MBL-02023", viewControllerName);
            throw new DeployException(errMsg);
        }
    }
}

