/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public class JavaScriptDeployer
extends AbstractDeployer {
    private final DeployFileUtils _deployFileUtils;

    public JavaScriptDeployer(int deploySequenceId, DeployFileUtils deployFileUtils) {
        super(deploySequenceId);
        this._deployFileUtils = deployFileUtils;
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        Logger logger = deployShell.getLogger();
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-22005"));
        try {
            URL javascriptSourceURL = this._deployFileUtils.getJavaScriptSourceZipURL();
            this.copyJavaScriptDir(javascriptSourceURL);
            URL dependantJavascriptSourceURL = this._deployFileUtils.getPlatformSpecificJavaScriptSourceZipURL();
            this.copyJavaScriptDir(dependantJavascriptSourceURL);
        }
        catch (Exception e) {
            String errMsg = MobileResourceUtils.getMsg("ADF-MBL-00083");
            throw new DeployException(errMsg, (Throwable)e);
        }
    }

    private void copyJavaScriptDir(URL javascriptSourceURL) throws IOException {
        URL javascriptTemplateSourceURL = URLFactory.newDirURL((URL)javascriptSourceURL, (String)"Template");
        URL javascriptWWWSourceURL = URLFactory.newDirURL((URL)javascriptTemplateSourceURL, (String)"www");
        URL javascriptDestinationURL = this._deployFileUtils.getApplicationWebContentURL();
        FileUtils.copyDirectory(javascriptWWWSourceURL, javascriptDestinationURL);
    }
}

