/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.McProfile;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.common.AbstractDeployer;
import oracle.jdeveloper.deploy.shell.JavaDeployment;

public class FarExtractorDeployer
extends AbstractDeployer {
    private final URL _FAR_EXTRACTION_LOCATION;
    private static final String[] _UNWANTED_FILES = new String[]{"META-INF/jar-connections.xml", "META-INF/jar-adf-config.xml"};

    public FarExtractorDeployer(int deploySequence, URL templateTargetUrl) {
        super(deploySequence);
        this._FAR_EXTRACTION_LOCATION = URLFactory.newDirURL((URL)templateTargetUrl, (String)"FARs");
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        Logger logger = deployShell.getLogger();
        try {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-20021");
            logger.info(msg);
            Workspace activeWorkspace = deployShell.getContext().getWorkspace();
            JavaDeployment d = JavaDeployment.getInstance((DeployShell)deployShell);
            Profile deployingProfile = d.getProfile();
            assert (deployingProfile instanceof McProfile);
            McProfile appProfile = (McProfile)deployingProfile;
            URL appControllerFarUrl = DeployFileUtils.getApplicationControllerFarUrl(activeWorkspace, appProfile, logger);
            if (null != appControllerFarUrl) {
                this._extractFar(appControllerFarUrl, McAppUtils.getApplicationControllerFolderName(activeWorkspace), logger);
            }
            List<URL> farUrlList = DeployFileUtils.getViewControllerAndFarUrlList(activeWorkspace, appProfile);
            for (URL currFarUrl : farUrlList) {
                String farFolderName = URLFileSystem.getName((URL)currFarUrl);
                this._extractFar(currFarUrl, farFolderName, logger);
            }
        }
        catch (Exception e) {
            DeployException de = null;
            if (!(e instanceof DeployException)) {
                String msg = MobileResourceUtils.getMsg("ADF-MBL-00061", e);
                de = new DeployException(msg, (Throwable)e);
            } else {
                de = (DeployException)((Object)e);
            }
            throw de;
        }
    }

    private void _removeUnneccessaryContent(URL destinationURL, Logger logger) {
        for (String fileName : _UNWANTED_FILES) {
            URL absoluteFileURL = URLFactory.newDirURL((URL)destinationURL, (String)fileName);
            File file = new File(absoluteFileURL.getPath());
            if (!file.exists() || file.delete()) continue;
            logger.finest("File not removed from FAR: " + file.getName());
        }
    }

    private void _extractFar(URL farJarUrl, String farDestinationFolderName, Logger logger) throws DeployException, IOException {
        if (ModelUtil.hasLength((String)farDestinationFolderName)) {
            LogRecord logRecord = new LogRecord(Level.INFO, MobileResourceUtils.getMsg("ADF-MBL-20022"));
            if (logger.isLoggable(Level.FINEST)) {
                logRecord.setLevel(Level.FINEST);
                logRecord.setParameters(new Object[]{farJarUrl, farDestinationFolderName});
            } else {
                logRecord.setParameters(new Object[]{URLFileSystem.getFileName((URL)farJarUrl), farDestinationFolderName});
            }
            logger.log(logRecord);
            URL destinationURL = URLFactory.newDirURL((URL)this._FAR_EXTRACTION_LOCATION, (String)farDestinationFolderName);
            try {
                FileUtils.unZipFile(farJarUrl, destinationURL);
                this.throwExceptionIfCancelEventReceived();
                this._removeUnneccessaryContent(destinationURL, logger);
                this.throwExceptionIfCancelEventReceived();
            }
            catch (FileNotFoundException e) {
                logger.warning(e.getMessage());
            }
        }
    }
}

