/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.DeploymentCustomizationAdapter;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public class CustomizeContentDeployer
extends AbstractDeployer {
    private final DeployFileUtils _deployFileUtils;

    public CustomizeContentDeployer(int deploySequence, DeployFileUtils deployFileUtils) {
        super(deploySequence);
        if (null == deployFileUtils) {
            throw new IllegalArgumentException("Argument deployFileUtils is null.");
        }
        this._deployFileUtils = deployFileUtils;
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        try {
            Logger logger = deployShell.getLogger();
            if (logger.getLevel() == Level.FINEST) {
                logger.log(Level.FINEST, "Deploy customized content as needed.");
            }
            Workspace workspace = deployShell.getContext().getWorkspace();
            URL farExtractionLocation = this._deployFileUtils.getDeploymentFARsURL();
            DeploymentCustomizationAdapter custAdapter = new DeploymentCustomizationAdapter(farExtractionLocation, workspace, logger);
            custAdapter.customize();
        }
        catch (Exception e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-02021");
            throw new DeployException(msg, (Throwable)e);
        }
    }
}

