/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.common.deployers.XMLValidatorDeployer;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.model.ApplicationContent;

public class ApplicationXmlValidatorDeployer
extends XMLValidatorDeployer {
    public ApplicationXmlValidatorDeployer(int deploySequenceId) {
        super(deploySequenceId);
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        Workspace workspace = deployShell.getContext().getWorkspace();
        Logger logger = deployShell.getLogger();
        String msg = MobileResourceUtils.getMsg("ADF-MBL-22000");
        logger.info(msg);
        List<XMLSourceNode> applicationXmlList = this._getApplicationXmlSourceNodes(workspace);
        if (!this.validateXmls(applicationXmlList, logger, deployShell)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02000"));
        }
    }

    private List<XMLSourceNode> _getApplicationXmlSourceNodes(Workspace workspace) {
        ArrayList<XMLSourceNode> xmlFileList = new ArrayList<XMLSourceNode>();
        ApplicationContent appContent = ApplicationContent.getInstance((Workspace)workspace);
        xmlFileList.addAll(this._getApplicationDescriptors(appContent, appContent.getApplicationMetaInfURL()));
        xmlFileList.addAll(this._getApplicationDescriptors(appContent, appContent.getADFMetaInfURL()));
        return xmlFileList;
    }

    private List<XMLSourceNode> _getApplicationDescriptors(ApplicationContent appContent, URL appUrl) {
        ArrayList<XMLSourceNode> xmlFileList = new ArrayList<XMLSourceNode>();
        Iterator descriptorIter = appContent.getDescriptors(appUrl);
        if (null != descriptorIter) {
            while (descriptorIter.hasNext()) {
                Object currObject = descriptorIter.next();
                if (!(currObject instanceof XMLSourceNode)) continue;
                xmlFileList.add((XMLSourceNode)currObject);
            }
        }
        return xmlFileList;
    }
}

