/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public class ApplicationValidatorDeployer
extends AbstractDeployer {
    public ApplicationValidatorDeployer(int deploySequenceId) {
        super(deploySequenceId);
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        Workspace workspace = deployShell.getContext().getWorkspace();
        Logger logger = deployShell.getLogger();
        this._verifyApplicationAdfFolderExists(workspace, logger);
        this.throwExceptionIfCancelEventReceived();
        this._verifyApplicationControllerExists(workspace, logger);
        this.throwExceptionIfCancelEventReceived();
        this._verifyApplicationDependencies(workspace, logger);
    }

    private void _verifyApplicationAdfFolderExists(Workspace workspace, Logger logger) throws DeployException {
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-22009"));
        try {
            McAppUtils.getApplicationAdfFolderUrl(workspace);
        }
        catch (FileNotFoundException e) {
            throw new DeployException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new DeployException((Throwable)e);
        }
    }

    private void _verifyApplicationControllerExists(Workspace workspace, Logger logger) throws DeployException {
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-22004"));
        Project appControllerProject = McAppUtils.getApplicationControllerProject(workspace, logger);
        if (null == appControllerProject) {
            String errMsg = MobileResourceUtils.getMsg("ADF-MBL-00079");
            throw new DeployException(errMsg);
        }
    }

    private void _verifyApplicationDependencies(Workspace workspace, Logger logger) {
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-22007"));
        List<URL> applicationLibraryJarUrlList = McAppUtils.getApplicationLibraryJarUrls(workspace);
        ArrayList<URL> missingJarUrlList = new ArrayList<URL>();
        for (URL currJarUrl : applicationLibraryJarUrlList) {
            if (URLFileSystem.exists((URL)currJarUrl) || missingJarUrlList.contains(currJarUrl)) continue;
            missingJarUrlList.add(currJarUrl);
        }
        if (!missingJarUrlList.isEmpty()) {
            StringBuilder missingDependenciesBuilder = new StringBuilder();
            int currListIdx = 0;
            for (URL currJarUrl : missingJarUrlList) {
                missingDependenciesBuilder.append(URLFileSystem.getPlatformPathName((URL)currJarUrl));
                if (currListIdx < missingJarUrlList.size() - 1) {
                    missingDependenciesBuilder.append("\n");
                }
                ++currListIdx;
            }
            String warnMsg = MobileResourceUtils.getMsg("ADF-MBL-12004", missingDependenciesBuilder.toString());
            logger.warning(warnMsg);
        }
    }
}

