/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.common.deployers;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.common.AbstractDeployer;
import oracle.jdeveloper.deploy.common.BatchDeployer;
import oracle.jdeveloper.deploy.shell.ShellAdapter;
import oracle.jdeveloper.deploy.spi.ProgressEvent;
import oracle.jdeveloper.deploy.spi.ProgressListener;
import oracle.jdeveloper.deploy.spi.ProgressObject;

public class AbstractDeployerWrapper
extends AbstractDeployer
implements ProgressListener {
    private final AbstractDeployer _deployer;
    private final Logger _logger;
    private final Level _logLevel;
    private boolean _deploymentCancelMsgLogged = false;
    private final int _deploySequenceId;

    public static boolean isDeployerWrappable(Deployer deployer) {
        return null != deployer && deployer instanceof AbstractDeployer && !(deployer instanceof BatchDeployer);
    }

    public static AbstractDeployerWrapper newInstance(int deploySequenceId, Logger logger, Deployer deployer) {
        if (!AbstractDeployerWrapper.isDeployerWrappable(deployer)) {
            throw new IllegalArgumentException();
        }
        return new AbstractDeployerWrapper(deploySequenceId, logger, deployer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(int deploySequenceId, DeployShell deployShell) throws DeployException {
        ProgressObject progressObject = null;
        try {
            progressObject = this._addProgressListener(deployShell);
            this._deployer.prepare(deploySequenceId, deployShell);
        }
        finally {
            this._removeProgressListener(progressObject);
            this._restoreLogging();
        }
    }

    public void cancel(int deploySequenceId, DeployShell deployShell) {
        this._deployer.cancel(deploySequenceId, deployShell);
        this._restoreLogging();
    }

    public void finish(int deploySequenceId, DeployShell deployShell) {
        this._deployer.finish(deploySequenceId, deployShell);
        this._restoreLogging();
    }

    public synchronized void handleEvent(ProgressEvent dpe) {
        super.handleEvent(dpe);
        if (dpe.getType().equals(ProgressEvent.CANCEL_EVENT_TYPE) && !this._deploymentCancelMsgLogged) {
            this._logger.severe(MobileResourceUtils.getMsg("ADF-MBL-21003"));
            this._deploymentCancelMsgLogged = true;
            this._turnOffLogging();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(int deploySequenceId, DeployShell deployShell) throws DeployException {
        ProgressObject progressObject = null;
        try {
            progressObject = this._addProgressListener(deployShell);
            this._deployer.deploy(this._deployer.getSequenceId(), deployShell);
            this._deployer.throwExceptionIfCancelEventReceived();
        }
        finally {
            this._removeProgressListener(progressObject);
            this._restoreLogging();
        }
    }

    public void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
    }

    private ProgressObject _addProgressListener(DeployShell deployShell) {
        ProgressObject progressObject = ShellAdapter.getInstance((DeployShell)deployShell).getDeploymentProgressObject();
        if (null != progressObject) {
            progressObject.addProgressListener((ProgressListener)this);
        }
        return progressObject;
    }

    private void _removeProgressListener(ProgressObject progressObject) {
        if (null != progressObject) {
            progressObject.removeProgressListener((ProgressListener)this);
        }
    }

    private void _restoreLogging() {
        this._logger.setLevel(this._logLevel);
    }

    private void _turnOffLogging() {
        this._logger.setLevel(Level.OFF);
    }

    protected AbstractDeployerWrapper(int deploySequenceId, Logger logger, Deployer deployer) {
        super(deploySequenceId);
        assert (deployer instanceof AbstractDeployer);
        this._deploySequenceId = deploySequenceId;
        this._deployer = (AbstractDeployer)deployer;
        this._logger = logger;
        this._logLevel = logger.getLevel();
    }
}

