/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.cmdline.spi.command;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.cmdline.util.OJDeployUtils;
import oracle.adfmf.framework.dt.deploy.features.FeatureArchiveProfile;
import oracle.adfmf.framework.dt.deploy.features.ui.wizard.commands.FeatureArchiveCommand;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.DeploymentOptions;
import oracle.jdeveloper.deploy.JavaDeploymentOptions;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.cmdline.DefaultOJCommandUsage;
import oracle.jdeveloper.deploy.cmdline.OJCommand;
import oracle.jdeveloper.deploy.cmdline.OJCommandCreationException;
import oracle.jdeveloper.deploy.cmdline.OJCommandModel;
import oracle.jdeveloper.deploy.cmdline.OJCommandUsage;
import oracle.jdeveloper.deploy.cmdline.OJContextCreationException;
import oracle.jdeveloper.deploy.cmdline.OJContextIterator;
import oracle.jdeveloper.deploy.cmdline.spi.ProfileContextIterator;
import oracle.jdeveloper.deploy.cmdline.spi.ProjectContextIterator;
import oracle.jdeveloper.deploy.cmdline.spi.ValueExpander;
import oracle.jdeveloper.deploy.cmdline.spi.WorkspaceContextIterator;
import oracle.jdeveloper.deploy.cmdline.spi.command.AbstractCommandSupport;
import oracle.jdeveloper.deploy.spi.Cookie;

public final class FeatureArchiveCommandSupport
extends AbstractCommandSupport {
    public FeatureArchiveCommandSupport(OJCommand ojCommand, Cookie cookie) {
        super(ojCommand, cookie);
    }

    protected OJCommandUsage getCommandUsage() {
        DefaultOJCommandUsage usage = new DefaultOJCommandUsage(this.getCommand());
        usage.setShortDesc(OJDeployUtils.getText("OJDEPLOY_TO_FEATURE_ARCHIVE_SHORT_DESCRIPTION"));
        usage.setLongDesc(OJDeployUtils.getText("OJDEPLOY_FEATURE_ARCHIVE_USAGE"));
        return usage;
    }

    public OJContextIterator getContextIterator(OJContextIterator parentIterator, OJCommandModel model, Logger logger) {
        ArrayList<String> requiredArgOptionList = new ArrayList<String>();
        requiredArgOptionList.add("workspace");
        requiredArgOptionList.add("project");
        requiredArgOptionList.add("profile");
        if (!OJDeployUtils.isOjCommandModelValid(model, requiredArgOptionList)) {
            String requiredOptions = String.format("%s, %s, %s", "workspace", "project", "profile");
            throw new OJContextCreationException(MobileResourceUtils.getMsg("ADF-MBL-03002", requiredOptions));
        }
        WorkspaceContextIterator contextIterator = new WorkspaceContextIterator(parentIterator, model, logger);
        contextIterator = new ProjectContextIterator((OJContextIterator)contextIterator, model, logger);
        contextIterator = new ProfileContextIterator((OJContextIterator)contextIterator, model, logger);
        return contextIterator;
    }

    protected DeployCommand createCommand(OJCommandModel model, ValueExpander valueExpander, Context context) {
        FeatureArchiveCommand deployCmd = null;
        Element e = context.getElement();
        if (!(e instanceof FeatureArchiveProfile)) {
            throw new OJCommandCreationException(MobileResourceUtils.getMsg("ADF-MBL-03001"));
        }
        deployCmd = new FeatureArchiveCommand();
        deployCmd.setContext(context);
        deployCmd.setDeploymentOptions(this._getDeploymentOptions(model));
        return deployCmd;
    }

    private DeploymentOptions _getDeploymentOptions(OJCommandModel model) {
        JavaDeploymentOptions options = (JavaDeploymentOptions)DeploymentOptions.getDefault(JavaDeploymentOptions.class);
        options.setCleanBeforeCompile(model.isPresent("clean"));
        return options;
    }

    protected Map<String, Object> getSupportedOptions() {
        Map optionMap = super.getSupportedOptions();
        optionMap.put("clean", null);
        return optionMap;
    }
}

