/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.cmd;

import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.McProfile;
import oracle.adfmf.framework.dt.deploy.cmd.AppProfileDeployCmdState;
import oracle.adfmf.framework.dt.deploy.features.FeatureArchiveProfile;
import oracle.adfmf.framework.dt.deploy.features.FeatureArchiveProfileFactory;
import oracle.ide.Context;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.cmd.ProfileDeployCmd;
import oracle.jdeveloper.deploy.cmd.ProfileDeployCmdState;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.shell.JavaDeployment;
import oracle.jdeveloper.deploy.shell.ShellAdapter;

public abstract class McAppProfileDeployCommand
extends ProfileDeployCmd {
    public McAppProfileDeployCommand(HashStructure hashStructure) {
        super(hashStructure);
    }

    public McAppProfileDeployCommand(int cmdId, int type, int sequence) {
        super(cmdId, type, sequence);
    }

    protected void prepare(DeployShell deployShell) {
        super.prepare(deployShell);
        this._maybeCreateProjectFars(deployShell);
    }

    public void setContext(Context context) {
        ProfileDeployCmdState cmdState = this.state();
        assert (cmdState instanceof AppProfileDeployCmdState);
        AppProfileDeployCmdState mobileAppCmdState = (AppProfileDeployCmdState)cmdState;
        Workspace workspace = context.getWorkspace();
        assert (workspace != null);
        URL workspaceURL = workspace.getURL();
        mobileAppCmdState.setDataContainerUrl(workspaceURL);
        super.setContext(context);
        Profile profile = this.getProfile();
        ShellAdapter.getInstance((Context)context).setDeployElement((Element)profile);
    }

    private void _maybeCreateProjectFars(DeployShell deployShell) {
        Logger logger = deployShell.getLogger();
        McProfile appProfile = this.getApplicationProfile(deployShell);
        List<FeatureArchiveProfile> farList = DeployFileUtils.getDependentFarProfiles(appProfile);
        if (!farList.isEmpty()) {
            return;
        }
        Platform platform = this.getPlatform();
        assert (null != platform);
        String profilePlatformLabel = "";
        if (null != platform) {
            profilePlatformLabel = platform.getLongLabel();
        }
        assert (null != platform);
        String msg = MobileResourceUtils.getMsg("ADF-MBL-20023", profilePlatformLabel);
        logger.info(msg);
        Workspace activeWorkspace = deployShell.getContext().getWorkspace();
        FeatureArchiveProfileFactory farProfileFactory = new FeatureArchiveProfileFactory();
        this.addFeatureProjectsAsDependency(appProfile, activeWorkspace, deployShell.getContext(), farProfileFactory);
        this.addApplicationControllProjectAsDependency(appProfile, activeWorkspace, deployShell.getContext(), farProfileFactory);
    }

    private final McProfile getApplicationProfile(DeployShell deployShell) {
        assert (deployShell != null);
        JavaDeployment d = JavaDeployment.getInstance((DeployShell)deployShell);
        Profile profile = d.getProfile();
        assert (profile != null);
        assert (profile instanceof McProfile);
        return (McProfile)profile;
    }

    private void addFeatureProjectsAsDependency(McProfile appProfile, Workspace workspace, Context context, FeatureArchiveProfileFactory farProfileFactory) {
        List<Project> workspaceAdfmfProjects = McAppUtils.findProjectsWithFeatures(workspace);
        for (Project currProject : workspaceAdfmfProjects) {
            ArchiveProfile currFarProfile = farProfileFactory.create(DeployFileUtils.createProjectFarName(currProject), (DataContainer)currProject, context);
            assert (currFarProfile instanceof FeatureArchiveProfile);
            DeployFileUtils.addArchiveProfileAsDependency(appProfile, currFarProfile);
        }
    }

    private void addApplicationControllProjectAsDependency(McProfile appProfile, Workspace workspace, Context context, FeatureArchiveProfileFactory farProfileFactory) {
        String appControllerFolderName = McAppUtils.getApplicationControllerFolderName(workspace);
        Project appControllerProject = McAppUtils.findApplicationControllerProject(workspace, null, appControllerFolderName);
        if (null != appControllerProject) {
            ArchiveProfile currFarProfile = farProfileFactory.create(appControllerFolderName, (DataContainer)appControllerProject, context);
            assert (currFarProfile instanceof FeatureArchiveProfile);
            DeployFileUtils.addArchiveProfileAsDependency(appProfile, currFarProfile);
        }
    }
}

