/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.applicationarchive.ui.wizard.spi;

import java.net.URL;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.applicationarchive.ApplicationArchiveProfile;
import oracle.adfmf.framework.dt.deploy.applicationarchive.ui.wizard.commands.ApplicationArchiveCommand;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.dt.wizard.spi.AbstractDeploySummaryProvider;
import oracle.jdeveloper.deploy.jar.ArchiveOptions;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public class DeploySummaryBuilder
extends AbstractDeploySummaryProvider {
    private Workspace _workspace;

    protected boolean shouldCreateFor(DeployCommand deployCommand, ToolkitContext context, Cookie cookie) {
        if (deployCommand instanceof ApplicationArchiveCommand) {
            this._workspace = context.getIdeContext().getWorkspace();
            return true;
        }
        return false;
    }

    public Class getTypeForNarrow() {
        return ApplicationArchiveProfile.class;
    }

    protected TreeNode buildSummary(DeployCommand deployCommand, TraversableContext tc, Cookie cookie) {
        assert (deployCommand instanceof ApplicationArchiveCommand);
        ApplicationArchiveCommand mobileDeployCmd = (ApplicationArchiveCommand)deployCommand;
        Profile profile = mobileDeployCmd.getProfile();
        assert (profile instanceof ApplicationArchiveProfile);
        ApplicationArchiveProfile appArchiveProfile = (ApplicationArchiveProfile)profile;
        String applicationArchiveSummaryDetails = MobileResourceUtils.getText("APPLICATION_ARCHIVE_DEPLOY_SUMMARY_APPLICATION_DETAIL_DESCRIPTION");
        DefaultMutableTreeNode appDetail = new DefaultMutableTreeNode(applicationArchiveSummaryDetails);
        if (null != appArchiveProfile && null != this._workspace) {
            try {
                ArchiveOptions archiveOptions = appArchiveProfile.getArchiveOptions();
                String deployFileName = MobileResourceUtils.getText("DEPLOY_SUMMARY_FILE_DESCRIPTION", URLFileSystem.getFileName((URL)appArchiveProfile.getJarURL()));
                appDetail.add(new DefaultMutableTreeNode(deployFileName));
                String includeManifest = null;
                includeManifest = MobileResourceUtils.getText("APPLICATION_ARCHIVE_DEPLOY_SUMMARY_INCLUDE_MANIFEST_NO");
                if (archiveOptions.getHasManifest()) {
                    includeManifest = MobileResourceUtils.getText("APPLICATION_ARCHIVE_DEPLOY_SUMMARY_INCLUDE_MANIFEST_YES");
                }
                appDetail.add(new DefaultMutableTreeNode(includeManifest));
                String compressedInfo = MobileResourceUtils.getText("APPLICATION_ARCHIVE_DEPLOY_SUMMARY_INCLUDE_COMPRESSED_NO");
                if (archiveOptions.isCompressed()) {
                    compressedInfo = MobileResourceUtils.getText("APPLICATION_ARCHIVE_DEPLOY_SUMMARY_INCLUDE_COMPRESSED_YES");
                }
                appDetail.add(new DefaultMutableTreeNode(compressedInfo));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return appDetail;
    }
}

