/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.applicationarchive.ui.wizard.commands;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.applicationarchive.ApplicationArchiveProfile;
import oracle.adfmf.framework.dt.deploy.applicationarchive.deployers.ApplicationArchiveDeployerFactory;
import oracle.adfmf.framework.dt.deploy.applicationarchive.deployers.ApplicationArchiveFileUtils;
import oracle.adfmf.framework.dt.deploy.applicationarchive.ui.wizard.commands.ApplicationArchiveCommandState;
import oracle.adfmf.framework.dt.deploy.cmd.AppProfileDeployCmdState;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.cmd.DeployCommandState;
import oracle.jdeveloper.deploy.cmd.ProfileDeployCmd;
import oracle.jdeveloper.deploy.cmd.ProfileDeployCmdState;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.FileGroups;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.SelectionRule;
import oracle.jdeveloper.deploy.common.SelectionRules;
import oracle.jdeveloper.deploy.jar.ArchiveOptions;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.jar.spi.ArchiveProfileFactory;
import oracle.jdeveloper.deploy.shell.JavaDeployment;
import oracle.jdeveloper.deploy.shell.ShellAdapter;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;

public class ApplicationArchiveCommand
extends ProfileDeployCmd {
    public static final String CMDNAME_DEPLOY_TO_MAA = "Command.ApplicationArchive";
    private static final int _CMDID_DEPLOY_TO_APP_ARCHIVE = Ide.findOrCreateCmdID((String)"Command.ApplicationArchive");
    private static final String _JAVA_FILE_PATTERN = "**/**.java";
    private static final String _CLASS_FILE_PATTERN = "**/**.class";
    private static final String _DATA_FOLDER_PATTERN = "**/**.data";
    private static final String _ALL_FILES_PATTERN = "**";
    private static final String _FILTER_PATTERN_WILD_CARD_PREFIX = "**/";
    private static final String _FILTER_PATTERN_WILD_CARD_SUFFIX = "/**";
    private static final String _JAVA_FILE_EXT = ".java";
    private static final String _CLASS_FILE_EXT = ".class";
    private static final String _PROJECT_SOURCE_PACKAGING_FILE_GROUP_NAME = "projectsource";
    private static final String _PROJECT_CLASS_PACKAGING_FILE_GROUP_NAME = "projectclasses";
    private static final String _APP_SOURCE_PACKAGING_FILE_GROUP_NAME = "applicationsource";
    private static final String _PROJECT_EXTERNAL_LIBS_PACKAGING_FILE_GROUP_NAME = "externallibs";
    private static final String _PROJECT_EXTERNAL_JAR_DIR_NAME = "ExternalLibs";

    public ApplicationArchiveCommand() {
        super(_CMDID_DEPLOY_TO_APP_ARCHIVE, 2, ApplicationArchiveDeployerFactory.getApplicationArchiveDeploymentSequenceId());
    }

    public ApplicationArchiveCommand(HashStructure hashStructure) {
        super(hashStructure);
    }

    public ApplicationArchiveCommand(int cmdId, int type, int sequence) {
        super(cmdId, type, sequence);
    }

    public String getShortLabel() {
        return MobileResourceUtils.getText("APPLICATION_ARCHIVE_DEPLOY_TO_APPLICATION_ARCHIVE_LABEL", this.getProfileName());
    }

    public void setContext(Context context) {
        ProfileDeployCmdState cmdState = this.state();
        assert (cmdState instanceof AppProfileDeployCmdState);
        AppProfileDeployCmdState mobileAppCmdState = (AppProfileDeployCmdState)cmdState;
        Workspace workspace = context.getWorkspace();
        assert (workspace != null);
        URL workspaceURL = workspace.getURL();
        mobileAppCmdState.setDataContainerUrl(workspaceURL);
        super.setContext(context);
        Profile profile = this.getProfile();
        ShellAdapter.getInstance((Context)context).setDeployElement((Element)profile);
    }

    protected Class<? extends DeployCommandState> getStateClass() {
        return ApplicationArchiveCommandState.class;
    }

    protected void prepare(DeployShell deployShell) {
        super.prepare(deployShell);
        JavaDeployment d = JavaDeployment.getInstance((DeployShell)deployShell);
        Profile profile = d.getProfile();
        assert (profile != null);
        assert (profile instanceof ApplicationArchiveProfile);
        ApplicationArchiveProfile appProfile = (ApplicationArchiveProfile)profile;
        this._updateApplicationProfile(appProfile, deployShell.getContext());
        this._createProjectJarFileProfiles(appProfile, deployShell.getContext());
        ShellAdapter.getInstance((Context)this.getContext()).setDeployElement((Element)appProfile);
    }

    private void _createProjectJarFileProfiles(ApplicationArchiveProfile appProfile, Context context) {
        ArchiveProfileFactory archiveProfileFactory = new ArchiveProfileFactory();
        Workspace workspace = context.getWorkspace();
        ApplicationArchiveFileUtils fileUtils = new ApplicationArchiveFileUtils(workspace, appProfile);
        for (Project currProject : workspace.projects()) {
            ArchiveProfile currArchiveProfile = this._createNewArchiveProfileForProjectJar(appProfile, currProject, context, archiveProfileFactory);
            if (fileUtils.doesProjectContainJavaFiles(currProject)) {
                this._createClassJarFileProfile(currProject, fileUtils, currArchiveProfile, archiveProfileFactory, context);
            }
            DeployFileUtils.addArchiveProfileAsDependency(appProfile, currArchiveProfile);
        }
    }

    private void _createClassJarFileProfile(Project project, ApplicationArchiveFileUtils fileUtils, ArchiveProfile projectProfile, ArchiveProfileFactory archiveProfileFactory, Context context) {
        String CLASS_PROFILE_NAME_SUFFIX = "classes";
        String profileName = String.format("%s%s", fileUtils.getProjectFolderName(project), "classes");
        ArchiveProfile classesOnlyProfile = archiveProfileFactory.create(profileName, (DataContainer)project, context);
        URL classJarOutputUrl = fileUtils.getClassJarUrl(project);
        classesOnlyProfile.setJarURL(classJarOutputUrl);
        this._setHasManifest(classesOnlyProfile, false);
        this._setClassesOnlyFilter(classesOnlyProfile);
        this._addClassJarFileGroupToProject(project, projectProfile, classesOnlyProfile, fileUtils);
        DeployFileUtils.addArchiveProfileAsDependency(projectProfile, classesOnlyProfile);
    }

    private ArchiveProfile _createNewArchiveProfileForProjectJar(ApplicationArchiveProfile appProfile, Project project, Context context, ArchiveProfileFactory archiveProfileFactory) {
        ApplicationArchiveFileUtils fileUtils = new ApplicationArchiveFileUtils(context.getWorkspace(), appProfile);
        String profileName = fileUtils.getProjectFolderName(project);
        ArchiveProfile archiveProfile = archiveProfileFactory.create(profileName, (DataContainer)project, context);
        URL projectJarOutputUrl = fileUtils.getProjectJarUrl(project);
        archiveProfile.setJarURL(projectJarOutputUrl);
        this._setProjectFilter(project, archiveProfile, fileUtils);
        this._setHasManifest(archiveProfile, false);
        this._maybeAddExternalLibFileGroup(project, archiveProfile, fileUtils);
        return archiveProfile;
    }

    private void _setProjectFilter(Project project, ArchiveProfile archiveProfile, ApplicationArchiveFileUtils fileUtils) {
        ArrayList<String> includePatternList = new ArrayList<String>();
        ArrayList<String> excludePatternList = new ArrayList<String>();
        excludePatternList.addAll(this._getDeployFolderPattern(archiveProfile, fileUtils));
        excludePatternList.addAll(this._getClassesFolderPattern(project, fileUtils));
        excludePatternList.add(_JAVA_FILE_PATTERN);
        excludePatternList.add(_CLASS_FILE_PATTERN);
        excludePatternList.add(_DATA_FOLDER_PATTERN);
        ArrayList<String> includePatternIgnoreList = new ArrayList<String>();
        includePatternIgnoreList.add(_JAVA_FILE_EXT);
        includePatternIgnoreList.add(_CLASS_FILE_EXT);
        URL projectRootFolderUrl = fileUtils.getProjectRootFolderUrl(project);
        PackagingFileGroup folderPackagingGroup = new PackagingFileGroup(_PROJECT_SOURCE_PACKAGING_FILE_GROUP_NAME, _PROJECT_SOURCE_PACKAGING_FILE_GROUP_NAME);
        Contributor folderContributor = new Contributor(1, projectRootFolderUrl);
        folderPackagingGroup.addContributor(folderContributor);
        folderPackagingGroup.setFilters(SelectionRules.newDefaultSelectionRules());
        SelectionRules newSelectionRules = this._createSelectionRulesFromExisting(folderPackagingGroup.getFilters(), includePatternList, excludePatternList, includePatternIgnoreList);
        folderPackagingGroup.setFilters(newSelectionRules);
        FileGroups newFileGroups = new FileGroups();
        newFileGroups.addFileGroup((FileGroup)folderPackagingGroup);
        archiveProfile.setFileGroups(newFileGroups);
    }

    private SelectionRules _createSelectionRulesFromExisting(SelectionRules selectionRules, List<String> includePatternList, List<String> excludePatternList, List<String> includePatternIgnoreList) {
        SelectionRule[] rulesArray;
        SelectionRules newSelectionRules = new SelectionRules();
        for (String currPattern : includePatternList) {
            newSelectionRules.addInclude(currPattern, true);
        }
        if (null != selectionRules && null != (rulesArray = selectionRules.getRules())) {
            for (int i = 0; i < rulesArray.length; ++i) {
                SelectionRule currSelectionRule = rulesArray[i];
                String currPattern = currSelectionRule.getPattern();
                boolean match = false;
                if (0 == currSelectionRule.getType()) {
                    for (String currIgnorePattern : includePatternIgnoreList) {
                        if (!currPattern.equals(currIgnorePattern) && !currPattern.endsWith(currIgnorePattern)) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    newSelectionRules.addInclude(currPattern, true);
                    continue;
                }
                newSelectionRules.addExclude(currPattern, true);
            }
        }
        for (String currPattern : excludePatternList) {
            newSelectionRules.addExclude(currPattern, true);
        }
        return newSelectionRules;
    }

    private void _setClassesOnlyFilter(ArchiveProfile archiveProfile) {
        PackagingFileGroup outputFileGroup;
        ArrayList<String> includePatternList = new ArrayList<String>();
        includePatternList.add(_CLASS_FILE_PATTERN);
        ArrayList<String> excludePatternList = new ArrayList<String>();
        ArrayList<String> includePatternIgnoreList = new ArrayList<String>();
        includePatternIgnoreList.add(_JAVA_FILE_EXT);
        includePatternIgnoreList.add(_ALL_FILES_PATTERN);
        FileGroups currFileGroups = archiveProfile.getFileGroups();
        if (currFileGroups != null && null != (outputFileGroup = currFileGroups.findPackagingFileGroup("project-output"))) {
            SelectionRules newSelectionRules = this._createSelectionRulesFromExisting(outputFileGroup.getFilters(), includePatternList, excludePatternList, includePatternIgnoreList);
            outputFileGroup.setFilters(newSelectionRules);
        }
    }

    private void _setHasManifest(ArchiveProfile archiveProfile, boolean hasManifest) {
        ArchiveOptions currOptions = archiveProfile.getArchiveOptions();
        currOptions.setHasManifest(hasManifest);
        archiveProfile.setArchiveOptions(currOptions);
    }

    private void _addClassJarFileGroupToProject(Project project, ArchiveProfile projectProfile, ArchiveProfile classProfile, ApplicationArchiveFileUtils fileUtils) {
        FileGroups projectFileGroups = projectProfile.getFileGroups();
        if (projectFileGroups != null) {
            PackagingFileGroup classJarPackagingGroup = new PackagingFileGroup(_PROJECT_CLASS_PACKAGING_FILE_GROUP_NAME, _PROJECT_CLASS_PACKAGING_FILE_GROUP_NAME);
            Contributor classJarContributor = new Contributor(1, URLFileSystem.getParent((URL)classProfile.getJarURL()));
            classJarPackagingGroup.addContributor(classJarContributor);
            String classLibTargetDir = fileUtils.getClassLibTargetWithinProjectJar(project);
            classJarPackagingGroup.setTargetWithinJar(classLibTargetDir);
            classJarPackagingGroup.setFilters(SelectionRules.newDefaultSelectionRules());
            projectFileGroups.addFileGroup((FileGroup)classJarPackagingGroup);
            projectProfile.setFileGroups(projectFileGroups);
        }
    }

    private String _getApplicationSourcePattern(Workspace workspace, ApplicationArchiveFileUtils fileUtils) {
        URL appSourceUrl = McAppUtils.getSourceDir(workspace);
        String relativeDir = fileUtils.getWorkspaceRelativeDir(appSourceUrl);
        String sourcePattern = "";
        if (ModelUtil.hasLength((String)relativeDir)) {
            sourcePattern = !relativeDir.endsWith("/") ? String.format("%s%s", "/") : relativeDir;
        }
        return sourcePattern;
    }

    private List<String> _getDeployFolderPattern(ArchiveProfile profile, ApplicationArchiveFileUtils fileUtils) {
        ArrayList<String> deployFolderFilterList = new ArrayList<String>();
        String DEFAULT_DEPLOY_FOLDER_PATTERN = "**/deploy*/";
        deployFolderFilterList.add("**/deploy*/");
        URL deployOutputDirectoryUrl = fileUtils.getProfileOutputDirectoryUrl(profile);
        String lastFolder = URLFileSystem.getName((URL)deployOutputDirectoryUrl);
        String projectOutputFolderFilter = String.format("%s%s%s", _FILTER_PATTERN_WILD_CARD_PREFIX, lastFolder, _FILTER_PATTERN_WILD_CARD_SUFFIX);
        deployFolderFilterList.add(projectOutputFolderFilter);
        return deployFolderFilterList;
    }

    private List<String> _getClassesFolderPattern(Project project, ApplicationArchiveFileUtils fileUtils) {
        ArrayList<String> classesFilterList = new ArrayList<String>();
        String DEFAULT_CLASSES_FOLDER_PATTERN = "**/classes/**";
        classesFilterList.add("**/classes/**");
        URL projectOutputDirectoryUrl = fileUtils.getProjectOutputDirectoryUrl(project);
        String lastFolder = URLFileSystem.getName((URL)projectOutputDirectoryUrl);
        String projectOutputFolderFilter = String.format("%s%s%s", _FILTER_PATTERN_WILD_CARD_PREFIX, lastFolder, _FILTER_PATTERN_WILD_CARD_SUFFIX);
        classesFilterList.add(projectOutputFolderFilter);
        return classesFilterList;
    }

    private void _updateApplicationProfile(ApplicationArchiveProfile appProfile, Context context) {
        Workspace workspace = context.getWorkspace();
        ApplicationArchiveFileUtils fileUtils = new ApplicationArchiveFileUtils(workspace, appProfile);
        ArrayList<String> includePatternList = new ArrayList<String>();
        includePatternList.add(_ALL_FILES_PATTERN);
        ArrayList<String> excludePatternList = new ArrayList<String>();
        excludePatternList.addAll(this._getProjectFolderUrlFilters(workspace, fileUtils));
        excludePatternList.addAll(this._getDeployFolderPattern(appProfile, fileUtils));
        excludePatternList.add(this._getApplicationSourcePattern(workspace, fileUtils));
        excludePatternList.add(_JAVA_FILE_PATTERN);
        excludePatternList.add(_CLASS_FILE_PATTERN);
        excludePatternList.add(_DATA_FOLDER_PATTERN);
        ArrayList<String> includePatternIgnoreList = new ArrayList<String>();
        includePatternIgnoreList.add(_JAVA_FILE_EXT);
        includePatternIgnoreList.add(_CLASS_FILE_EXT);
        PackagingFileGroup appSourcePackagingGroup = new PackagingFileGroup(_APP_SOURCE_PACKAGING_FILE_GROUP_NAME, _APP_SOURCE_PACKAGING_FILE_GROUP_NAME);
        appSourcePackagingGroup.setFilters(SelectionRules.newDefaultSelectionRules());
        SelectionRules newSelectionRules = this._createSelectionRulesFromExisting(appSourcePackagingGroup.getFilters(), includePatternList, excludePatternList, includePatternIgnoreList);
        appSourcePackagingGroup.setFilters(newSelectionRules);
        Contributor applicationArtifactsContributor = new Contributor(1, URLFileSystem.getParent((URL)workspace.getURL()));
        appSourcePackagingGroup.addContributor(applicationArtifactsContributor);
        FileGroups fileGroups = appProfile.getFileGroups();
        fileGroups.addFileGroup((FileGroup)appSourcePackagingGroup);
        appProfile.setFileGroups(fileGroups);
    }

    private List<String> _getProjectFolderUrlFilters(Workspace workspace, ApplicationArchiveFileUtils fileUtils) {
        ArrayList<String> projectFilterList = new ArrayList<String>();
        for (Project currProject : workspace.projects()) {
            String projectRelativePathFromWorkspace = fileUtils.getProjectRelativeDir(currProject);
            String[] relPathParts = projectRelativePathFromWorkspace.split("/");
            if (null == relPathParts || relPathParts.length <= 0) continue;
            String currProjectFilter = String.format("%s%s", relPathParts[0], "/");
            projectFilterList.add(currProjectFilter);
        }
        return projectFilterList;
    }

    private void _addExternalLibFileGroupToProject(ArchiveProfile projectProfile, Map<String, List<String>> externalLibMap) {
        ArrayList<String> excludePatternList = new ArrayList<String>();
        ArrayList<String> includePatternIgnoreList = new ArrayList<String>();
        includePatternIgnoreList.add(_ALL_FILES_PATTERN);
        ArrayList<String> includePatternList = new ArrayList<String>();
        FileGroups projectFileGroups = projectProfile.getFileGroups();
        if (null != projectFileGroups) {
            PackagingFileGroup libJarPackagingGroup = new PackagingFileGroup(_PROJECT_EXTERNAL_LIBS_PACKAGING_FILE_GROUP_NAME, _PROJECT_EXTERNAL_LIBS_PACKAGING_FILE_GROUP_NAME);
            for (Map.Entry<String, List<String>> currEntry : externalLibMap.entrySet()) {
                String currFolderPath = currEntry.getKey();
                URL currFolderUrl = URLFactory.newDirURL((String)currFolderPath);
                List<String> currJarFilelList = currEntry.getValue();
                Contributor currFolderContrib = new Contributor(1, currFolderUrl);
                libJarPackagingGroup.addContributor(currFolderContrib);
                for (String currJarFileName : currJarFilelList) {
                    includePatternList.add(currJarFileName);
                }
            }
            libJarPackagingGroup.setTargetWithinJar(_PROJECT_EXTERNAL_JAR_DIR_NAME);
            libJarPackagingGroup.setFilters(SelectionRules.newDefaultSelectionRules());
            SelectionRules newSelectionRules = this._createSelectionRulesFromExisting(libJarPackagingGroup.getFilters(), includePatternList, excludePatternList, includePatternIgnoreList);
            libJarPackagingGroup.setFilters(newSelectionRules);
            projectFileGroups.addFileGroup((FileGroup)libJarPackagingGroup);
            projectProfile.setFileGroups(projectFileGroups);
        }
    }

    private void _maybeAddExternalLibFileGroup(Project project, ArchiveProfile archiveProfile, ApplicationArchiveFileUtils fileUtils) {
        JProjectLibraries projectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        JLibrary[] jLibraryArray = projectLibraries.getLibraries();
        URL projectDirUrl = fileUtils.getProjectFolderUrl(project);
        HashMap<String, List<String>> externalLibMap = new HashMap<String, List<String>>();
        if (null != jLibraryArray) {
            for (int i = 0; i < jLibraryArray.length; ++i) {
                URL[] entriesUrlArray;
                JLibrary currJLibrary = jLibraryArray[i];
                URLPath classUrlPath = currJLibrary.getClassPath();
                if (null == classUrlPath || null == (entriesUrlArray = classUrlPath.getEntries())) continue;
                for (int j = 0; j < entriesUrlArray.length; ++j) {
                    String currJarFileName;
                    List jarList;
                    URL currEntryUrl;
                    URL currFileUrl = currEntryUrl = entriesUrlArray[j];
                    if (JarUtil.isJarURL((URL)currEntryUrl)) {
                        currFileUrl = JarUtil.getJarFileURL((URL)currEntryUrl);
                    }
                    if (URLFileSystem.isBaseURLFor((URL)projectDirUrl, (URL)currFileUrl)) continue;
                    URL fileFolderUrl = URLFileSystem.getParent((URL)currFileUrl);
                    String fileFolderPath = URLFileSystem.getPath((URL)fileFolderUrl);
                    if (!externalLibMap.containsKey(fileFolderPath)) {
                        externalLibMap.put(fileFolderPath, new ArrayList());
                    }
                    if ((jarList = (List)externalLibMap.get(fileFolderPath)).contains(currJarFileName = URLFileSystem.getFileName((URL)currFileUrl))) continue;
                    jarList.add(currJarFileName);
                }
            }
        }
        if (!externalLibMap.isEmpty()) {
            this._addExternalLibFileGroupToProject(archiveProfile, externalLibMap);
        }
    }
}

