/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.applicationarchive.deployers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.applicationarchive.ApplicationArchiveProfile;
import oracle.adfmf.framework.dt.deploy.applicationarchive.deployers.ApplicationArchiveFileUtils;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.jar.ArchiveDeployer;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.ApplicationLibraries;

public class ApplicationArchiveJarDeployer
extends ArchiveDeployer {
    public ApplicationArchiveJarDeployer(int deploySequenceId, DeployShell deployShell) {
        super(deploySequenceId, deployShell);
    }

    public void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        ApplicationArchiveProfile appProfile = ApplicationArchiveProfile.newApplicationArchiveProfile(deployShell);
        ApplicationArchiveFileUtils fileUtils = new ApplicationArchiveFileUtils(deployShell.getContext().getWorkspace(), appProfile);
        this._removeDuplicateEntries(fileUtils);
        super.deployImpl(deploySequenceId, deployShell);
        try {
            URL destUrl = fileUtils.getDeployMobileArchiveUrl();
            FileUtils.unZipFile(appProfile.getJarURL(), destUrl);
            URLFileSystem.delete((URL)appProfile.getJarURL());
            this._maybeRenameAdfFolder(fileUtils);
            this._removeDuplicatesAndCreateNewProjectJars(appProfile, fileUtils);
            this._copyExternalArtifacts(deployShell, fileUtils);
            this._createApplicationArchive(deployShell, fileUtils);
        }
        catch (Exception e) {
            String errMsg = MobileResourceUtils.getMsg("ADF-MBL-03300");
            throw new DeployException(errMsg, (Throwable)e);
        }
    }

    private void _copyExternalArtifacts(DeployShell deployShell, ApplicationArchiveFileUtils fileUtils) throws IOException {
        Workspace workspace = deployShell.getContext().getWorkspace();
        ApplicationLibraries applicationLibraries = ApplicationLibraries.getInstance((Workspace)workspace);
        URL appRootUrl = URLFileSystem.getParent((URL)workspace.getURL());
        URL deployAppLevelExternalLibsUrl = fileUtils.getDeployApplicationLevelExternalLibsDirectoryUrl();
        List libraryList = applicationLibraries.getLibraryReferences();
        for (JLibrary currLib : libraryList) {
            URL[] currUrlPathEntriesArray;
            URLPath currUrlPath = currLib.getClassPath();
            URL[] arr$ = currUrlPathEntriesArray = currUrlPath.getEntries();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                URL currUrl;
                URL currFileUrl = currUrl = arr$[i$];
                if (JarUtil.isJarURL((URL)currUrl)) {
                    currFileUrl = JarUtil.getJarFileURL((URL)currUrl);
                }
                if (!URLFileSystem.exists((URL)currFileUrl) || URLFileSystem.isBaseURLFor((URL)appRootUrl, (URL)currFileUrl)) continue;
                if (URLFileSystem.isDirectoryPath((URL)currFileUrl)) {
                    FileUtils.copyDirectoryInclusive(currFileUrl, deployAppLevelExternalLibsUrl);
                    continue;
                }
                FileUtils.copyFile(currFileUrl, deployAppLevelExternalLibsUrl, null);
            }
        }
    }

    private void _createApplicationArchive(DeployShell deployShell, ApplicationArchiveFileUtils fileUtils) throws IOException {
        Logger logger = deployShell.getLogger();
        String infoMsg = MobileResourceUtils.getMsg("ADF-MBL-23100");
        logger.info(infoMsg);
        URL mobileArchiveDirectoryUrl = fileUtils.getDeployMobileArchiveUrl();
        URL appArchiveDestUrl = fileUtils.getApplicationArchiveJarUrl();
        FileUtils.zipDirectory(mobileArchiveDirectoryUrl, appArchiveDestUrl, true);
    }

    private void _removeDuplicateEntries(ApplicationArchiveFileUtils fileUtils) {
        URL mobileArchiveDirectoryUrl = fileUtils.getDeployMobileArchiveUrl();
        URL classJarDirectoryUrl = fileUtils.getDeployClassJarDirectoryUrl();
        Iterator archiveIter = this._depMod.getArchiveEntries();
        ArrayList<String> entryNamesToDelete = new ArrayList<String>();
        while (archiveIter.hasNext()) {
            ArchiveEntry currArchiveEntry = (ArchiveEntry)archiveIter.next();
            URL currEntryUrl = currArchiveEntry.getURL();
            if (!URLFileSystem.isBaseURLFor((URL)mobileArchiveDirectoryUrl, (URL)currEntryUrl) && !URLFileSystem.isBaseURLFor((URL)classJarDirectoryUrl, (URL)currEntryUrl)) continue;
            entryNamesToDelete.add(currArchiveEntry.getName());
        }
        for (String currEntryName : entryNamesToDelete) {
            this._depMod.removeEntry(currEntryName);
        }
    }

    private void _maybeRenameAdfFolder(ApplicationArchiveFileUtils fileUtils) throws FileNotFoundException, IOException {
        URL deployAdfDirectoryUrl;
        URL deployCopyOfAppsAdfDirUrl = fileUtils.getDeploymentCopyOfApplicationAdfDirectoryUrl();
        if (null != deployCopyOfAppsAdfDirUrl && null != (deployAdfDirectoryUrl = fileUtils.getDeployAdfDirectoryUrl()) && !URLFileSystem.equals((URL)deployCopyOfAppsAdfDirUrl, (URL)deployAdfDirectoryUrl)) {
            URLFileSystem.renameEx((URL)deployCopyOfAppsAdfDirUrl, (URL)deployAdfDirectoryUrl);
        }
    }

    private void _removeDuplicatesAndCreateNewProjectJars(ApplicationArchiveProfile appProfile, ApplicationArchiveFileUtils fileUtils) throws IOException, FileNotFoundException {
        String PROJECT_ADFMSRC_META_INF_FOLDER_REL_SPEC = "adfmsrc/META-INF";
        URL projectsLibRootDir = fileUtils.getDeployProjectLibsDirectoryUrl();
        URL projectsMobileArchiveRootDir = fileUtils.getDeployMobileArchiveProjectJarUrl();
        FileUtils.createDirectory(projectsMobileArchiveRootDir);
        Iterator iter = appProfile.getDependencies();
        while (iter.hasNext()) {
            ArchiveProfile currProfile;
            DataContainer currDataContainer;
            Dependable currDependable = (Dependable)iter.next();
            Element source = currDependable.getSource();
            if (!(source instanceof ArchiveProfile) || !((currDataContainer = (currProfile = (ArchiveProfile)source).getDataContainer()) instanceof Project)) continue;
            Project currProject = (Project)currDataContainer;
            URL currJarUrl = currProfile.getJarURL();
            String currExtractedJarFolderName = URLFileSystem.getName((URL)currJarUrl);
            URL extractedJarFolderUrl = URLFactory.newDirURL((URL)projectsLibRootDir, (String)currExtractedJarFolderName);
            if (!URLFileSystem.exists((URL)currJarUrl)) continue;
            FileUtils.unZipFile(currJarUrl, extractedJarFolderUrl);
            URL rootMetaInfUrl = URLFactory.newDirURL((URL)extractedJarFolderUrl, (String)"META-INF");
            String currProjectRelativePath = fileUtils.getProjectRelativeDir(currProject);
            URL adfmsrcDirUrl = URLFactory.newDirURL((URL)projectsLibRootDir, (String)currProjectRelativePath);
            URL adfmsrcMetaInfUrl = URLFactory.newDirURL((URL)adfmsrcDirUrl, (String)"adfmsrc/META-INF");
            this._removeDuplicateFiles(adfmsrcMetaInfUrl, rootMetaInfUrl);
            URL newJarUrl = URLFactory.newDirURL((URL)projectsMobileArchiveRootDir, (String)URLFileSystem.getFileName((URL)currJarUrl));
            FileUtils.zipDirectory(extractedJarFolderUrl, newJarUrl, false);
        }
    }

    private void _removeDuplicateFiles(URL dirUrlSrc, URL dirUrlToDeleteFrom) throws IOException {
        URL[] children = URLFileSystem.list((URL)dirUrlSrc);
        if (null == children) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            if (URLFileSystem.isDirectory((URL)children[i])) {
                String dirName = URLFileSystem.getFileName((URL)children[i]);
                this._removeDuplicateFiles(children[i], URLFactory.newDirURL((URL)dirUrlToDeleteFrom, (String)dirName));
                continue;
            }
            String suffix = URLFileSystem.getSuffix((URL)children[i]);
            URL destWithSuffix = URLFactory.newURL((URL)dirUrlToDeleteFrom, (String)(URLFileSystem.getName((URL)children[i]) + suffix));
            FileUtils.deleteFile(destWithSuffix);
        }
    }
}

