/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.applicationarchive.deployers;

import java.io.FileNotFoundException;
import java.net.URL;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.deploy.applicationarchive.ApplicationArchiveProfile;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;

public class ApplicationArchiveFileUtils {
    private Workspace _workspace;
    private ApplicationArchiveProfile _profile;
    private static final String _MOBILE_ARCHIVE_DEPLOY_FOLDER_NAME = "mobilearchive";
    private static final String _MOBILE_ARCHIVE_DEPLOY_CLASS_LIBRARY_FOLDER_NAME = "classlibs";
    private static final String _MOBILE_ARCHIVE_DEPLOY_PROJECT_JAR_FOLDER_NAME = "projectlibs";
    private static final String _PROJECTS_FOLDER_NAME = "Projects";
    private static final String _DEPLOY_FARS_FOLDER_NAME = "FARs";
    private static final String _DEPLOY_EXTERNAL_LIBS_FOLDER_NAME = "ExternalLibs";
    private static final String _JAVA_FILE_EXT = ".java";

    public ApplicationArchiveFileUtils(Workspace workspace, ApplicationArchiveProfile profile) {
        if (null == workspace || null == profile) {
            throw new IllegalArgumentException();
        }
        this._workspace = workspace;
        this._profile = profile;
    }

    public URL getDeployProjectLibsDirectoryUrl() {
        URL projectsDirUrl = URLFactory.newDirURL((URL)this.getDeployOutputDirectoryUrl(), (String)_MOBILE_ARCHIVE_DEPLOY_PROJECT_JAR_FOLDER_NAME);
        return projectsDirUrl;
    }

    public URL getDeployMobileArchiveProjectJarUrl() {
        URL projectsDirUrl = URLFactory.newDirURL((URL)this.getDeployMobileArchiveUrl(), (String)_PROJECTS_FOLDER_NAME);
        return projectsDirUrl;
    }

    public URL getDeployClassJarDirectoryUrl() {
        URL classJarDirUrl = URLFactory.newDirURL((URL)this.getDeployOutputDirectoryUrl(), (String)_MOBILE_ARCHIVE_DEPLOY_CLASS_LIBRARY_FOLDER_NAME);
        return classJarDirUrl;
    }

    public URL getWorkspaceFolderUrl() {
        URL workspaceFolderUrl = URLFileSystem.getParent((URL)this._workspace.getURL());
        return workspaceFolderUrl;
    }

    public URL getDeployMobileArchiveUrl() {
        URL mobileArchiveDirUrl = URLFactory.newDirURL((URL)this.getDeployOutputDirectoryUrl(), (String)_MOBILE_ARCHIVE_DEPLOY_FOLDER_NAME);
        return mobileArchiveDirUrl;
    }

    public URL getDeployOutputDirectoryUrl() {
        return URLFileSystem.getParent((URL)this._profile.getJarURL());
    }

    public URL getProjectJarUrl(Project project) {
        String projectJarFileName = String.format("%s%s", this.getProjectFolderName(project), ".jar");
        URL projectJarUrl = URLFactory.newDirURL((URL)this.getDeployProjectLibsDirectoryUrl(), (String)projectJarFileName);
        return projectJarUrl;
    }

    public URL getClassJarUrl(Project project) {
        URL classJarRootDirUrl = this.getDeployClassJarDirectoryUrl();
        String projectRelativePathFromWorkspace = this.getProjectRelativeDir(project);
        URL classJarUrl = URLFactory.newDirURL((URL)classJarRootDirUrl, (String)projectRelativePathFromWorkspace);
        String classFileJarName = this._getClassFileJarName(project);
        URL newJarUrl = URLFactory.newDirURL((URL)classJarUrl, (String)classFileJarName);
        return newJarUrl;
    }

    public URL getProjectFolderUrl(Project project) {
        URL projectUrl = project.getURL();
        return URLFileSystem.getParent((URL)projectUrl);
    }

    public String getProjectFolderName(Project project) {
        return URLFileSystem.getName((URL)this.getProjectRootFolderUrl(project));
    }

    public URL getProjectRootFolderUrl(Project project) {
        String projectRelativePathFromWorkspace = this.getProjectRelativeDir(project);
        String[] relPathParts = projectRelativePathFromWorkspace.split("/");
        URL projectRootFolderUrl = null;
        if (null != relPathParts && relPathParts.length > 0) {
            projectRootFolderUrl = URLFactory.newDirURL((URL)this.getWorkspaceFolderUrl(), (String)relPathParts[0]);
        }
        return projectRootFolderUrl;
    }

    public boolean doesProjectContainJavaFiles(Project project) {
        URL projectFolderUrl = this.getProjectRootFolderUrl(project);
        return this._directoryHasJavaFiles(projectFolderUrl);
    }

    public URL getProfileOutputDirectoryUrl(ArchiveProfile archiveProfile) {
        return URLFileSystem.getParent((URL)archiveProfile.getJarURL());
    }

    public URL getProjectOutputDirectoryUrl(Project project) {
        URL projectOutputDirectoryUrl = JavaProject.getInstance((Project)project).getOutputDirectory();
        return projectOutputDirectoryUrl;
    }

    public URL getDeployAdfDirectoryUrl() throws FileNotFoundException {
        URL deployAdfDirectoryUrl = null;
        URL deployCopyOfAdfUrl = this.getDeploymentCopyOfApplicationAdfDirectoryUrl();
        if (null != deployCopyOfAdfUrl) {
            String adfFolderName = URLFileSystem.getName((URL)deployCopyOfAdfUrl);
            if (adfFolderName.startsWith(".")) {
                adfFolderName = adfFolderName.substring(1);
            }
            deployAdfDirectoryUrl = URLFactory.newDirURL((URL)this.getDeployMobileArchiveUrl(), (String)adfFolderName);
        }
        return deployAdfDirectoryUrl;
    }

    public URL getDeploymentCopyOfApplicationAdfDirectoryUrl() throws FileNotFoundException {
        URL appAdfDirIUrl = McAppUtils.getApplicationAdfFolderUrl(this._workspace);
        assert (null != appAdfDirIUrl);
        String adfSourceDirectoryPath = URLFileSystem.getPlatformPathName((URL)appAdfDirIUrl);
        String adfFolderName = URLFileSystem.getSuffix((URL)URLFactory.newURL((String)adfSourceDirectoryPath));
        URL deployCopyOfAppAdfDirectoryUrl = URLFactory.newDirURL((URL)this.getDeployMobileArchiveUrl(), (String)adfFolderName);
        return deployCopyOfAppAdfDirectoryUrl;
    }

    public URL getDeployFarsDirectoryUrl() {
        return URLFactory.newDirURL((URL)this.getDeployMobileArchiveUrl(), (String)_DEPLOY_FARS_FOLDER_NAME);
    }

    public URL getApplicationArchiveJarUrl() {
        return this._profile.getJarURL();
    }

    public URL getDeployApplicationLevelExternalLibsDirectoryUrl() {
        return URLFactory.newDirURL((URL)this.getDeployMobileArchiveUrl(), (String)_DEPLOY_EXTERNAL_LIBS_FOLDER_NAME);
    }

    private boolean _directoryHasJavaFiles(URL directory) {
        URL[] children = URLFileSystem.list((URL)directory);
        boolean hasJavaFiles = false;
        for (int i = 0; i < children.length; ++i) {
            if (URLFileSystem.isDirectory((URL)children[i])) {
                hasJavaFiles = this._directoryHasJavaFiles(children[i]);
            } else if (URLFileSystem.getSuffix((URL)children[i]).equals(_JAVA_FILE_EXT)) {
                hasJavaFiles = true;
            }
            if (hasJavaFiles) break;
        }
        return hasJavaFiles;
    }

    private String _getClassFileJarName(Project project) {
        String defaultClassFileJarName = "mobileApplicationArchive";
        JProjectLibraries jpl = JProjectLibraries.getInstance((PropertyStorage)project);
        JLibrary[] referencedLibrariesArray = jpl.getLibraries();
        String classJarFileNamePrefixLC = "mobileApplicationArchive".toLowerCase();
        int maxJarNumber = 0;
        if (null != referencedLibrariesArray) {
            for (int i = 0; i < referencedLibrariesArray.length; ++i) {
                JLibrary currLib = referencedLibrariesArray[i];
                String currLibJarName = currLib.getName().toLowerCase();
                String currLibName = currLibJarName.replaceAll(".jar", "");
                if (!currLibName.startsWith(classJarFileNamePrefixLC)) continue;
                String currJarFileNum = currLibName.substring(classJarFileNamePrefixLC.length());
                if (ModelUtil.hasLength((String)currJarFileNum)) {
                    try {
                        int currJarNumber = Integer.valueOf(currJarFileNum, 10);
                        if (currJarNumber <= maxJarNumber) continue;
                        maxJarNumber = currJarNumber;
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                if (maxJarNumber != 0) continue;
                ++maxJarNumber;
            }
        }
        String classFileJarName = null;
        if (0 < maxJarNumber) {
            String STRING_FORMAT = "%s%d%s";
            classFileJarName = String.format("%s%d%s", "mobileApplicationArchive", ++maxJarNumber, ".jar");
        } else {
            classFileJarName = String.format("%s%s", "mobileApplicationArchive", ".jar");
        }
        return classFileJarName;
    }

    public String getWorkspaceRelativeDir(URL url) {
        URL workspaceFolderUrl = this.getWorkspaceFolderUrl();
        String relSpec = URLFileSystem.toRelativeSpec((URL)url, (URL)workspaceFolderUrl, (boolean)true);
        return relSpec;
    }

    public String getProjectRelativeDir(Project project) {
        URL projectFolderUrl = this.getProjectFolderUrl(project);
        URL workspaceFolderUrl = this.getWorkspaceFolderUrl();
        String relSpec = URLFileSystem.toRelativeSpec((URL)projectFolderUrl, (URL)workspaceFolderUrl, (boolean)true);
        return relSpec;
    }

    public String getClassLibTargetWithinProjectJar(Project project) {
        String _LIB_FOLDER = "classlib";
        String projectRelPathFromWsp = this.getProjectRelativeDir(project);
        String[] folderNames = projectRelPathFromWsp.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < folderNames.length; ++i) {
            sb.append(folderNames[i]);
            sb.append("/");
        }
        sb.append("classlib");
        String targetWithinJar = sb.toString();
        return targetWithinJar;
    }
}

