/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.applicationarchive.deployers;

import java.util.HashMap;
import java.util.Map;
import oracle.adfmf.framework.dt.deploy.applicationarchive.deployers.ApplicationArchiveJarDeployer;
import oracle.adfmf.framework.dt.deploy.applicationarchive.deployers.PreparePackagingDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.ApplicationXmlValidatorDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.ProjectXmlValidatorDeployer;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.common.BatchDeployer;
import oracle.jdeveloper.deploy.common.BuildDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;
import oracle.jdeveloper.deploy.common.ModulePackager;
import oracle.jdeveloper.deploy.jar.JarDeployerFactory;
import oracle.jdevimpl.deploy.common.ProfileDependencyAnalyzer;

public class ApplicationArchiveDeployerFactory
implements DeployerFactory {
    public static int getApplicationArchiveDeploymentSequenceId() {
        return ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_BATCH_DEPLOYER_ID.getInt();
    }

    public Deployer newDeployer(int deploySequenceId, DeployShell deployShell) {
        if (!ApplicationArchiveDeployerSequenceId.contains(deploySequenceId)) {
            return null;
        }
        ApplicationArchiveDeployerSequenceId appArchiveId = ApplicationArchiveDeployerSequenceId.fromInt(deploySequenceId);
        Object newDeployer = null;
        switch (appArchiveId) {
            case APPLICATION_ARCHIVE_BATCH_DEPLOYER_ID: {
                newDeployer = this._createApplicationArchiveBatchDeployer();
                break;
            }
            case APPLICATION_ARCHIVE_SEQUENCE_ID: {
                newDeployer = new DynamicDeployer(ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_JAR_DEPLOYER_ID.m_value);
                break;
            }
            case APPLICATION_ARCHIVE_JAR_DEPLOYER_ID: {
                newDeployer = new ApplicationArchiveJarDeployer(deploySequenceId, deployShell);
                break;
            }
            case APPLICATION_ARCHIVE_PACKAGING_SEQUENCE_ID: {
                newDeployer = this._createPackagingBatchDeployer(deployShell);
                break;
            }
            case APPLICATION_ARCHIVE_DEPENDENCY_ANALYZER_DEPLOYER_ID: {
                newDeployer = new ProfileDependencyAnalyzer(deploySequenceId, deployShell);
                break;
            }
            case APPLICATION_ARCHIVE_BUILD_DEPLOYER_ID: {
                newDeployer = new BuildDeployer(deploySequenceId, deployShell);
                break;
            }
            case APPLICATION_ARCHIVE_MODULE_PACKAGER_DEPLOYER_ID: {
                newDeployer = new ModulePackager(deploySequenceId, deployShell);
                break;
            }
            case APPLICATION_ARCHIVE_PREPARE_PACKAGING_DEPLOYER_ID: {
                newDeployer = new PreparePackagingDeployer(deploySequenceId);
                break;
            }
            case APPLICATION_ARCHIVE_APPLICATION_XML_VALIDATOR_DEPLOYER_ID: {
                newDeployer = new ApplicationXmlValidatorDeployer(deploySequenceId);
                break;
            }
            case APPLICATION_ARCHIVE_PROJECT_XML_VALIDATOR_DEPLOYER_ID: {
                newDeployer = new ProjectXmlValidatorDeployer(deploySequenceId, false);
                break;
            }
        }
        return newDeployer;
    }

    private Deployer _createPackagingBatchDeployer(DeployShell deployShell) {
        BatchDeployer newDeployer = null;
        newDeployer = deployShell.getFlag("ignoreDependencies") ? new BatchDeployer(ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_PACKAGING_SEQUENCE_ID.getInt(), new int[]{ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_BUILD_DEPLOYER_ID.getInt(), ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_MODULE_PACKAGER_DEPLOYER_ID.getInt()}) : new BatchDeployer(ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_PACKAGING_SEQUENCE_ID.getInt(), new int[]{ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_DEPENDENCY_ANALYZER_DEPLOYER_ID.getInt(), ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_BUILD_DEPLOYER_ID.getInt(), ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_MODULE_PACKAGER_DEPLOYER_ID.getInt()});
        return newDeployer;
    }

    private Deployer _createApplicationArchiveBatchDeployer() {
        return new BatchDeployer(ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_BATCH_DEPLOYER_ID.getInt(), new int[]{ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_PREPARE_PACKAGING_DEPLOYER_ID.getInt(), ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_APPLICATION_XML_VALIDATOR_DEPLOYER_ID.getInt(), ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_PROJECT_XML_VALIDATOR_DEPLOYER_ID.getInt(), ApplicationArchiveDeployerSequenceId.APPLICATION_ARCHIVE_PACKAGING_SEQUENCE_ID.getInt()});
    }

    public static enum ApplicationArchiveDeployerSequenceId {
        APPLICATION_ARCHIVE_BATCH_DEPLOYER_ID("Deployment.APPLICATION_ARCHIVE_BATCH_DEPLOYER_ID"),
        APPLICATION_ARCHIVE_PREPARE_PACKAGING_DEPLOYER_ID("Deployment.APPLICATION_ARCHIVE_PREPARE_PACKAGING_DEPLOYER_ID"),
        APPLICATION_ARCHIVE_APPLICATION_XML_VALIDATOR_DEPLOYER_ID("Deployment.APPLICATION_ARCHIVE_APPLICATION_XML_VALIDATOR_DEPLOYER_ID"),
        APPLICATION_ARCHIVE_PROJECT_XML_VALIDATOR_DEPLOYER_ID("Deployment.APPLICATION_ARCHIVE_PROJECT_XML_VALIDATOR_DEPLOYER_ID"),
        APPLICATION_ARCHIVE_SEQUENCE_ID(DeploymentConstants.DEFAULT_SEQUENCE),
        APPLICATION_ARCHIVE_JAR_DEPLOYER_ID(DeploymentConstants.ARCHIVE_DEPLOYER),
        APPLICATION_ARCHIVE_PACKAGING_SEQUENCE_ID(DeploymentConstants.PACKAGING_SEQUENCE),
        APPLICATION_ARCHIVE_DEPENDENCY_ANALYZER_DEPLOYER_ID(JarDeployerFactory.DEPENDENCY_ANALYZER),
        APPLICATION_ARCHIVE_BUILD_DEPLOYER_ID(DeploymentConstants.BUILD_DEPLOYER),
        APPLICATION_ARCHIVE_MODULE_PACKAGER_DEPLOYER_ID(DeploymentConstants.MODULE_PACKAGER);

        private int m_value;
        private static Map<Integer, ApplicationArchiveDeployerSequenceId> s_appArchiveDeployerMap;

        public int getInt() {
            return this.m_value;
        }

        public static boolean contains(int deploySequenceId) {
            return s_appArchiveDeployerMap.containsKey(deploySequenceId);
        }

        public static ApplicationArchiveDeployerSequenceId fromInt(int deploySequenceId) {
            if (s_appArchiveDeployerMap.containsKey(deploySequenceId)) {
                return s_appArchiveDeployerMap.get(deploySequenceId);
            }
            throw new IllegalArgumentException();
        }

        private ApplicationArchiveDeployerSequenceId(String stringIdentifier) {
            this.m_value = DeploymentManager.getDeploymentSequenceId((String)stringIdentifier);
        }

        private ApplicationArchiveDeployerSequenceId(int intIdentifier) {
            this.m_value = intIdentifier;
        }

        static {
            s_appArchiveDeployerMap = new HashMap<Integer, ApplicationArchiveDeployerSequenceId>();
            for (ApplicationArchiveDeployerSequenceId id : ApplicationArchiveDeployerSequenceId.values()) {
                s_appArchiveDeployerMap.put(id.m_value, id);
            }
        }
    }
}

