/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.applicationarchive;

import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.applicationarchive.ApplicationArchiveProfile;
import oracle.ide.Context;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.FileGroups;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.SelectionRules;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.jar.spi.ArchiveProfileFactory;

public class ApplicationArchiveProfileFactory
extends ArchiveProfileFactory {
    private Workspace _workspace;
    private static final String _ALL_FILES_FILTER = "**";
    private static final String _DESCRIPTORS_GROUP_INTERNAL_NAME = "descriptorGroups";

    public ArchiveProfile create(String name, DataContainer dataContainer, Context context) {
        if (null != dataContainer && dataContainer instanceof Workspace) {
            this._workspace = (Workspace)dataContainer;
        }
        if (null == this._workspace) {
            this._workspace = context.getWorkspace();
        }
        ArchiveProfile profile = super.create(name, dataContainer, context);
        PackagingFileGroup appDescriptionFileGroup = this._createApplicationDescriptorsFileGroup();
        FileGroups newFileGroups = new FileGroups();
        FileGroups currFileGroups = profile.getFileGroups();
        if (null != currFileGroups) {
            FileGroup[] currGroupArray = currFileGroups.getGroups();
            for (int i = 0; i < currGroupArray.length; ++i) {
                if (currGroupArray[i].getInternalName().equals("project-output")) continue;
                newFileGroups.addFileGroup(currGroupArray[i]);
            }
        }
        newFileGroups.addFileGroup((FileGroup)appDescriptionFileGroup);
        profile.setFileGroups(newFileGroups);
        return profile;
    }

    protected ArchiveProfile newArchiveProfile() {
        assert (null != this._workspace);
        return ApplicationArchiveProfile.newApplicationArchiveProfile(this._workspace);
    }

    private PackagingFileGroup _createApplicationDescriptorsFileGroup() {
        String META_INF_FILTER = "META-INF/MANIFEST.MF";
        String descriptorsGroupDisplayName = MobileResourceUtils.getText("APPLICATION_ARCHIVE_DESCRIPTORS_GROUP_NAME");
        PackagingFileGroup appDescFileGroup = new PackagingFileGroup(descriptorsGroupDisplayName, _DESCRIPTORS_GROUP_INTERNAL_NAME);
        SelectionRules appSourceFilterSelectionRules = new SelectionRules();
        appSourceFilterSelectionRules.addInclude(_ALL_FILES_FILTER, true);
        appSourceFilterSelectionRules.addExclude("META-INF/MANIFEST.MF", true);
        Contributor appSourceContributor = new Contributor(9, null);
        appDescFileGroup.addContributor(appSourceContributor);
        appDescFileGroup.setFilters(appSourceFilterSelectionRules);
        return appDescFileGroup;
    }
}

