/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.applicationarchive;

import java.net.URL;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.McProfile;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.PlatformDeployable;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.deploy.shell.JavaDeployment;

public class ApplicationArchiveProfile
extends McProfile
implements PlatformDeployable {
    private Workspace _workspace;
    private static final Platform _PLATFORM_APP_ARCHIVE = new Platform(PlatformType.JSE, "1.4", MobileResourceUtils.getText("APPLICATION_ARCHIVE_DT_SHORT_LABEL"), null);

    public ApplicationArchiveProfile() {
    }

    public static ApplicationArchiveProfile newApplicationArchiveProfile(Workspace workspace) {
        if (null == workspace) {
            throw new IllegalArgumentException();
        }
        ApplicationArchiveProfile appArchiveProfile = new ApplicationArchiveProfile();
        appArchiveProfile._initialize(workspace);
        return appArchiveProfile;
    }

    public static ApplicationArchiveProfile newApplicationArchiveProfile(HashStructure hash, Workspace workspace) {
        if (null == workspace || null == hash) {
            throw new IllegalArgumentException();
        }
        ApplicationArchiveProfile appProfile = new ApplicationArchiveProfile(hash);
        appProfile._initialize(workspace);
        return appProfile;
    }

    public static ApplicationArchiveProfile newApplicationArchiveProfile(DeployShell deployShell) throws DeployException {
        if (null == deployShell) {
            throw new IllegalArgumentException();
        }
        JavaDeployment d = JavaDeployment.getInstance((DeployShell)deployShell);
        Profile profile = d.getProfile();
        assert (profile != null);
        if (!(profile instanceof ApplicationArchiveProfile)) {
            throw new DeployException("Deployment Profile is not a subclass of ApplicationArchiveProfile.");
        }
        ApplicationArchiveProfile appProfile = (ApplicationArchiveProfile)profile;
        assert (null != appProfile._workspace);
        assert (null != appProfile.getDataContainer());
        return appProfile;
    }

    public Platform getPlatform() {
        return _PLATFORM_APP_ARCHIVE;
    }

    public void setPlatform(Platform platform) {
        assert (false);
    }

    public Object copyTo(Object target) {
        this._verifyState();
        if (null != target && !(target instanceof ApplicationArchiveProfile)) {
            throw new IllegalArgumentException();
        }
        boolean copyIntoNewInstance = null == target;
        Object copy = super.copyTo(target);
        assert (copy instanceof ApplicationArchiveProfile);
        ApplicationArchiveProfile appProfile = (ApplicationArchiveProfile)((Object)copy);
        this._copyToImpl(appProfile, copyIntoNewInstance);
        return copy;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        this._verifyState();
        return this._equalsImpl((ApplicationArchiveProfile)((Object)o));
    }

    public int hashCode() {
        this._verifyState();
        int PRIME = 31;
        int result = 17;
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._hash);
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._workspace);
        return result;
    }

    @Override
    protected URL createAdfMobileJarUrl(URL jarUrl) {
        this._verifyState();
        if (null == this.getJarURL()) {
            String maaFileName = String.format("%s%s", URLFileSystem.getName((URL)jarUrl), ".maa");
            URL deployDirUrl = URLFileSystem.getParent((URL)jarUrl);
            URL deploymentProfileDirUrl = URLFactory.newDirURL((URL)deployDirUrl, (String)this.getName());
            return URLFactory.newDirURL((URL)deploymentProfileDirUrl, (String)maaFileName);
        }
        return jarUrl;
    }

    @Override
    protected Workspace getWorkspace() {
        return this._workspace;
    }

    private void _copyToImpl(ApplicationArchiveProfile otherAppProfile, boolean copyIntoNewInstance) {
        if (!copyIntoNewInstance) {
            otherAppProfile._workspace = null;
        }
        otherAppProfile._initialize(this._workspace);
    }

    private boolean _equalsImpl(ApplicationArchiveProfile otherProfile) {
        return super.equals((Object)otherProfile) && ModelUtil.areEqual((Object)this._workspace, (Object)otherProfile._workspace);
    }

    private void _initialize(Workspace workspace) {
        if (null == workspace) {
            throw new IllegalArgumentException();
        }
        if (null != this._workspace) {
            throw new IllegalStateException();
        }
        this._workspace = workspace;
        this.setDataContainer((DataContainer)this._workspace);
        this.getArchiveOptions().setHasManifest(false);
    }

    private void _verifyState() {
        if (null == this._workspace || null == this.getDataContainer()) {
            throw new IllegalStateException();
        }
    }

    private ApplicationArchiveProfile(HashStructure hashStructure) {
        super(hashStructure);
    }
}

